/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.combiners;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.combiners.Histogram;
import org.apache.beam.sdk.testing.CombineFnTester;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Doubles;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Longs;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.Parameterized;

public class HistogramTest {

    @RunWith(value=Parameterized.class)
    public static class HistogramCombineFnParameterizedTest {
        private static final List<Double> BOUNDS = Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0);
        private final List<Double> inputList;
        private final Histogram.BoundsInclusivity boundsInclusivity;
        private final List<Long> expectedOutput;

        public HistogramCombineFnParameterizedTest(List<Double> inputList, Histogram.BoundsInclusivity boundsInclusivity, List<Long> expectedOutput) {
            this.inputList = inputList;
            this.boundsInclusivity = boundsInclusivity;
            this.expectedOutput = expectedOutput;
        }

        @Parameterized.Parameters
        public static Collection<Object[]> data() {
            return Arrays.asList({Doubles.asList((double[])new double[0]), Histogram.BoundsInclusivity.LOWER_BOUND_INCLUSIVE_UPPER_BOUND_EXCLUSIVE, Longs.asList((long[])new long[]{0L, 0L, 0L, 0L, 0L, 0L})}, {Doubles.asList((double[])new double[]{1.5}), Histogram.BoundsInclusivity.LOWER_BOUND_INCLUSIVE_UPPER_BOUND_EXCLUSIVE, Longs.asList((long[])new long[]{0L, 1L, 0L, 0L, 0L, 0L})}, {Doubles.asList((double[])new double[]{1.5}), Histogram.BoundsInclusivity.LOWER_BOUND_EXCLUSIVE_UPPER_BOUND_INCLUSIVE, Longs.asList((long[])new long[]{0L, 1L, 0L, 0L, 0L, 0L})}, {Doubles.asList((double[])new double[]{2.5}), Histogram.BoundsInclusivity.LOWER_BOUND_INCLUSIVE_UPPER_BOUND_EXCLUSIVE, Longs.asList((long[])new long[]{0L, 0L, 1L, 0L, 0L, 0L})}, {Doubles.asList((double[])new double[]{2.5}), Histogram.BoundsInclusivity.LOWER_BOUND_EXCLUSIVE_UPPER_BOUND_INCLUSIVE, Longs.asList((long[])new long[]{0L, 0L, 1L, 0L, 0L, 0L})}, {Doubles.asList((double[])new double[]{1.5, 1.5}), Histogram.BoundsInclusivity.LOWER_BOUND_INCLUSIVE_UPPER_BOUND_EXCLUSIVE, Longs.asList((long[])new long[]{0L, 2L, 0L, 0L, 0L, 0L})}, {Doubles.asList((double[])new double[]{1.5, 1.5}), Histogram.BoundsInclusivity.LOWER_BOUND_EXCLUSIVE_UPPER_BOUND_INCLUSIVE, Longs.asList((long[])new long[]{0L, 2L, 0L, 0L, 0L, 0L})}, {Doubles.asList((double[])new double[]{0.5, 1.5, 2.5, 3.5, 4.5, 5.5}), Histogram.BoundsInclusivity.LOWER_BOUND_INCLUSIVE_UPPER_BOUND_EXCLUSIVE, Longs.asList((long[])new long[]{1L, 1L, 1L, 1L, 1L, 1L})}, {Doubles.asList((double[])new double[]{0.5, 1.5, 2.5, 3.5, 4.5, 5.5}), Histogram.BoundsInclusivity.LOWER_BOUND_EXCLUSIVE_UPPER_BOUND_INCLUSIVE, Longs.asList((long[])new long[]{1L, 1L, 1L, 1L, 1L, 1L})}, {Doubles.asList((double[])new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0}), Histogram.BoundsInclusivity.LOWER_BOUND_INCLUSIVE_UPPER_BOUND_EXCLUSIVE, Longs.asList((long[])new long[]{1L, 1L, 1L, 1L, 1L, 2L})}, {Doubles.asList((double[])new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0}), Histogram.BoundsInclusivity.LOWER_BOUND_EXCLUSIVE_UPPER_BOUND_INCLUSIVE, Longs.asList((long[])new long[]{2L, 1L, 1L, 1L, 1L, 1L})});
        }

        @Test
        public void testBoundsInclusivity() {
            CombineFnTester.testCombineFn((Combine.CombineFn)Histogram.HistogramCombineFn.create((Histogram.BucketBounds)Histogram.BucketBounds.explicit(BOUNDS, (Histogram.BoundsInclusivity)this.boundsInclusivity)), this.inputList, this.expectedOutput);
        }
    }

    @RunWith(value=JUnit4.class)
    public static class HistogramCombineFnTest {
        private static final Histogram.HistogramCombineFn<Double> histogramCombineFn = Histogram.HistogramCombineFn.create((Histogram.BucketBounds)Histogram.BucketBounds.linear((double)1.0, (double)2.0, (int)4));
        private static final Histogram.HistogramAccumulator histogramAccumulator = histogramCombineFn.createAccumulator();

        @Test
        public void testAddInput_null_throwsNullPointerException() {
            Assert.assertThrows(NullPointerException.class, () -> histogramCombineFn.addInput(histogramAccumulator, null));
        }

        @Test
        public void testAddInput_nan_throwsIllegalArgumentException() {
            Assert.assertThrows(IllegalArgumentException.class, () -> histogramCombineFn.addInput(histogramAccumulator, (Object)Double.NaN));
        }

        @Test
        public void testAddInput_positiveInfinity_throwsIllegalArgumentException() {
            Assert.assertThrows(IllegalArgumentException.class, () -> histogramCombineFn.addInput(histogramAccumulator, (Object)Double.POSITIVE_INFINITY));
        }

        @Test
        public void testAddInput_negativeInfinity_throwsIllegalArgumentException() {
            Assert.assertThrows(IllegalArgumentException.class, () -> histogramCombineFn.addInput(histogramAccumulator, (Object)Double.NEGATIVE_INFINITY));
        }
    }

    @RunWith(value=Parameterized.class)
    public static class HistogramAccumulatorCoderParameterizedTest {
        private static final int NUM_BOUNDED_BUCKETS = 160;
        private static final Histogram.HistogramAccumulatorCoder CODER = new Histogram.HistogramAccumulatorCoder();
        private static final Histogram.HistogramCombineFn<Double> COMBINE_FN = Histogram.HistogramCombineFn.create((Histogram.BucketBounds)Histogram.BucketBounds.linear((double)1.0, (double)1.0, (int)160));
        private final List<Double> inputList;

        public HistogramAccumulatorCoderParameterizedTest(List<Double> inputList) {
            this.inputList = inputList;
        }

        @Parameterized.Parameters
        public static Collection<Object[]> data() {
            List emptyInput = Doubles.asList((double[])new double[0]);
            List oneInput = Doubles.asList((double[])new double[]{2.0});
            List theFirst10Elements = Doubles.asList((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0});
            List theMiddle10Elements = Doubles.asList((double[])new double[]{51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0});
            List theLast10Elements = Doubles.asList((double[])new double[]{151.0, 152.0, 153.0, 154.0, 155.0, 156.0, 157.0, 158.0, 159.0, 160.0});
            ArrayList<Double> theMiddle80Elements = new ArrayList<Double>(80);
            for (int i = 40; i < 120; ++i) {
                theMiddle80Elements.add((double)i + 0.5);
            }
            ArrayList<Double> fullInput = new ArrayList<Double>(162);
            for (int i = 0; i < 162; ++i) {
                fullInput.add((double)i + 0.5);
            }
            return Arrays.asList({emptyInput}, {oneInput}, {theFirst10Elements}, {theMiddle10Elements}, {theLast10Elements}, {theMiddle80Elements}, {fullInput});
        }

        @Test
        public void testAccumulatorCorrectlyEncodedAndDecoded() throws IOException {
            Histogram.HistogramAccumulator initialAccumulator = COMBINE_FN.createAccumulator();
            for (Double input : this.inputList) {
                COMBINE_FN.addInput(initialAccumulator, (Object)input);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            CODER.encode(initialAccumulator, (OutputStream)outputStream);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            Histogram.HistogramAccumulator decodedAccumulator = CODER.decode((InputStream)inputStream);
            Assert.assertNotNull((Object)decodedAccumulator);
            Assert.assertEquals((Object)initialAccumulator, (Object)decodedAccumulator);
        }
    }

    @RunWith(value=JUnit4.class)
    public static class HistogramAccumulatorCoderTest {
        private static final Histogram.HistogramAccumulatorCoder CODER = new Histogram.HistogramAccumulatorCoder();

        @Test
        public void testEncode_NullAccumulator_throwsNullPointerException() {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Assert.assertThrows(NullPointerException.class, () -> CODER.encode(null, (OutputStream)outputStream));
        }
    }

    @RunWith(value=JUnit4.class)
    public static class HistogramAccumulatorTest {
        private static final int NUM_BUCKETS = 2;

        @Test
        public void testNumberOfBucketsThrowsException() {
            Assert.assertThrows(IllegalArgumentException.class, () -> new Histogram.HistogramAccumulator(2));
        }
    }

    @RunWith(value=JUnit4.class)
    public static class BucketBoundsTest {
        @Test
        public void testExponentialBucketBoundsWithoutSpecifiedInclusivity() {
            Histogram.BucketBounds bucketBounds = Histogram.BucketBounds.exponential((double)1.0, (double)2.0, (int)4);
            Assert.assertEquals(Arrays.asList(1.0, 2.0, 4.0, 8.0, 16.0), (Object)bucketBounds.getBounds());
            Assert.assertEquals((Object)Histogram.BoundsInclusivity.LOWER_BOUND_INCLUSIVE_UPPER_BOUND_EXCLUSIVE, (Object)bucketBounds.getBoundsInclusivity());
        }

        @Test
        public void testExponentialBucketBoundsThrowsIllegalArgumentExceptionForScale() {
            Assert.assertThrows(IllegalArgumentException.class, () -> Histogram.BucketBounds.exponential((double)-0.4, (double)2.0, (int)4));
        }

        @Test
        public void testExponentialBucketBoundsThrowsIllegalArgumentExceptionForGrowthFactor() {
            Assert.assertThrows(IllegalArgumentException.class, () -> Histogram.BucketBounds.exponential((double)1.0, (double)0.5, (int)4));
        }

        @Test
        public void testExponentialBucketBoundsThrowsIllegalArgumentExceptionForZeroNumberBoundedOfBuckets() {
            Assert.assertThrows(IllegalArgumentException.class, () -> Histogram.BucketBounds.exponential((double)1.0, (double)2.0, (int)0));
        }

        @Test
        public void testExponentialBucketBoundsThrowsIllegalArgumentExceptionForMaxIntNumberBoundedOfBuckets() {
            Assert.assertThrows(IllegalArgumentException.class, () -> Histogram.BucketBounds.exponential((double)1.0, (double)2.0, (int)Integer.MAX_VALUE));
        }

        @Test
        public void testExponentialBucketBoundsThrowsIllegalArgumentExceptionForOverflownDoubleBound() {
            Assert.assertThrows(IllegalArgumentException.class, () -> Histogram.BucketBounds.exponential((double)1.0, (double)10.0, (int)310));
        }

        @Test
        public void testLinearBucketBoundsWithoutSpecifiedInclusivity() {
            Histogram.BucketBounds bucketBounds = Histogram.BucketBounds.linear((double)1.0, (double)2.0, (int)4);
            Assert.assertEquals(Arrays.asList(1.0, 3.0, 5.0, 7.0, 9.0), (Object)bucketBounds.getBounds());
            Assert.assertEquals((Object)Histogram.BoundsInclusivity.LOWER_BOUND_INCLUSIVE_UPPER_BOUND_EXCLUSIVE, (Object)bucketBounds.getBoundsInclusivity());
        }

        @Test
        public void testExplicitBucketBoundsWithoutSpecifiedInclusivity() {
            Histogram.BucketBounds bucketBounds = Histogram.BucketBounds.explicit(Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0));
            Assert.assertEquals(Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0), (Object)bucketBounds.getBounds());
            Assert.assertEquals((Object)Histogram.BoundsInclusivity.LOWER_BOUND_INCLUSIVE_UPPER_BOUND_EXCLUSIVE, (Object)bucketBounds.getBoundsInclusivity());
        }
    }

    @RunWith(value=JUnit4.class)
    public static class HistogramTransformTest {
        private static final Histogram.BucketBounds BUCKET_BOUNDS = Histogram.BucketBounds.exponential((double)1.0, (double)2.0, (int)4);
        private static final int INPUT_SIZE = 20;
        static final List<KV<String, Double>> TABLE = Arrays.asList(KV.of((Object)"a", (Object)1.0), KV.of((Object)"a", (Object)2.0), KV.of((Object)"a", (Object)3.0), KV.of((Object)"a", (Object)5.0), KV.of((Object)"a", (Object)4.5), KV.of((Object)"a", (Object)10.0), KV.of((Object)"b", (Object)1.0), KV.of((Object)"b", (Object)5.0), KV.of((Object)"b", (Object)5.0), KV.of((Object)"b", (Object)20.0));
        @Rule
        public TestPipeline testPipeline = TestPipeline.create();

        @Test
        @Category(value={NeedsRunner.class})
        public void testHistogramGlobally() {
            PCollection<Number> input = this.generateInputPCollection((Pipeline)this.testPipeline, 20);
            PCollection counts = (PCollection)input.apply((PTransform)Histogram.globally((Histogram.BucketBounds)BUCKET_BOUNDS));
            PAssert.that((PCollection)counts).containsInAnyOrder((Object[])new List[]{Longs.asList((long[])new long[]{1L, 1L, 2L, 4L, 8L, 4L})});
            this.testPipeline.run();
        }

        @Test
        @Category(value={NeedsRunner.class})
        public void testHistogramPerKey() {
            PCollection input = (PCollection)this.testPipeline.apply((PTransform)Create.of(TABLE).withCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)DoubleCoder.of())));
            PCollection counts = (PCollection)input.apply((PTransform)Histogram.perKey((Histogram.BucketBounds)BUCKET_BOUNDS));
            PAssert.that((PCollection)counts).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"a", (Object)Longs.asList((long[])new long[]{0L, 1L, 2L, 2L, 1L, 0L})), KV.of((Object)"b", (Object)Longs.asList((long[])new long[]{0L, 1L, 0L, 2L, 0L, 1L}))});
            this.testPipeline.run();
        }

        private PCollection<Number> generateInputPCollection(Pipeline p, int size) {
            return (PCollection)p.apply("CreateInputValuesUpTo(" + size + ")", (PTransform)Create.of((Iterable)IntStream.range(0, size).boxed().collect(Collectors.toList())));
        }
    }
}

