/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values.reflect;

import java.io.Serializable;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.reflect.DefaultSchemaFactory;
import org.apache.beam.sdk.values.reflect.GeneratedGetterFactory;
import org.apache.beam.sdk.values.reflect.GetterFactory;
import org.apache.beam.sdk.values.reflect.ReflectionGetter;
import org.apache.beam.sdk.values.reflect.ReflectionGetterFactory;
import org.apache.beam.sdk.values.reflect.ReflectionUtils;
import org.apache.beam.sdk.values.reflect.RowFactory;
import org.apache.beam.sdk.values.reflect.SchemaFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RowFactoryTest {
    private GetterFactory getterFactory;

    @Parameterized.Parameters
    public static Iterable<GetterFactory> gettersFactories() {
        return ImmutableList.of(new GeneratedGetterFactory(), new ReflectionGetterFactory(), (GetterFactory & Serializable)clazz -> ReflectionUtils.getPublicGetters((Class)clazz).stream().map(ReflectionGetter::new).collect(Collectors.toList()));
    }

    public RowFactoryTest(GetterFactory getterFactory) {
        this.getterFactory = getterFactory;
    }

    @Test
    public void testNewRecordFieldValues() throws Exception {
        SomePojo pojo = new SomePojo("someString", 42);
        RowFactory factory = this.newFactory();
        Row row = factory.create((Object)pojo);
        Assert.assertEquals((long)2L, (long)row.getFieldCount());
        Assert.assertThat((Object)row.getValues(), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{"someString", 42}));
    }

    @Test
    public void testNewRecordFieldNames() throws Exception {
        SomePojo pojo = new SomePojo("someString", 42);
        RowFactory factory = this.newFactory();
        Row row = factory.create((Object)pojo);
        Assert.assertThat((Object)row.getSchema().getFieldNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"someStringField", "someIntegerField"}));
    }

    @Test
    public void testCreatesNewInstanceEachTime() throws Exception {
        SomePojo pojo = new SomePojo("someString", 42);
        RowFactory factory = this.newFactory();
        Row row1 = factory.create((Object)pojo);
        Row row2 = factory.create((Object)pojo);
        Assert.assertNotSame((Object)row1, (Object)row2);
    }

    @Test
    public void testCachesRecordType() throws Exception {
        SomePojo pojo = new SomePojo("someString", 42);
        RowFactory factory = this.newFactory();
        Row row1 = factory.create((Object)pojo);
        Row row2 = factory.create((Object)pojo);
        Assert.assertSame((Object)row1.getSchema(), (Object)row2.getSchema());
    }

    @Test
    public void testCopiesValues() throws Exception {
        SomePojo pojo = new SomePojo("someString", 42);
        RowFactory factory = this.newFactory();
        Row row = factory.create((Object)pojo);
        Assert.assertThat((Object)row.getValues(), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{"someString", 42}));
        pojo.someIntegerField = 23;
        pojo.someStringField = "hello";
        Assert.assertThat((Object)row.getValues(), (Matcher)Matchers.containsInAnyOrder((Object[])new Object[]{"someString", 42}));
    }

    private RowFactory newFactory() {
        return new RowFactory((SchemaFactory)new DefaultSchemaFactory(), new GetterFactory[]{this.getterFactory});
    }

    public static final class SomePojo {
        private String someStringField;
        private Integer someIntegerField;

        public SomePojo(String someStringField, Integer someIntegerField) {
            this.someStringField = someStringField;
            this.someIntegerField = someIntegerField;
        }

        public String getSomeStringField() {
            return this.someStringField;
        }

        public Integer getSomeIntegerField() {
            return this.someIntegerField;
        }
    }
}

