/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values.reflect;

import java.lang.reflect.Method;
import org.apache.beam.sdk.values.reflect.ReflectionGetter;
import org.junit.Assert;
import org.junit.Test;

public class ReflectionGetterTest {
    private static final Method STRING_GETTER = ReflectionGetterTest.method("getStringField");
    private static final Method INT_GETTER = ReflectionGetterTest.method("getIntField");
    private static final Method NOT_GETTER = ReflectionGetterTest.method("notGetter");

    private static Method method(String methodName) {
        try {
            return Pojo.class.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Unable to find method '" + methodName + "'");
        }
    }

    @Test
    public void testInitializedWithCorrectNames() {
        ReflectionGetter stringGetter = new ReflectionGetter(STRING_GETTER);
        ReflectionGetter intGetter = new ReflectionGetter(INT_GETTER);
        ReflectionGetter notGetter = new ReflectionGetter(NOT_GETTER);
        Assert.assertEquals((Object)"stringField", (Object)stringGetter.name());
        Assert.assertEquals((Object)"intField", (Object)intGetter.name());
        Assert.assertEquals((Object)"notGetter", (Object)notGetter.name());
    }

    @Test
    public void testInitializedWithCorrectTypes() {
        ReflectionGetter stringGetter = new ReflectionGetter(STRING_GETTER);
        ReflectionGetter intGetter = new ReflectionGetter(INT_GETTER);
        ReflectionGetter notGetter = new ReflectionGetter(NOT_GETTER);
        Assert.assertEquals(String.class, (Object)stringGetter.type());
        Assert.assertEquals(Integer.class, (Object)intGetter.type());
        Assert.assertEquals(Integer.class, (Object)notGetter.type());
    }

    @Test
    public void testInvokesCorrectGetter() {
        Pojo pojo = new Pojo();
        ReflectionGetter stringGetter = new ReflectionGetter(STRING_GETTER);
        ReflectionGetter intGetter = new ReflectionGetter(INT_GETTER);
        ReflectionGetter notGetter = new ReflectionGetter(NOT_GETTER);
        Assert.assertEquals((Object)"test", (Object)stringGetter.get((Object)pojo));
        Assert.assertEquals((Object)3421, (Object)intGetter.get((Object)pojo));
        Assert.assertEquals((Object)542, (Object)notGetter.get((Object)pojo));
    }

    private static class Pojo {
        private Pojo() {
        }

        public String getStringField() {
            return "test";
        }

        public Integer getIntField() {
            return 3421;
        }

        public Integer notGetter() {
            return 542;
        }
    }
}

