/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values.reflect;

import java.io.Serializable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.reflect.InferredRowCoder;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Assert;
import org.junit.Test;

public class InferredRowCoderTest {
    private static final Schema PERSON_ROW_TYPE = Schema.builder().addInt32Field("ageYears").addStringField("name").build();
    private static final PersonPojo PERSON_FOO = new PersonPojo("Foo", 13);
    private static final PersonPojo PERSON_BAR = new PersonPojo("Bar", 1);
    private static final Row ROW_FOO = Row.withSchema((Schema)PERSON_ROW_TYPE).addValues(new Object[]{PERSON_FOO.getAgeYears(), PERSON_BAR.getName()}).build();
    private static final Row ROW_BAR = Row.withSchema((Schema)PERSON_ROW_TYPE).addValues(new Object[]{PERSON_BAR.getAgeYears(), PERSON_BAR.getName()}).build();

    @Test
    public void testCreatesSchema() {
        InferredRowCoder inferredCoder = InferredRowCoder.ofSerializable(PersonPojo.class);
        Schema schema = inferredCoder.schema();
        Assert.assertEquals((long)2L, (long)schema.getFieldCount());
        Assert.assertThat((Object)schema.getFields(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Schema.Field[]{PERSON_ROW_TYPE.getField(0), PERSON_ROW_TYPE.getField(1)}));
    }

    @Test
    public void testCreatesRows() {
        InferredRowCoder inferredCoder = InferredRowCoder.ofSerializable(PersonPojo.class);
        Row createdRowFoo = inferredCoder.createRow((Object)PERSON_FOO);
        Assert.assertEquals((Object)"Foo", (Object)createdRowFoo.getValue("name"));
        Assert.assertEquals((long)13L, (long)((Integer)createdRowFoo.getValue("ageYears")).intValue());
        Row createRowBar = inferredCoder.createRow((Object)PERSON_BAR);
        Assert.assertEquals((Object)"Bar", (Object)createRowBar.getValue("name"));
        Assert.assertEquals((long)1L, (long)((Integer)createRowBar.getValue("ageYears")).intValue());
    }

    public static class PersonPojo
    implements Serializable {
        private Integer ageYears;
        private String name;

        public Integer getAgeYears() {
            return this.ageYears;
        }

        public String getName() {
            return this.name;
        }

        PersonPojo(String name, Integer ageYears) {
            this.ageYears = ageYears;
            this.name = name;
        }
    }
}

