/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values.reflect;

import java.util.List;
import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableSet;
import org.apache.beam.sdk.values.reflect.FieldValueGetter;
import org.apache.beam.sdk.values.reflect.GeneratedGetterFactory;
import org.junit.Assert;
import org.junit.Test;

public class GeneratedGetterFactoryTest {
    @Test
    public void testGettersHaveCorrectNames() throws Exception {
        List getters = new GeneratedGetterFactory().generateGetters(Pojo.class);
        Assert.assertEquals(ImmutableSet.of("privateStringField", "privateIntegerField"), this.getNames(getters));
    }

    @Test
    public void testGettersHaveCorrectTypes() throws Exception {
        List getters = new GeneratedGetterFactory().generateGetters(Pojo.class);
        Assert.assertEquals(ImmutableSet.of(String.class, Integer.class), this.getTypes(getters));
    }

    @Test
    public void testGettersReturnCorrectValues() throws Exception {
        List getters = new GeneratedGetterFactory().generateGetters(Pojo.class);
        Assert.assertEquals(ImmutableSet.of("privateStringValue", Integer.valueOf(15)), this.getValues(getters, new Pojo()));
    }

    private Set<String> getNames(List<FieldValueGetter> getters) {
        ImmutableSet.Builder names = ImmutableSet.builder();
        for (FieldValueGetter getter : getters) {
            names.add(getter.name());
        }
        return names.build();
    }

    private Set<Class> getTypes(List<FieldValueGetter> getters) {
        ImmutableSet.Builder types = ImmutableSet.builder();
        for (FieldValueGetter getter : getters) {
            types.add(getter.type());
        }
        return types.build();
    }

    private ImmutableSet<Object> getValues(List<FieldValueGetter> getters, Pojo pojo) {
        ImmutableSet.Builder values = ImmutableSet.builder();
        for (FieldValueGetter getter : getters) {
            values.add(getter.get((Object)pojo));
        }
        return values.build();
    }

    private static class Pojo {
        private String privateStringField = "privateStringValue";
        private Integer privateIntegerField = 15;
        public String publicStringField = "publicStringField";

        private Pojo() {
        }

        public String getPrivateStringField() {
            return this.privateStringField;
        }

        public Integer getPrivateIntegerField() {
            return this.privateIntegerField;
        }
    }
}

