/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values.reflect;

import java.util.Arrays;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.reflect.DefaultSchemaFactory;
import org.apache.beam.sdk.values.reflect.FieldValueGetter;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DefaultSchemaFactoryTest {
    private static final ImmutableList<FieldValueGetter> GETTERS = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(DefaultSchemaFactoryTest.getter("byteGetter", Byte.class))).add(DefaultSchemaFactoryTest.getter("integerGetter", Integer.class))).add(DefaultSchemaFactoryTest.getter("longGetter", Long.class))).add(DefaultSchemaFactoryTest.getter("doubleGetter", Double.class))).add(DefaultSchemaFactoryTest.getter("booleanGetter", Boolean.class))).add(DefaultSchemaFactoryTest.getter("stringGetter", String.class))).build();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testContainsCorrectFields() throws Exception {
        DefaultSchemaFactory factory = new DefaultSchemaFactory();
        Schema schema = factory.createSchema(GETTERS);
        Assert.assertEquals((long)GETTERS.size(), (long)schema.getFieldCount());
        Assert.assertEquals(Arrays.asList("byteGetter", "integerGetter", "longGetter", "doubleGetter", "booleanGetter", "stringGetter"), (Object)schema.getFieldNames());
    }

    @Test
    public void testThrowsForUnsupportedTypes() throws Exception {
        this.thrown.expect(UnsupportedOperationException.class);
        DefaultSchemaFactory factory = new DefaultSchemaFactory();
        factory.createSchema(Arrays.asList(DefaultSchemaFactoryTest.getter("unsupportedGetter", UnsupportedClass.class)));
    }

    private static FieldValueGetter getter(final String fieldName, final Class fieldType) {
        return new FieldValueGetter(){

            public Object get(Object object) {
                return null;
            }

            public String name() {
                return fieldName;
            }

            public Class type() {
                return fieldType;
            }
        };
    }

    private static class UnsupportedClass {
        private UnsupportedClass() {
        }
    }
}

