/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TypedPValueTest {
    @Rule
    public final TestPipeline p = TestPipeline.create().enableAbandonedNodeEnforcement(false);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    private PCollectionTuple buildPCollectionTupleWithTags(TupleTag<Integer> mainOutputTag, TupleTag<Integer> additionalOutputTag) {
        PCollection input = (PCollection)this.p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}));
        PCollectionTuple tuple = (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new IdentityDoFn()).withOutputTags(mainOutputTag, TupleTagList.of(additionalOutputTag)));
        return tuple;
    }

    private static <T> TupleTag<T> makeTagStatically() {
        return new TupleTag<T>(){};
    }

    @Test
    public void testUntypedOutputTupleTagGivesActionableMessage() {
        TupleTag<Integer> mainOutputTag = new TupleTag<Integer>(){};
        TupleTag untypedOutputTag = new TupleTag();
        PCollectionTuple tuple = this.buildPCollectionTupleWithTags(mainOutputTag, (TupleTag<Integer>)untypedOutputTag);
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("No Coder has been manually specified");
        this.thrown.expectMessage("Building a Coder using a registered CoderProvider failed");
        Coder coder = tuple.get(untypedOutputTag).getCoder();
        System.out.println(coder);
    }

    @Test
    public void testStaticFactoryOutputTupleTagGivesActionableMessage() {
        TupleTag<Integer> mainOutputTag = new TupleTag<Integer>(){};
        TupleTag untypedOutputTag = TypedPValueTest.makeTagStatically();
        PCollectionTuple tuple = this.buildPCollectionTupleWithTags(mainOutputTag, untypedOutputTag);
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("No Coder has been manually specified");
        this.thrown.expectMessage("Building a Coder using a registered CoderProvider failed");
        tuple.get(untypedOutputTag).getCoder();
    }

    @Test
    public void testTypedOutputTupleTag() {
        TupleTag<Integer> mainOutputTag = new TupleTag<Integer>(){};
        TupleTag<Integer> typedOutputTag = new TupleTag<Integer>(){};
        PCollectionTuple tuple = this.buildPCollectionTupleWithTags(mainOutputTag, typedOutputTag);
        Assert.assertThat((Object)tuple.get((TupleTag)typedOutputTag).getCoder(), (Matcher)Matchers.instanceOf(VarIntCoder.class));
    }

    @Test
    public void testUntypedMainOutputTagTypedOutputTupleTag() {
        TupleTag mainOutputTag = new TupleTag();
        TupleTag<Integer> typedOutputTag = new TupleTag<Integer>(){};
        PCollectionTuple tuple = this.buildPCollectionTupleWithTags((TupleTag<Integer>)mainOutputTag, typedOutputTag);
        Assert.assertThat((Object)tuple.get((TupleTag)typedOutputTag).getCoder(), (Matcher)Matchers.instanceOf(VarIntCoder.class));
    }

    @Test
    public void testParDoWithNoOutputsErrorDoesNotMentionTupleTag() {
        PCollection input = (PCollection)((PCollection)this.p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)ParDo.of((DoFn)new EmptyClassDoFn()));
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage(Matchers.not((Matcher)Matchers.containsString((String)"erasure")));
        this.thrown.expectMessage(Matchers.not((Matcher)Matchers.containsString((String)"see TupleTag Javadoc")));
        this.thrown.expectMessage("Building a Coder using a registered CoderProvider failed");
        input.getCoder();
    }

    @Test
    public void testFinishSpecifyingShouldFailIfNoCoderInferrable() {
        this.p.enableAbandonedNodeEnforcement(false);
        PCollection created = (PCollection)this.p.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}));
        ParDo.SingleOutput uninferrableParDo = ParDo.of((DoFn)new EmptyClassDoFn());
        PCollection unencodable = (PCollection)created.apply((PTransform)uninferrableParDo);
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("Unable to return a default Coder");
        this.thrown.expectMessage("Inferring a Coder from the CoderRegistry failed");
        unencodable.finishSpecifying((PInput)created, (PTransform)uninferrableParDo);
    }

    private static class EmptyClassDoFn
    extends DoFn<Integer, EmptyClass> {
        private static final long serialVersionUID = 0L;

        private EmptyClassDoFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            c.output((Object)new EmptyClass());
        }
    }

    static class EmptyClass {
        EmptyClass() {
        }
    }

    private static class IdentityDoFn
    extends DoFn<Integer, Integer> {
        private static final long serialVersionUID = 0L;

        private IdentityDoFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            c.output((Object)((Integer)c.element()));
        }
    }
}

