/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TypeDescriptorsTest {
    @Test
    public void testTypeDescriptorsIterables() throws Exception {
        TypeDescriptor descriptor = TypeDescriptors.iterables((TypeDescriptor)TypeDescriptors.strings());
        Assert.assertEquals((Object)descriptor, (Object)new TypeDescriptor<Iterable<String>>(){});
    }

    @Test
    public void testTypeDescriptorsSets() throws Exception {
        TypeDescriptor descriptor = TypeDescriptors.sets((TypeDescriptor)TypeDescriptors.strings());
        Assert.assertEquals((Object)descriptor, (Object)new TypeDescriptor<Set<String>>(){});
    }

    @Test
    public void testTypeDescriptorsKV() throws Exception {
        TypeDescriptor descriptor = TypeDescriptors.kvs((TypeDescriptor)TypeDescriptors.strings(), (TypeDescriptor)TypeDescriptors.integers());
        Assert.assertEquals((Object)descriptor, (Object)new TypeDescriptor<KV<String, Integer>>(){});
    }

    @Test
    public void testTypeDescriptorsLists() throws Exception {
        TypeDescriptor descriptor = TypeDescriptors.lists((TypeDescriptor)TypeDescriptors.strings());
        Assert.assertEquals((Object)descriptor, (Object)new TypeDescriptor<List<String>>(){});
        Assert.assertNotEquals((Object)descriptor, (Object)new TypeDescriptor<List<Boolean>>(){});
    }

    @Test
    public void testTypeDescriptorsListsOfLists() throws Exception {
        TypeDescriptor descriptor = TypeDescriptors.lists((TypeDescriptor)TypeDescriptors.lists((TypeDescriptor)TypeDescriptors.strings()));
        Assert.assertEquals((Object)descriptor, (Object)new TypeDescriptor<List<List<String>>>(){});
        Assert.assertNotEquals((Object)descriptor, (Object)new TypeDescriptor<List<String>>(){});
        Assert.assertNotEquals((Object)descriptor, (Object)new TypeDescriptor<List<Boolean>>(){});
    }

    private static <ActualFooT> Generic<ActualFooT, String> typeErasedGeneric() {
        return new Generic<ActualFooT, String>(){};
    }

    private static <ActualFooT, ActualBarT> TypeDescriptor<ActualFooT> extractFooT(Generic<ActualFooT, ActualBarT> instance) {
        return TypeDescriptors.extractFromTypeParameters(instance, Generic.class, (TypeDescriptors.TypeVariableExtractor)new TypeDescriptors.TypeVariableExtractor<Generic<ActualFooT, ActualBarT>, ActualFooT>(){});
    }

    private static <ActualFooT, ActualBarT> TypeDescriptor<ActualBarT> extractBarT(Generic<ActualFooT, ActualBarT> instance) {
        return TypeDescriptors.extractFromTypeParameters(instance, Generic.class, (TypeDescriptors.TypeVariableExtractor)new TypeDescriptors.TypeVariableExtractor<Generic<ActualFooT, ActualBarT>, ActualBarT>(){});
    }

    private static <ActualFooT, ActualBarT> TypeDescriptor<KV<ActualFooT, ActualBarT>> extractKV(Generic<ActualFooT, ActualBarT> instance) {
        return TypeDescriptors.extractFromTypeParameters(instance, Generic.class, (TypeDescriptors.TypeVariableExtractor)new TypeDescriptors.TypeVariableExtractor<Generic<ActualFooT, ActualBarT>, KV<ActualFooT, ActualBarT>>(){});
    }

    @Test
    public void testTypeDescriptorsTypeParameterOf() throws Exception {
        Assert.assertEquals((Object)TypeDescriptors.strings(), TypeDescriptorsTest.extractFooT(new Generic<String, Integer>(){}));
        Assert.assertEquals((Object)TypeDescriptors.integers(), TypeDescriptorsTest.extractBarT(new Generic<String, Integer>(){}));
        Assert.assertEquals((Object)TypeDescriptors.kvs((TypeDescriptor)TypeDescriptors.strings(), (TypeDescriptor)TypeDescriptors.integers()), TypeDescriptorsTest.extractKV(new Generic<String, Integer>(){}));
    }

    @Test
    public void testTypeDescriptorsTypeParameterOfErased() throws Exception {
        Generic instance = TypeDescriptorsTest.typeErasedGeneric();
        TypeDescriptor fooT = TypeDescriptorsTest.extractFooT(instance);
        Assert.assertNotNull(fooT);
        Assert.assertEquals((Object)"ActualFooT", (Object)fooT.toString());
        Assert.assertEquals((Object)TypeDescriptors.strings(), TypeDescriptorsTest.extractBarT(instance));
        TypeDescriptor kvT = TypeDescriptorsTest.extractKV(instance);
        Assert.assertNotNull(kvT);
        Assert.assertThat((Object)kvT.toString(), (Matcher)CoreMatchers.containsString((String)"KV<ActualFooT, java.lang.String>"));
    }

    private static interface Generic<FooT, BarT> {
    }
}

