/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.reflect.Parameter;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.reflect.TypeToken;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TypeDescriptorTest {
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    @Test
    public void testTypeDescriptorOfRawType() throws Exception {
        Assert.assertEquals(TypeToken.of(String.class).getRawType(), (Object)TypeDescriptor.of(String.class).getRawType());
    }

    @Test
    public void testTypeDescriptorImmediate() throws Exception {
        Assert.assertEquals(Boolean.class, (Object)new TypeDescriptor<Boolean>(){}.getRawType());
        Assert.assertEquals(Double.class, (Object)new TypeDescriptor<Double>(){}.getRawType());
        Assert.assertEquals(Float.class, (Object)new TypeDescriptor<Float>(){}.getRawType());
        Assert.assertEquals(Integer.class, (Object)new TypeDescriptor<Integer>(){}.getRawType());
        Assert.assertEquals(Long.class, (Object)new TypeDescriptor<Long>(){}.getRawType());
        Assert.assertEquals(Short.class, (Object)new TypeDescriptor<Short>(){}.getRawType());
        Assert.assertEquals(String.class, (Object)new TypeDescriptor<String>(){}.getRawType());
    }

    @Test
    public void testTypeDescriptorGeneric() throws Exception {
        TypeDescriptor<List<String>> descriptor = new TypeDescriptor<List<String>>(){};
        TypeToken<List<String>> token = new TypeToken<List<String>>(){};
        Assert.assertEquals((Object)token.getType(), (Object)descriptor.getType());
    }

    @Test
    public void testTypeDescriptorNested() throws Exception {
        TypeRememberer<String> rememberer = new TypeRememberer<String>(){};
        Assert.assertEquals((Object)new TypeToken<String>(){}.getType(), (Object)rememberer.descriptorByClass.getType());
        Assert.assertEquals((Object)new TypeToken<String>(){}.getType(), (Object)rememberer.descriptorByInstance.getType());
        TypeRememberer<List<String>> genericRememberer = new TypeRememberer<List<String>>(){};
        Assert.assertEquals((Object)new TypeToken<List<String>>(){}.getType(), (Object)genericRememberer.descriptorByClass.getType());
        Assert.assertEquals((Object)new TypeToken<List<String>>(){}.getType(), (Object)genericRememberer.descriptorByInstance.getType());
    }

    @Test
    public void testGetArgumentTypes() throws Exception {
        Method identity = Id.class.getDeclaredMethod("identity", Object.class);
        TypeToken<Id<String>> token = new TypeToken<Id<String>>(){};
        TypeDescriptor<Id<String>> descriptor = new TypeDescriptor<Id<String>>(){};
        Assert.assertEquals((Object)((Parameter)token.method(identity).getParameters().get(0)).getType().getType(), (Object)((TypeDescriptor)descriptor.getArgumentTypes(identity).get(0)).getType());
        TypeToken<Id<List<String>>> genericToken = new TypeToken<Id<List<String>>>(){};
        TypeDescriptor<Id<List<String>>> genericDescriptor = new TypeDescriptor<Id<List<String>>>(){};
        Assert.assertEquals((Object)((Parameter)genericToken.method(identity).getParameters().get(0)).getType().getType(), (Object)((TypeDescriptor)genericDescriptor.getArgumentTypes(identity).get(0)).getType());
    }

    @Test
    public void testTypeDescriptorNested2() throws Exception {
        TypeRemembererer<String, Integer> remembererer = new TypeRemembererer<String, Integer>(){};
        Assert.assertEquals((Object)new TypeToken<String>(){}.getType(), (Object)remembererer.descriptor1.getType());
        Assert.assertEquals((Object)new TypeToken<Integer>(){}.getType(), (Object)remembererer.descriptor2.getType());
        TypeRemembererer<List<String>, Set<Integer>> genericRemembererer = new TypeRemembererer<List<String>, Set<Integer>>(){};
        Assert.assertEquals((Object)new TypeToken<List<String>>(){}.getType(), (Object)genericRemembererer.descriptor1.getType());
        Assert.assertEquals((Object)new TypeToken<Set<Integer>>(){}.getType(), (Object)genericRemembererer.descriptor2.getType());
    }

    @Test
    public void testGetTypeParameterGood() throws Exception {
        TypeVariable bizzleT = TypeDescriptor.of(GenericClass.class).getTypeParameter("BizzleT");
        Assert.assertEquals(GenericClass.class.getTypeParameters()[0], (Object)bizzleT);
    }

    @Test
    public void testGetTypeParameterBad() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("MerpleT");
        TypeDescriptor.of(GenericClass.class).getTypeParameter("MerpleT");
    }

    @Test
    public void testEnclosing() throws Exception {
        TypeRememberer rememberer = new GenericMaker<String>(){}.getRememberer();
        Assert.assertEquals((Object)new TypeToken<List<String>>(){}.getType(), (Object)rememberer.descriptorByInstance.getType());
    }

    @Test
    public void testEnclosing2() throws Exception {
        TypeRememberer<List<Set<String>>> rememberer = new GenericMaker2<String>(){

            @Override
            public GenericMaker<Set<String>> getGenericMaker() {
                return new GenericMaker<Set<String>>(){};
            }
        }.getGenericMaker().getRememberer();
        Assert.assertEquals((Object)new TypeToken<List<Set<String>>>(){}.getType(), (Object)rememberer.descriptorByInstance.getType());
    }

    @Test
    public void testWhere() throws Exception {
        this.useWhereMethodToDefineTypeParam(new TypeDescriptor<String>(){});
    }

    private <T> void useWhereMethodToDefineTypeParam(TypeDescriptor<T> parameterType) {
        TypeDescriptor typeDescriptor = new TypeDescriptor<Set<T>>(){}.where(new TypeParameter<T>(){}, parameterType);
        Assert.assertEquals((Object)new TypeToken<Set<String>>(){}.getType(), (Object)typeDescriptor.getType());
    }

    private static class GenericMaker2<T> {
        private GenericMaker2() {
        }

        public GenericMaker<Set<T>> getGenericMaker() {
            return new GenericMaker<Set<T>>(){};
        }
    }

    private static class GenericMaker<T> {
        private GenericMaker() {
        }

        public TypeRememberer<List<T>> getRememberer() {
            return new TypeRememberer<List<T>>(){};
        }
    }

    private static class GenericClass<BizzleT> {
        private GenericClass() {
        }
    }

    private static class TypeRemembererer<T1, T2> {
        public TypeDescriptor<T1> descriptor1 = new TypeDescriptor<T1>(this.getClass()){};
        public TypeDescriptor<T2> descriptor2 = new TypeDescriptor<T2>(this.getClass()){};
    }

    private static class Id<T> {
        private Id() {
        }

        public T identity(T thingie) {
            return thingie;
        }
    }

    private static class TypeRememberer<T> {
        public final TypeDescriptor<T> descriptorByClass = new TypeDescriptor<T>(this.getClass()){};
        public final TypeDescriptor<T> descriptorByInstance = new TypeDescriptor<T>(this){};
    }
}

