/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Splitter;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Iterables;
import org.apache.beam.sdk.values.TupleTag;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TupleTagTest {
    private static TupleTag<Object> staticTag = new TupleTag();
    private static TupleTag<Object> staticBlockTag;
    private static TupleTag<Object> staticMethodTag;
    private static TupleTag<Object> instanceMethodTag;

    private static TupleTag<Object> createTag() {
        return new TupleTag();
    }

    @Test
    public void testStaticTupleTag() {
        Assert.assertEquals((Object)"org.apache.beam.sdk.values.TupleTagTest#0", (Object)staticTag.getId());
        Assert.assertEquals((Object)"org.apache.beam.sdk.values.TupleTagTest#3", (Object)staticBlockTag.getId());
        Assert.assertEquals((Object)"org.apache.beam.sdk.values.TupleTagTest#1", (Object)staticMethodTag.getId());
        Assert.assertEquals((Object)"org.apache.beam.sdk.values.TupleTagTest#2", (Object)instanceMethodTag.getId());
        Assert.assertEquals((Object)"org.apache.beam.sdk.values.TupleTagTest$AnotherClass#0", (Object)AnotherClass.anotherTag.getId());
    }

    private TupleTag<Object> createNonstaticTupleTag() {
        return new TupleTag();
    }

    @Test
    public void testNonstaticTupleTag() {
        Assert.assertNotEquals((Object)new TupleTag().getId(), (Object)new TupleTag().getId());
        Assert.assertNotEquals(this.createNonstaticTupleTag(), this.createNonstaticTupleTag());
        TupleTag<Object> tag = this.createNonstaticTupleTag();
        Assert.assertThat((Object)Iterables.get(Splitter.on('#').split(tag.getId()), 0), (Matcher)Matchers.startsWith((String)"org.apache.beam.sdk.values.TupleTagTest.createNonstaticTupleTag"));
        Assert.assertThat((Object)Integer.parseInt(Iterables.get(Splitter.on(':').split(Iterables.get(Splitter.on('#').split(tag.getId()), 0)), 1)), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(15)));
    }

    static {
        staticMethodTag = TupleTagTest.createTag();
        instanceMethodTag = new AnotherClass().createAnotherTag();
        staticBlockTag = new TupleTag();
    }

    private static class AnotherClass {
        private static TupleTag<Object> anotherTag = new TupleTag();

        private AnotherClass() {
        }

        private TupleTag<Object> createAnotherTag() {
            return new TupleTag();
        }
    }
}

