/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import com.google.common.testing.EqualsTester;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.values.TimestampedValue;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TimestampedValueTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final Coder<TimestampedValue<GlobalWindow>> CODER = TimestampedValue.TimestampedValueCoder.of((Coder)GlobalWindow.Coder.INSTANCE);

    @Test
    public void testValues() {
        Instant now = Instant.now();
        TimestampedValue tsv = TimestampedValue.of((Object)"foobar", (Instant)now);
        Assert.assertEquals((Object)now, (Object)tsv.getTimestamp());
        Assert.assertEquals((Object)"foobar", (Object)tsv.getValue());
    }

    @Test
    public void testAtMinimumTimestamp() {
        TimestampedValue tsv = TimestampedValue.atMinimumTimestamp((Object)"foobar");
        Assert.assertEquals((Object)BoundedWindow.TIMESTAMP_MIN_VALUE, (Object)tsv.getTimestamp());
    }

    @Test
    public void testNullTimestamp() {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("timestamp");
        TimestampedValue.of((Object)"foobar", null);
    }

    @Test
    public void testNullValue() {
        TimestampedValue tsv = TimestampedValue.atMinimumTimestamp(null);
        Assert.assertEquals(null, (Object)tsv.getValue());
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{TimestampedValue.of((Object)"foo", (Instant)new Instant(1000L)), TimestampedValue.of((Object)"foo", (Instant)new Instant(1000L))}).addEqualityGroup(new Object[]{TimestampedValue.of((Object)"foo", (Instant)new Instant(2000L))}).addEqualityGroup(new Object[]{TimestampedValue.of((Object)"bar", (Instant)new Instant(1000L))}).addEqualityGroup(new Object[]{TimestampedValue.of((Object)"foo", (Instant)BoundedWindow.TIMESTAMP_MIN_VALUE), TimestampedValue.atMinimumTimestamp((Object)"foo")}).testEquals();
    }

    @Test
    public void testCoderEncodeDecodeEquals() throws Exception {
        CoderProperties.coderDecodeEncodeEqual(CODER, (Object)TimestampedValue.of((Object)GlobalWindow.INSTANCE, (Instant)Instant.now()));
    }

    @Test
    public void testCoderIsSerializableWithWellKnownCoderType() {
        CoderProperties.coderSerializable(CODER);
    }
}

