/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableCollection;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RowTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testCreatesNullRecord() {
        Schema type = (Schema)Stream.of(Schema.Field.of((String)"f_int", (Schema.FieldType)Schema.FieldType.INT32).withNullable(true), Schema.Field.of((String)"f_str", (Schema.FieldType)Schema.FieldType.STRING).withNullable(true), Schema.Field.of((String)"f_double", (Schema.FieldType)Schema.FieldType.DOUBLE).withNullable(true)).collect(Schema.toSchema());
        Row row = Row.nullRow((Schema)type);
        Assert.assertNull((Object)row.getValue("f_int"));
        Assert.assertNull((Object)row.getValue("f_str"));
        Assert.assertNull((Object)row.getValue("f_double"));
    }

    @Test
    public void testRejectsNullRecord() {
        Schema type = (Schema)Stream.of(Schema.Field.of((String)"f_int", (Schema.FieldType)Schema.FieldType.INT32)).collect(Schema.toSchema());
        this.thrown.expect(IllegalArgumentException.class);
        Row.nullRow((Schema)type);
    }

    @Test
    public void testCreatesRecord() {
        Schema schema = Schema.builder().addByteField("f_byte").addInt16Field("f_int16").addInt32Field("f_int32").addInt64Field("f_int64").addDecimalField("f_decimal").addFloatField("f_float").addDoubleField("f_double").addStringField("f_string").addDateTimeField("f_datetime").addBooleanField("f_boolean").build();
        DateTime dateTime = new DateTime().withDate(1979, 3, 14).withTime(1, 2, 3, 4).withZone(DateTimeZone.UTC);
        Row row = Row.withSchema((Schema)schema).addValues(new Object[]{(byte)0, (short)1, 2, 3L, new BigDecimal(2.3), Float.valueOf(1.2f), 3.0, "str", dateTime, false}).build();
        Assert.assertEquals((long)0L, (long)row.getByte("f_byte"));
        Assert.assertEquals((long)1L, (long)row.getInt16("f_int16"));
        Assert.assertEquals((long)2L, (long)row.getInt32("f_int32"));
        Assert.assertEquals((long)3L, (long)row.getInt64("f_int64"));
        Assert.assertEquals((Object)new BigDecimal(2.3), (Object)row.getDecimal("f_decimal"));
        Assert.assertEquals((float)1.2f, (float)row.getFloat("f_float"), (float)0.0f);
        Assert.assertEquals((double)3.0, (double)row.getDouble("f_double"), (double)0.0);
        Assert.assertEquals((Object)"str", (Object)row.getString("f_string"));
        Assert.assertEquals((Object)dateTime, (Object)row.getDateTime("f_datetime"));
        Assert.assertEquals((Object)false, (Object)row.getBoolean("f_boolean"));
        Assert.assertEquals((Object)"str", (Object)row.getString("f_string"));
        Assert.assertEquals((Object)false, (Object)row.getBoolean("f_boolean"));
    }

    @Test
    public void testCreatesNestedRow() {
        Schema nestedType = (Schema)Stream.of(Schema.Field.of((String)"f1_str", (Schema.FieldType)Schema.FieldType.STRING)).collect(Schema.toSchema());
        Schema type = (Schema)Stream.of(Schema.Field.of((String)"f_int", (Schema.FieldType)Schema.FieldType.INT32), Schema.Field.of((String)"nested", (Schema.FieldType)Schema.FieldType.row((Schema)nestedType))).collect(Schema.toSchema());
        Row nestedRow = Row.withSchema((Schema)nestedType).addValues(new Object[]{"foobar"}).build();
        Row row = Row.withSchema((Schema)type).addValues(new Object[]{42, nestedRow}).build();
        Assert.assertEquals((long)42L, (long)row.getInt32("f_int"));
        Assert.assertEquals((Object)"foobar", (Object)row.getRow("nested").getString("f1_str"));
    }

    @Test
    public void testCreatesArray() {
        ArrayList<Integer> data = Lists.newArrayList(2, 3, 5, 7);
        Schema type = (Schema)Stream.of(Schema.Field.of((String)"array", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT32))).collect(Schema.toSchema());
        Row row = Row.withSchema((Schema)type).addArray(data).build();
        Assert.assertEquals(data, (Object)row.getArray("array"));
    }

    @Test
    public void testCreatesRowArray() {
        Schema nestedType = (Schema)Stream.of(Schema.Field.of((String)"f1_str", (Schema.FieldType)Schema.FieldType.STRING)).collect(Schema.toSchema());
        ArrayList<Row> data = Lists.newArrayList(Row.withSchema((Schema)nestedType).addValues(new Object[]{"one"}).build(), Row.withSchema((Schema)nestedType).addValues(new Object[]{"two"}).build(), Row.withSchema((Schema)nestedType).addValues(new Object[]{"three"}).build());
        Schema type = (Schema)Stream.of(Schema.Field.of((String)"array", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.row((Schema)nestedType)))).collect(Schema.toSchema());
        Row row = Row.withSchema((Schema)type).addArray(data).build();
        Assert.assertEquals(data, (Object)row.getArray("array"));
    }

    @Test
    public void testCreatesArrayArray() {
        ArrayList<List> data = Lists.newArrayList(new List[]{Lists.newArrayList(1, 2, 3, 4)});
        Schema type = (Schema)Stream.of(Schema.Field.of((String)"array", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT32)))).collect(Schema.toSchema());
        Row row = Row.withSchema((Schema)type).addArray(data).build();
        Assert.assertEquals(data, (Object)row.getArray("array"));
    }

    @Test
    public void testCreatesArrayOfMap() {
        ImmutableCollection data = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(ImmutableMap.of(1, "value1"))).add(ImmutableMap.of(2, "value2"))).build();
        Schema type = (Schema)Stream.of(Schema.Field.of((String)"array", (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.map((Schema.FieldType)Schema.FieldType.INT32, (Schema.FieldType)Schema.FieldType.STRING)))).collect(Schema.toSchema());
        Row row = Row.withSchema((Schema)type).addArray((List)((Object)data)).build();
        Assert.assertEquals((Object)data, (Object)row.getArray("array"));
    }

    @Test
    public void testCreateMapWithPrimitiveValue() {
        ImmutableMap<Integer, String> data = ImmutableMap.builder().put(1, "value1").put(2, "value2").put(3, "value3").put(4, "value4").build();
        Schema type = (Schema)Stream.of(Schema.Field.of((String)"map", (Schema.FieldType)Schema.FieldType.map((Schema.FieldType)Schema.FieldType.INT32, (Schema.FieldType)Schema.FieldType.STRING))).collect(Schema.toSchema());
        Row row = Row.withSchema((Schema)type).addValue(data).build();
        Assert.assertEquals(data, (Object)row.getMap("map"));
    }

    @Test
    public void testCreateMapWithArrayValue() {
        ImmutableMap<Integer, List<String>> data = ImmutableMap.builder().put(1, Arrays.asList("value1")).put(2, Arrays.asList("value2")).build();
        Schema type = (Schema)Stream.of(Schema.Field.of((String)"map", (Schema.FieldType)Schema.FieldType.map((Schema.FieldType)Schema.FieldType.INT32, (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.STRING)))).collect(Schema.toSchema());
        Row row = Row.withSchema((Schema)type).addValue(data).build();
        Assert.assertEquals(data, (Object)row.getMap("map"));
    }

    @Test
    public void testCreateMapWithMapValue() {
        ImmutableMap<Integer, ImmutableMap<Integer, String>> data = ImmutableMap.builder().put(1, ImmutableMap.of(1, "value1")).put(2, ImmutableMap.of(2, "value2")).build();
        Schema type = (Schema)Stream.of(Schema.Field.of((String)"map", (Schema.FieldType)Schema.FieldType.map((Schema.FieldType)Schema.FieldType.INT32, (Schema.FieldType)Schema.FieldType.map((Schema.FieldType)Schema.FieldType.INT32, (Schema.FieldType)Schema.FieldType.STRING)))).collect(Schema.toSchema());
        Row row = Row.withSchema((Schema)type).addValue(data).build();
        Assert.assertEquals(data, (Object)row.getMap("map"));
    }

    @Test
    public void testCreateMapWithRowValue() {
        Schema nestedType = (Schema)Stream.of(Schema.Field.of((String)"f1_str", (Schema.FieldType)Schema.FieldType.STRING)).collect(Schema.toSchema());
        ImmutableMap<Integer, Row> data = ImmutableMap.builder().put(1, Row.withSchema((Schema)nestedType).addValues(new Object[]{"one"}).build()).put(2, Row.withSchema((Schema)nestedType).addValues(new Object[]{"two"}).build()).build();
        Schema type = (Schema)Stream.of(Schema.Field.of((String)"map", (Schema.FieldType)Schema.FieldType.map((Schema.FieldType)Schema.FieldType.INT32, (Schema.FieldType)Schema.FieldType.row((Schema)nestedType)))).collect(Schema.toSchema());
        Row row = Row.withSchema((Schema)type).addValue(data).build();
        Assert.assertEquals(data, (Object)row.getMap("map"));
    }

    @Test
    public void testCollector() {
        Schema type = (Schema)Stream.of(Schema.Field.of((String)"f_int", (Schema.FieldType)Schema.FieldType.INT32), Schema.Field.of((String)"f_str", (Schema.FieldType)Schema.FieldType.STRING), Schema.Field.of((String)"f_double", (Schema.FieldType)Schema.FieldType.DOUBLE)).collect(Schema.toSchema());
        Row row = (Row)Stream.of(Integer.valueOf(1), "2", 3.0).collect(Row.toRow((Schema)type));
        Assert.assertEquals((Object)1, (Object)row.getValue("f_int"));
        Assert.assertEquals((Object)"2", (Object)row.getValue("f_str"));
        Assert.assertEquals((Object)3.0, (Object)row.getValue("f_double"));
    }

    @Test
    public void testThrowsForIncorrectNumberOfFields() {
        Schema type = (Schema)Stream.of(Schema.Field.of((String)"f_int", (Schema.FieldType)Schema.FieldType.INT32), Schema.Field.of((String)"f_str", (Schema.FieldType)Schema.FieldType.STRING), Schema.Field.of((String)"f_double", (Schema.FieldType)Schema.FieldType.DOUBLE)).collect(Schema.toSchema());
        this.thrown.expect(IllegalArgumentException.class);
        Row.withSchema((Schema)type).addValues(new Object[]{1, "2"}).build();
    }
}

