/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.File;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.TestUtils;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PDoneTest {
    @Rule
    public final TestPipeline p = TestPipeline.create();
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Ignore
    @Test
    @Category(value={ValidatesRunner.class})
    public void testEmptyTransform() {
        this.p.begin().apply((PTransform)new EmptyTransform());
        this.p.run();
    }

    @Test
    @Category(value={NeedsRunner.class})
    public void testSimpleTransform() throws Exception {
        File tmpFile = this.tmpFolder.newFile("file.txt");
        String filename = tmpFile.getPath();
        this.p.begin().apply((PTransform)new SimpleTransform(filename));
        this.p.run();
    }

    static class SimpleTransform
    extends PTransform<PBegin, PDone> {
        private final String filename;

        public SimpleTransform(String filename) {
            this.filename = filename;
        }

        public PDone expand(PBegin begin) {
            return (PDone)((PCollection)begin.apply((PTransform)Create.of(TestUtils.LINES))).apply((PTransform)TextIO.write().to(this.filename));
        }
    }

    static class EmptyTransform
    extends PTransform<PBegin, PDone> {
        EmptyTransform() {
        }

        public PDone expand(PBegin begin) {
            return PDone.in((Pipeline)begin.getPipeline());
        }
    }
}

