/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import com.google.common.testing.EqualsTester;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class PCollectionTupleTest
implements Serializable {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create().enableAbandonedNodeEnforcement(false);

    @Test
    public void testOfThenHas() {
        PCollection pCollection = PCollection.createPrimitiveOutputInternal((Pipeline)this.pipeline, (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.BOUNDED, (Coder)VarIntCoder.of());
        TupleTag tag = new TupleTag();
        Assert.assertTrue((boolean)PCollectionTuple.of((TupleTag)tag, (PCollection)pCollection).has(tag));
    }

    @Test
    public void testEmpty() {
        TupleTag tag = new TupleTag();
        Assert.assertFalse((boolean)PCollectionTuple.empty((Pipeline)this.pipeline).has(tag));
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testComposePCollectionTuple() {
        this.pipeline.enableAbandonedNodeEnforcement(true);
        List<Integer> inputs = Arrays.asList(3, -42, 666);
        TupleTag<Integer> mainOutputTag = new TupleTag<Integer>("main"){};
        TupleTag<Integer> emptyOutputTag = new TupleTag<Integer>("empty"){};
        TupleTag<Integer> additionalOutputTag = new TupleTag<Integer>("extra"){};
        PCollection mainInput = (PCollection)this.pipeline.apply((PTransform)Create.of(inputs));
        PCollectionTuple outputs = (PCollectionTuple)mainInput.apply((PTransform)ParDo.of((DoFn)new DoFn<Integer, Integer>((TupleTag)additionalOutputTag){
            final /* synthetic */ TupleTag val$additionalOutputTag;
            {
                this.val$additionalOutputTag = tupleTag;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output(this.val$additionalOutputTag, (Object)((Integer)c.element()));
            }
        }).withOutputTags((TupleTag)emptyOutputTag, TupleTagList.of((TupleTag)additionalOutputTag)));
        Assert.assertNotNull((String)"outputs.getPipeline()", (Object)outputs.getPipeline());
        outputs = outputs.and((TupleTag)mainOutputTag, mainInput);
        PAssert.that((PCollection)outputs.get((TupleTag)mainOutputTag)).containsInAnyOrder(inputs);
        PAssert.that((PCollection)outputs.get((TupleTag)additionalOutputTag)).containsInAnyOrder(inputs);
        PAssert.that((PCollection)outputs.get((TupleTag)emptyOutputTag)).empty();
        this.pipeline.run();
    }

    @Test
    public void testEquals() {
        TestPipeline p = TestPipeline.create();
        TupleTag longTag = new TupleTag();
        PCollection longs = (PCollection)p.apply((PTransform)GenerateSequence.from((long)0L));
        TupleTag strTag = new TupleTag();
        PCollection strs = (PCollection)p.apply((PTransform)Create.of((Object)"foo", (Object[])new String[]{"bar"}));
        EqualsTester tester = new EqualsTester();
        tester.addEqualityGroup(new Object[]{PCollectionTuple.empty((Pipeline)p), PCollectionTuple.empty((Pipeline)p)});
        tester.addEqualityGroup(new Object[]{PCollectionTuple.of((TupleTag)longTag, (PCollection)longs).and(strTag, strs), PCollectionTuple.of((TupleTag)longTag, (PCollection)longs).and(strTag, strs)});
        tester.addEqualityGroup(new Object[]{PCollectionTuple.of((TupleTag)longTag, (PCollection)longs)});
        tester.addEqualityGroup(new Object[]{PCollectionTuple.of((TupleTag)strTag, (PCollection)strs)});
        TestPipeline otherPipeline = TestPipeline.create();
        tester.addEqualityGroup(new Object[]{PCollectionTuple.empty((Pipeline)otherPipeline)});
        tester.testEquals();
    }

    @Test
    public void testExpandHasMatchingTags() {
        TupleTag intTag = new TupleTag();
        TupleTag strTag = new TupleTag();
        TupleTag longTag = new TupleTag();
        TestPipeline p = TestPipeline.create();
        PCollection longs = (PCollection)p.apply((PTransform)GenerateSequence.from((long)0L).to(100L));
        PCollection strs = (PCollection)p.apply((PTransform)Create.of((Object)"foo", (Object[])new String[]{"bar", "baz"}));
        PCollection ints = (PCollection)longs.apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<Long, Integer>(){

            public Integer apply(Long input) {
                return input.intValue();
            }
        }));
        ImmutableMap<TupleTag, PCollection> pcsByTag = ImmutableMap.builder().put(strTag, strs).put(intTag, ints).put(longTag, longs).build();
        PCollectionTuple tuple = PCollectionTuple.of((TupleTag)intTag, (PCollection)ints).and(longTag, longs).and(strTag, strs);
        Assert.assertThat((Object)tuple.getAll(), (Matcher)Matchers.equalTo(pcsByTag));
        PCollectionTuple reconstructed = PCollectionTuple.empty((Pipeline)p);
        for (Map.Entry taggedValue : tuple.expand().entrySet()) {
            TupleTag tag = (TupleTag)taggedValue.getKey();
            PValue value = (PValue)taggedValue.getValue();
            Assert.assertThat((String)"The tag should map back to the value", (Object)tuple.get(tag), (Matcher)Matchers.equalTo((Object)value));
            Assert.assertThat((Object)value, (Matcher)Matchers.equalTo((Object)((PValue)pcsByTag.get(tag))));
            reconstructed = reconstructed.and(tag, (PCollection)value);
        }
        Assert.assertThat((Object)reconstructed, (Matcher)Matchers.equalTo((Object)tuple));
    }
}

