/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import com.google.common.testing.EqualsTester;
import java.util.Collections;
import java.util.Map;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PCollectionListTest {
    @Test
    public void testEmptyListFailure() {
        try {
            PCollectionList.of(Collections.emptyList());
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException exn) {
            Assert.assertThat((Object)exn.toString(), (Matcher)CoreMatchers.containsString((String)"must either have a non-empty list of PCollections, or must first call empty(Pipeline)"));
        }
    }

    @Test
    public void testIterationOrder() {
        TestPipeline p = TestPipeline.create();
        PCollection createOne = (PCollection)p.apply("CreateOne", (PTransform)Create.of((Object)1L, (Object[])new Long[]{2L, 3L}));
        PCollection boundedCount = (PCollection)p.apply("CountBounded", (PTransform)GenerateSequence.from((long)0L).to(23L));
        PCollection unboundedCount = (PCollection)p.apply("CountUnbounded", (PTransform)GenerateSequence.from((long)0L));
        PCollection createTwo = (PCollection)p.apply("CreateTwo", (PTransform)Create.of((Object)-1L, (Object[])new Long[]{-2L}));
        PCollection maxReadTimeCount = (PCollection)p.apply("CountLimited", (PTransform)GenerateSequence.from((long)0L).withMaxReadTime(Duration.standardSeconds((long)5L)));
        ImmutableList<PCollection> counts = ImmutableList.of(boundedCount, maxReadTimeCount, unboundedCount);
        PCollectionList pcList = PCollectionList.of(counts);
        Assert.assertThat((Object)pcList.getAll(), (Matcher)Matchers.contains((Object[])new PCollection[]{boundedCount, maxReadTimeCount, unboundedCount}));
        PCollectionList withOneCreate = pcList.and(createTwo);
        Assert.assertThat((Object)withOneCreate.getAll(), (Matcher)Matchers.contains((Object[])new PCollection[]{boundedCount, maxReadTimeCount, unboundedCount, createTwo}));
        PCollectionList fromEmpty = PCollectionList.empty((Pipeline)p).and(unboundedCount).and(createOne).and(ImmutableList.of(boundedCount, maxReadTimeCount));
        Assert.assertThat((Object)fromEmpty.getAll(), (Matcher)Matchers.contains((Object[])new PCollection[]{unboundedCount, createOne, boundedCount, maxReadTimeCount}));
        Map expansion = fromEmpty.expand();
        Assert.assertThat((Object)expansion, (Matcher)Matchers.equalTo((Object)fromEmpty.expand()));
        ImmutableList<PCollection> expectedList = ImmutableList.of(unboundedCount, createOne, boundedCount, maxReadTimeCount);
        Assert.assertThat(expansion.values(), (Matcher)Matchers.containsInAnyOrder((Object[])expectedList.toArray()));
    }

    @Test
    public void testExpandWithDuplicates() {
        TestPipeline p = TestPipeline.create();
        PCollection createOne = (PCollection)p.apply("CreateOne", (PTransform)Create.of((Object)1L, (Object[])new Long[]{2L, 3L}));
        PCollectionList list = PCollectionList.of((PCollection)createOne).and(createOne).and(createOne);
        Assert.assertThat(list.expand().values(), (Matcher)Matchers.containsInAnyOrder((Object[])new PValue[]{createOne, createOne, createOne}));
    }

    @Test
    public void testEquals() {
        TestPipeline p = TestPipeline.create();
        PCollection first = (PCollection)p.apply("Meta", (PTransform)Create.of((Object)"foo", (Object[])new String[]{"bar"}));
        PCollection second = (PCollection)p.apply("Pythonic", (PTransform)Create.of((Object)"spam, ham", (Object[])new String[0]));
        PCollection third = (PCollection)p.apply("Syntactic", (PTransform)Create.of((Object)"eggs", (Object[])new String[]{"baz"}));
        EqualsTester tester = new EqualsTester();
        tester.addEqualityGroup(new Object[]{PCollectionList.of((PCollection)first).and(second).and(third), PCollectionList.of((PCollection)first).and(second).and(third), PCollectionList.of(ImmutableList.of(first, second)).and(third)});
        tester.addEqualityGroup(new Object[]{PCollectionList.of((PCollection)first).and(third).and(second)});
        tester.addEqualityGroup(new Object[]{PCollectionList.empty((Pipeline)TestPipeline.create())});
        tester.testEquals();
    }
}

