/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.values.KV;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class KVTest {
    private static final Integer[] TEST_VALUES = new Integer[]{null, Integer.MIN_VALUE, -1, 0, 1, Integer.MAX_VALUE};

    private int compareInt(Integer a, Integer b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        return b == null ? 1 : a.compareTo(b);
    }

    @Test
    public void testEquals() {
        Assert.assertThat((Object)KV.of((Object)1, (Object)2), (Matcher)Matchers.equalTo((Object)KV.of((Object)1, (Object)2)));
        Assert.assertThat((Object)KV.of((Object)new int[]{1, 2}, (Object)3), (Matcher)Matchers.equalTo((Object)KV.of((Object)new int[]{1, 2}, (Object)3)));
        Assert.assertThat((Object)KV.of((Object)1, (Object)new int[]{2, 3}), (Matcher)Matchers.equalTo((Object)KV.of((Object)1, (Object)new int[]{2, 3})));
        Assert.assertThat((Object)KV.of((Object)new int[]{1, 2}, (Object)new int[]{3, 4}), (Matcher)Matchers.equalTo((Object)KV.of((Object)new int[]{1, 2}, (Object)new int[]{3, 4})));
        Assert.assertThat((Object)KV.of(ImmutableList.of(new int[]{1, 2}), (Object)3), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)KV.of(ImmutableList.of(new int[]{1, 2}), (Object)3))));
        Assert.assertThat((Object)KV.of((Object)1, ImmutableList.of(new int[]{2, 3})), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)KV.of((Object)1, ImmutableList.of(new int[]{2, 3})))));
        Assert.assertThat((Object)KV.of((Object)new int[]{1, 2}, (Object)3), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)KV.of((Object)new int[]{1, 37}, (Object)3))));
        Assert.assertThat((Object)KV.of((Object)1, (Object)new int[]{2, 3}), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)KV.of((Object)37, (Object)new int[]{1, 2}))));
        Assert.assertThat((Object)KV.of((Object)1, (Object)new int[]{2, 3}), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)KV.of((Object)1, (Object)new int[]{37, 3}))));
        Assert.assertThat((Object)KV.of((Object)new byte[]{1, 2}, (Object)3), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)KV.of((Object)new byte[]{1, 2}, (Object)37))));
    }

    @Test
    public void testOrderByKey() {
        KV.OrderByKey orderByKey = new KV.OrderByKey();
        for (Integer key1 : TEST_VALUES) {
            for (Integer val1 : TEST_VALUES) {
                for (Integer key2 : TEST_VALUES) {
                    for (Integer val2 : TEST_VALUES) {
                        Assert.assertEquals((long)this.compareInt(key1, key2), (long)orderByKey.compare(KV.of((Object)key1, (Object)val1), KV.of((Object)key2, (Object)val2)));
                    }
                }
            }
        }
    }

    @Test
    public void testOrderByValue() {
        KV.OrderByValue orderByValue = new KV.OrderByValue();
        for (Integer key1 : TEST_VALUES) {
            for (Integer val1 : TEST_VALUES) {
                for (Integer key2 : TEST_VALUES) {
                    for (Integer val2 : TEST_VALUES) {
                        Assert.assertEquals((long)this.compareInt(val1, val2), (long)orderByValue.compare(KV.of((Object)key1, (Object)val1), KV.of((Object)key2, (Object)val2)));
                    }
                }
            }
        }
    }
}

