/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ReflectHelpersTest {
    @Test
    public void testClassName() {
        Assert.assertEquals((Object)this.getClass().getName(), ReflectHelpers.CLASS_NAME.apply(this.getClass()));
    }

    @Test
    public void testClassSimpleName() {
        Assert.assertEquals((Object)this.getClass().getSimpleName(), ReflectHelpers.CLASS_SIMPLE_NAME.apply(this.getClass()));
    }

    @Test
    public void testMethodFormatter() throws Exception {
        Assert.assertEquals((Object)"testMethodFormatter()", ReflectHelpers.METHOD_FORMATTER.apply(this.getClass().getMethod("testMethodFormatter", new Class[0])));
        Assert.assertEquals((Object)"oneArg(int)", ReflectHelpers.METHOD_FORMATTER.apply(this.getClass().getDeclaredMethod("oneArg", Integer.TYPE)));
        Assert.assertEquals((Object)"twoArg(String, List)", ReflectHelpers.METHOD_FORMATTER.apply(this.getClass().getDeclaredMethod("twoArg", String.class, List.class)));
    }

    @Test
    public void testClassMethodFormatter() throws Exception {
        Assert.assertEquals((Object)(this.getClass().getName() + "#testMethodFormatter()"), ReflectHelpers.CLASS_AND_METHOD_FORMATTER.apply(this.getClass().getMethod("testMethodFormatter", new Class[0])));
        Assert.assertEquals((Object)(this.getClass().getName() + "#oneArg(int)"), ReflectHelpers.CLASS_AND_METHOD_FORMATTER.apply(this.getClass().getDeclaredMethod("oneArg", Integer.TYPE)));
        Assert.assertEquals((Object)(this.getClass().getName() + "#twoArg(String, List)"), ReflectHelpers.CLASS_AND_METHOD_FORMATTER.apply(this.getClass().getDeclaredMethod("twoArg", String.class, List.class)));
    }

    void oneArg(int n) {
    }

    void twoArg(String foo, List<Integer> bar) {
    }

    @Test
    public void testTypeFormatterOnClasses() throws Exception {
        Assert.assertEquals((Object)"Integer", ReflectHelpers.TYPE_SIMPLE_DESCRIPTION.apply(Integer.class));
        Assert.assertEquals((Object)"int", ReflectHelpers.TYPE_SIMPLE_DESCRIPTION.apply(Integer.TYPE));
        Assert.assertEquals((Object)"Map", ReflectHelpers.TYPE_SIMPLE_DESCRIPTION.apply(Map.class));
        Assert.assertEquals((Object)this.getClass().getSimpleName(), ReflectHelpers.TYPE_SIMPLE_DESCRIPTION.apply(this.getClass()));
    }

    @Test
    public void testTypeFormatterOnArrays() throws Exception {
        Assert.assertEquals((Object)"Integer[]", ReflectHelpers.TYPE_SIMPLE_DESCRIPTION.apply(Integer[].class));
        Assert.assertEquals((Object)"int[]", ReflectHelpers.TYPE_SIMPLE_DESCRIPTION.apply(int[].class));
    }

    @Test
    public void testTypeFormatterWithGenerics() throws Exception {
        Assert.assertEquals((Object)"Map<Integer, String>", ReflectHelpers.TYPE_SIMPLE_DESCRIPTION.apply(new TypeDescriptor<Map<Integer, String>>(){}.getType()));
        Assert.assertEquals((Object)"Map<?, String>", ReflectHelpers.TYPE_SIMPLE_DESCRIPTION.apply(new TypeDescriptor<Map<?, String>>(){}.getType()));
        Assert.assertEquals((Object)"Map<? extends Integer, String>", ReflectHelpers.TYPE_SIMPLE_DESCRIPTION.apply(new TypeDescriptor<Map<? extends Integer, String>>(){}.getType()));
    }

    @Test
    public <T> void testTypeFormatterWithWildcards() throws Exception {
        Assert.assertEquals((Object)"Map<T, T>", ReflectHelpers.TYPE_SIMPLE_DESCRIPTION.apply(new TypeDescriptor<Map<T, T>>(){}.getType()));
    }

    @Test
    public <InputT, OutputT> void testTypeFormatterWithMultipleWildcards() throws Exception {
        Assert.assertEquals((Object)"Map<? super InputT, ? extends OutputT>", ReflectHelpers.TYPE_SIMPLE_DESCRIPTION.apply(new TypeDescriptor<Map<? super InputT, ? extends OutputT>>(){}.getType()));
    }

    @Test
    public void testAnnotationFormatter() throws Exception {
        Assert.assertEquals((Object)"Default.String(value=package.OuterClass$InnerClass#method())", ReflectHelpers.ANNOTATION_FORMATTER.apply(Options.class.getMethod("getString", new Class[0]).getAnnotations()[0]));
        Assert.assertEquals((Object)"JsonIgnore(value=true)", ReflectHelpers.ANNOTATION_FORMATTER.apply(Options.class.getMethod("getObject", new Class[0]).getAnnotations()[0]));
    }

    @Test
    public void testFindProperClassLoaderIfContextClassLoaderIsNull() throws InterruptedException {
        ClassLoader[] classLoader = new ClassLoader[1];
        Thread thread = new Thread(() -> {
            classLoader[0] = ReflectHelpers.findClassLoader();
        });
        thread.setContextClassLoader(null);
        thread.start();
        thread.join();
        Assert.assertEquals((Object)ReflectHelpers.class.getClassLoader(), (Object)classLoader[0]);
    }

    @Test
    public void testFindProperClassLoaderIfContextClassLoaderIsAvailable() throws InterruptedException {
        ClassLoader[] classLoader = new ClassLoader[1];
        Thread thread = new Thread(() -> {
            classLoader[0] = ReflectHelpers.findClassLoader();
        });
        ClassLoader cl = new ClassLoader(){};
        thread.setContextClassLoader(cl);
        thread.start();
        thread.join();
        Assert.assertEquals((Object)cl, (Object)classLoader[0]);
    }

    private static interface Options
    extends PipelineOptions {
        @Default.String(value="package.OuterClass$InnerClass#method()")
        public String getString();

        @JsonIgnore
        public Object getObject();
    }
}

