/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.FluentIterable;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.io.ByteSource;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.io.CharSource;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.io.FileWriteMode;
import org.apache.beam.sdk.util.ZipFiles;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ZipFilesTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    private File tmpDir;
    @Rule
    public TemporaryFolder tmpOutputFolder = new TemporaryFolder();
    private File zipFile;

    @Before
    public void setUp() throws Exception {
        this.tmpDir = this.tmpFolder.getRoot();
        this.zipFile = this.createZipFileHandle();
    }

    @Test
    public void testZipWithSubdirectories() throws Exception {
        File zipDir = new File(this.tmpDir, "zip");
        File subDir1 = new File(zipDir, "subDir1");
        File subDir2 = new File(subDir1, "subdir2");
        Assert.assertTrue((boolean)subDir2.mkdirs());
        this.createFileWithContents(subDir2, "myTextFile.txt", "Simple Text");
        this.assertZipAndUnzipOfDirectoryMatchesOriginal(this.tmpDir);
    }

    @Test
    public void testEmptySubdirectoryHasZipEntry() throws Exception {
        File zipDir = new File(this.tmpDir, "zip");
        File subDirEmpty = new File(zipDir, "subDirEmpty");
        Assert.assertTrue((boolean)subDirEmpty.mkdirs());
        ZipFiles.zipDirectory((File)this.tmpDir, (File)this.zipFile);
        this.assertZipOnlyContains("zip/subDirEmpty/");
    }

    @Test
    public void testSubdirectoryWithContentsHasNoZipEntry() throws Exception {
        File zipDir = new File(this.tmpDir, "zip");
        File subDirContent = new File(zipDir, "subdirContent");
        Assert.assertTrue((boolean)subDirContent.mkdirs());
        this.createFileWithContents(subDirContent, "myTextFile.txt", "Simple Text");
        ZipFiles.zipDirectory((File)this.tmpDir, (File)this.zipFile);
        this.assertZipOnlyContains("zip/subdirContent/myTextFile.txt");
    }

    @Test
    public void testZipDirectoryToOutputStream() throws Exception {
        this.createFileWithContents(this.tmpDir, "myTextFile.txt", "Simple Text");
        Object[] sourceFiles = this.tmpDir.listFiles();
        Arrays.sort(sourceFiles);
        Assert.assertThat((Object)sourceFiles, (Matcher)Matchers.not((Matcher)Matchers.arrayWithSize((int)0)));
        try (FileOutputStream outputStream = new FileOutputStream(this.zipFile);){
            ZipFiles.zipDirectory((File)this.tmpDir, (OutputStream)outputStream);
        }
        File outputDir = org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.io.Files.createTempDir();
        ZipFiles.unzipFile((File)this.zipFile, (File)outputDir);
        Object[] outputFiles = outputDir.listFiles();
        Arrays.sort(outputFiles);
        Assert.assertThat((Object)outputFiles, (Matcher)Matchers.arrayWithSize((int)sourceFiles.length));
        for (int i = 0; i < sourceFiles.length; ++i) {
            this.compareFileContents((File)sourceFiles[i], (File)outputFiles[i]);
        }
        ZipFilesTest.removeRecursive(outputDir.toPath());
        Assert.assertTrue((boolean)this.zipFile.delete());
    }

    @Test
    public void testEntries() throws Exception {
        File zipDir = new File(this.tmpDir, "zip");
        File subDir1 = new File(zipDir, "subDir1");
        File subDir2 = new File(subDir1, "subdir2");
        Assert.assertTrue((boolean)subDir2.mkdirs());
        this.createFileWithContents(subDir2, "myTextFile.txt", "Simple Text");
        ZipFiles.zipDirectory((File)this.tmpDir, (File)this.zipFile);
        try (ZipFile zip = new ZipFile(this.zipFile);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            for (ZipEntry entry : ZipFiles.entries((ZipFile)zip)) {
                Assert.assertTrue((boolean)entries.hasMoreElements());
                Assert.assertEquals((Object)entry.getName(), (Object)entries.nextElement().getName());
            }
            Assert.assertFalse((boolean)entries.hasMoreElements());
        }
    }

    @Test
    public void testAsByteSource() throws Exception {
        File zipDir = new File(this.tmpDir, "zip");
        Assert.assertTrue((boolean)zipDir.mkdirs());
        this.createFileWithContents(zipDir, "myTextFile.txt", "Simple Text");
        ZipFiles.zipDirectory((File)this.tmpDir, (File)this.zipFile);
        try (ZipFile zip = new ZipFile(this.zipFile);){
            ZipEntry entry = zip.getEntry("zip/myTextFile.txt");
            ByteSource byteSource = ZipFiles.asByteSource((ZipFile)zip, (ZipEntry)entry);
            if (entry.getSize() != -1L) {
                Assert.assertEquals((long)entry.getSize(), (long)byteSource.size());
            }
            Assert.assertArrayEquals((byte[])"Simple Text".getBytes(StandardCharsets.UTF_8), (byte[])byteSource.read());
        }
    }

    @Test
    public void testAsCharSource() throws Exception {
        File zipDir = new File(this.tmpDir, "zip");
        Assert.assertTrue((boolean)zipDir.mkdirs());
        this.createFileWithContents(zipDir, "myTextFile.txt", "Simple Text");
        ZipFiles.zipDirectory((File)this.tmpDir, (File)this.zipFile);
        try (ZipFile zip = new ZipFile(this.zipFile);){
            ZipEntry entry = zip.getEntry("zip/myTextFile.txt");
            CharSource charSource = ZipFiles.asCharSource((ZipFile)zip, (ZipEntry)entry, (Charset)StandardCharsets.UTF_8);
            Assert.assertEquals((Object)"Simple Text", (Object)charSource.read());
        }
    }

    private void assertZipOnlyContains(String zipFileEntry) throws IOException {
        try (ZipFile zippedFile = new ZipFile(this.zipFile);){
            Assert.assertEquals((long)1L, (long)zippedFile.size());
            ZipEntry entry = zippedFile.entries().nextElement();
            Assert.assertEquals((Object)zipFileEntry, (Object)entry.getName());
        }
    }

    @Test
    public void testInvalidTargetDirectory() throws IOException {
        File zipDir = new File(this.tmpDir, "zipdir");
        Assert.assertTrue((boolean)zipDir.mkdir());
        ZipFiles.zipDirectory((File)this.tmpDir, (File)this.zipFile);
        File invalidDirectory = new File("/foo/bar");
        Assert.assertTrue((!invalidDirectory.exists() ? 1 : 0) != 0);
        try {
            ZipFiles.unzipFile((File)this.zipFile, (File)invalidDirectory);
            Assert.fail((String)"We expect the IllegalArgumentException, but it never occured");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDirectoryCreateFailed() throws IOException {
        File zipDir = new File(this.tmpDir, "zipdir");
        Assert.assertTrue((boolean)zipDir.mkdir());
        ZipFiles.zipDirectory((File)this.tmpDir, (File)this.zipFile);
        File targetDirectory = org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.io.Files.createTempDir();
        org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.io.Files.touch(new File(targetDirectory, "zipdir"));
        try {
            ZipFiles.unzipFile((File)this.zipFile, (File)targetDirectory);
            Assert.fail((String)"We expect the IOException, but it never occured");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void assertZipAndUnzipOfDirectoryMatchesOriginal(File sourceDir) throws IOException {
        Object[] sourceFiles = sourceDir.listFiles();
        Arrays.sort(sourceFiles);
        File zipFile = this.createZipFileHandle();
        ZipFiles.zipDirectory((File)sourceDir, (File)zipFile);
        File outputDir = org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.io.Files.createTempDir();
        ZipFiles.unzipFile((File)zipFile, (File)outputDir);
        Object[] outputFiles = outputDir.listFiles();
        Arrays.sort(outputFiles);
        Assert.assertThat((Object)outputFiles, (Matcher)Matchers.arrayWithSize((int)sourceFiles.length));
        for (int i = 0; i < sourceFiles.length; ++i) {
            this.compareFileContents((File)sourceFiles[i], (File)outputFiles[i]);
        }
        ZipFilesTest.removeRecursive(outputDir.toPath());
        Assert.assertTrue((boolean)zipFile.delete());
    }

    private void compareFileContents(File expected, File actual) throws IOException {
        Assert.assertEquals((Object)expected.isDirectory(), (Object)actual.isDirectory());
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        if (expected.isDirectory()) {
            Object[] expectedChildren = expected.listFiles();
            Arrays.sort(expectedChildren);
            Object[] actualChildren = actual.listFiles();
            Arrays.sort(actualChildren);
            Assert.assertThat((Object)actualChildren, (Matcher)Matchers.arrayWithSize((int)expectedChildren.length));
            for (int i = 0; i < expectedChildren.length; ++i) {
                this.compareFileContents((File)expectedChildren[i], (File)actualChildren[i]);
            }
        } else {
            Assert.assertTrue((boolean)org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.io.Files.equal(expected, actual));
        }
    }

    private File createZipFileHandle() throws IOException {
        File zipFile = File.createTempFile("test", "zip", this.tmpOutputFolder.getRoot());
        Assert.assertTrue((boolean)zipFile.delete());
        return zipFile;
    }

    private static void removeRecursive(Path path) throws IOException {
        FluentIterable<File> files = org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.io.Files.fileTreeTraverser().postOrderTraversal(path.toFile());
        for (File f : files) {
            Files.delete(f.toPath());
        }
    }

    private void createFileWithContents(File dir, String fileName, String fileContents) throws IOException {
        File txtFile = new File(dir, fileName);
        org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.io.Files.asCharSink(txtFile, StandardCharsets.UTF_8, new FileWriteMode[0]).write(fileContents);
    }
}

