/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.util.Arrays;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Iterables;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.WindowedValue;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class WindowedValueTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testWindowedValueCoder() throws CoderException {
        Instant timestamp = new Instant(1234L);
        WindowedValue value = WindowedValue.of((Object)"abc", (Instant)new Instant(1234L), Arrays.asList(new IntervalWindow(timestamp, timestamp.plus(1000L)), new IntervalWindow(timestamp.plus(1000L), timestamp.plus(2000L))), (PaneInfo)PaneInfo.NO_FIRING);
        WindowedValue.FullWindowedValueCoder windowedValueCoder = WindowedValue.getFullCoder((Coder)StringUtf8Coder.of(), (Coder)IntervalWindow.getCoder());
        byte[] encodedValue = CoderUtils.encodeToByteArray((Coder)windowedValueCoder, (Object)value);
        WindowedValue decodedValue = (WindowedValue)CoderUtils.decodeFromByteArray((Coder)windowedValueCoder, (byte[])encodedValue);
        Assert.assertEquals((Object)value.getValue(), (Object)decodedValue.getValue());
        Assert.assertEquals((Object)value.getTimestamp(), (Object)decodedValue.getTimestamp());
        Assert.assertArrayEquals((Object[])value.getWindows().toArray(), (Object[])decodedValue.getWindows().toArray());
    }

    @Test
    public void testFullWindowedValueCoderIsSerializableWithWellKnownCoderType() {
        CoderProperties.coderSerializable((Coder)WindowedValue.getFullCoder((Coder)GlobalWindow.Coder.INSTANCE, (Coder)GlobalWindow.Coder.INSTANCE));
    }

    @Test
    public void testValueOnlyWindowedValueCoderIsSerializableWithWellKnownCoderType() {
        CoderProperties.coderSerializable((Coder)WindowedValue.getValueOnlyCoder((Coder)GlobalWindow.Coder.INSTANCE));
    }

    @Test
    public void testExplodeWindowsInNoWindowsCrash() {
        this.thrown.expect(IllegalArgumentException.class);
        WindowedValue.of((Object)"foo", (Instant)Instant.now(), ImmutableList.of(), (PaneInfo)PaneInfo.NO_FIRING);
    }

    @Test
    public void testExplodeWindowsInOneWindowEquals() {
        Instant now = Instant.now();
        IntervalWindow window = new IntervalWindow(now.minus(1000L), now.plus(1000L));
        WindowedValue value = WindowedValue.of((Object)"foo", (Instant)now, (BoundedWindow)window, (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING);
        Assert.assertThat((Object)((WindowedValue)Iterables.getOnlyElement(value.explodeWindows())), (Matcher)Matchers.equalTo((Object)value));
    }

    @Test
    public void testExplodeWindowsManyWindowsMultipleWindowedValues() {
        Instant now = Instant.now();
        IntervalWindow centerWindow = new IntervalWindow(now.minus(1000L), now.plus(1000L));
        IntervalWindow pastWindow = new IntervalWindow(now.minus(1500L), now.plus(500L));
        IntervalWindow futureWindow = new IntervalWindow(now.minus(500L), now.plus(1500L));
        IntervalWindow futureFutureWindow = new IntervalWindow(now, now.plus(2000L));
        PaneInfo pane = PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME, (long)3L, (long)0L);
        WindowedValue value = WindowedValue.of((Object)"foo", (Instant)now, ImmutableList.of(pastWindow, centerWindow, futureWindow, futureFutureWindow), (PaneInfo)pane);
        Assert.assertThat((Object)value.explodeWindows(), (Matcher)Matchers.containsInAnyOrder((Object[])new WindowedValue[]{WindowedValue.of((Object)"foo", (Instant)now, (BoundedWindow)futureFutureWindow, (PaneInfo)pane), WindowedValue.of((Object)"foo", (Instant)now, (BoundedWindow)futureWindow, (PaneInfo)pane), WindowedValue.of((Object)"foo", (Instant)now, (BoundedWindow)centerWindow, (PaneInfo)pane), WindowedValue.of((Object)"foo", (Instant)now, (BoundedWindow)pastWindow, (PaneInfo)pane)}));
    }
}

