/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.util.VarInt;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class VarIntTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private static final long[] LONG_VALUES = new long[]{0L, 1L, 127L, 128L, 16383L, 16384L, 0x1FFFFFL, 0x200000L, 0xFFFFFFFL, 0x10000000L, 0x7FFFFFFFFL, 0x800000000L, Long.MAX_VALUE, Long.MIN_VALUE, -1L};
    private static final byte[][] LONG_ENCODED = new byte[][]{{0}, {1}, {127}, {-128, 1}, {-1, 127}, {-128, -128, 1}, {-1, -1, 127}, {-128, -128, -128, 1}, {-1, -1, -1, 127}, {-128, -128, -128, -128, 1}, {-1, -1, -1, -1, 127}, {-128, -128, -128, -128, -128, 1}, {-1, -1, -1, -1, -1, -1, -1, -1, 127}, {-128, -128, -128, -128, -128, -128, -128, -128, -128, 1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, 1}};
    private static final int[] INT_VALUES = new int[]{0, 1, 127, 128, 16383, 16384, 0x1FFFFF, 0x200000, 0xFFFFFFF, 0x10000000, Integer.MAX_VALUE, Integer.MIN_VALUE, -1};
    private static final byte[][] INT_ENCODED = new byte[][]{{0}, {1}, {127}, {-128, 1}, {-1, 127}, {-128, -128, 1}, {-1, -1, 127}, {-128, -128, -128, 1}, {-1, -1, -1, 127}, {-128, -128, -128, -128, 1}, {-1, -1, -1, -1, 7}, {-128, -128, -128, -128, 8}, {-1, -1, -1, -1, 15}};

    private static byte[] encodeInt(int v) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        VarInt.encode((int)v, (OutputStream)stream);
        return stream.toByteArray();
    }

    private static byte[] encodeLong(long v) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        VarInt.encode((long)v, (OutputStream)stream);
        return stream.toByteArray();
    }

    private static int decodeInt(byte[] encoded) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(encoded);
        return VarInt.decodeInt((InputStream)stream);
    }

    private static long decodeLong(byte[] encoded) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(encoded);
        return VarInt.decodeLong((InputStream)stream);
    }

    @Test
    public void decodeValues() throws IOException {
        ByteArrayInputStream stream;
        int i;
        Assert.assertEquals((long)LONG_VALUES.length, (long)LONG_ENCODED.length);
        for (i = 0; i < LONG_ENCODED.length; ++i) {
            stream = new ByteArrayInputStream(LONG_ENCODED[i]);
            long parsed = VarInt.decodeLong((InputStream)stream);
            Assert.assertEquals((long)LONG_VALUES[i], (long)parsed);
            Assert.assertEquals((long)-1L, (long)stream.read());
        }
        Assert.assertEquals((long)INT_VALUES.length, (long)INT_ENCODED.length);
        for (i = 0; i < INT_ENCODED.length; ++i) {
            stream = new ByteArrayInputStream(INT_ENCODED[i]);
            int parsed = VarInt.decodeInt((InputStream)stream);
            Assert.assertEquals((long)INT_VALUES[i], (long)parsed);
            Assert.assertEquals((long)-1L, (long)stream.read());
        }
    }

    @Test
    public void encodeValuesAndGetLength() throws IOException {
        byte[] encoded;
        int i;
        Assert.assertEquals((long)LONG_VALUES.length, (long)LONG_ENCODED.length);
        for (i = 0; i < LONG_VALUES.length; ++i) {
            encoded = VarIntTest.encodeLong(LONG_VALUES[i]);
            Assert.assertThat((Object)encoded, (Matcher)Matchers.equalTo((Object)LONG_ENCODED[i]));
            Assert.assertEquals((long)LONG_ENCODED[i].length, (long)VarInt.getLength((long)LONG_VALUES[i]));
        }
        Assert.assertEquals((long)INT_VALUES.length, (long)INT_ENCODED.length);
        for (i = 0; i < INT_VALUES.length; ++i) {
            encoded = VarIntTest.encodeInt(INT_VALUES[i]);
            Assert.assertThat((Object)encoded, (Matcher)Matchers.equalTo((Object)INT_ENCODED[i]));
            Assert.assertEquals((long)INT_ENCODED[i].length, (long)VarInt.getLength((int)INT_VALUES[i]));
        }
    }

    @Test
    public void decodeThrowsExceptionForOverflow() throws IOException {
        byte[] tooLargeNumber = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, 2};
        this.thrown.expect(IOException.class);
        VarIntTest.decodeLong(tooLargeNumber);
    }

    @Test
    public void decodeThrowsExceptionForIntOverflow() throws IOException {
        byte[] encoded = VarIntTest.encodeLong(0x100000000L);
        this.thrown.expect(IOException.class);
        VarIntTest.decodeInt(encoded);
    }

    @Test
    public void decodeThrowsExceptionForIntUnderflow() throws IOException {
        byte[] encoded = VarIntTest.encodeLong(-1L);
        this.thrown.expect(IOException.class);
        VarIntTest.decodeInt(encoded);
    }

    @Test
    public void decodeThrowsExceptionForNonterminated() throws IOException {
        byte[] nonTerminatedNumber = new byte[]{-1, -1};
        this.thrown.expect(IOException.class);
        VarIntTest.decodeLong(nonTerminatedNumber);
    }

    @Test
    public void decodeParsesEncodedValues() throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        int i = 10;
        while (i < Integer.MAX_VALUE) {
            VarInt.encode((int)i, (OutputStream)outStream);
            VarInt.encode((int)(-i), (OutputStream)outStream);
            i = (int)((double)i * 1.1);
        }
        long i2 = 10L;
        while (i2 < Long.MAX_VALUE) {
            VarInt.encode((long)i2, (OutputStream)outStream);
            VarInt.encode((long)(-i2), (OutputStream)outStream);
            i2 = (long)((double)i2 * 1.1);
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
        int i3 = 10;
        while (i3 < Integer.MAX_VALUE) {
            Assert.assertEquals((long)i3, (long)VarInt.decodeInt((InputStream)inStream));
            Assert.assertEquals((long)(-i3), (long)VarInt.decodeInt((InputStream)inStream));
            i3 = (int)((double)i3 * 1.1);
        }
        long i32 = 10L;
        while (i32 < Long.MAX_VALUE) {
            Assert.assertEquals((long)i32, (long)VarInt.decodeLong((InputStream)inStream));
            Assert.assertEquals((long)(-i32), (long)VarInt.decodeLong((InputStream)inStream));
            i32 = (long)((double)i32 * 1.1);
        }
    }

    @Test
    public void endOfFileThrowsException() throws Exception {
        ByteArrayInputStream inStream = new ByteArrayInputStream(new byte[0]);
        this.thrown.expect(EOFException.class);
        VarInt.decodeInt((InputStream)inStream);
    }

    @Test
    public void unterminatedThrowsException() throws Exception {
        byte[] e = VarIntTest.encodeLong(Long.MAX_VALUE);
        byte[] s = new byte[]{e[0]};
        ByteArrayInputStream inStream = new ByteArrayInputStream(s);
        this.thrown.expect(IOException.class);
        VarInt.decodeInt((InputStream)inStream);
    }
}

