/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.IOException;
import org.apache.beam.sdk.util.UserCodeException;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class UserCodeExceptionTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void existingUserCodeExceptionsNotWrapped() {
        UserCodeException existing = UserCodeException.wrap((Throwable)new IOException());
        UserCodeException wrapped = UserCodeException.wrap((Throwable)existing);
        Assert.assertEquals((Object)existing, (Object)wrapped);
    }

    @Test
    public void testCauseIsSet() {
        this.thrown.expectCause(Matchers.isA(IOException.class));
        this.throwUserCodeException();
    }

    @Test
    public void testStackTraceIsTruncatedToUserCode() {
        this.thrown.expectCause((Matcher)UserCodeExceptionTest.hasBottomStackFrame((Matcher<StackTraceElement>)UserCodeExceptionTest.method("userCode")));
        this.throwUserCodeException();
    }

    @Test
    public void testStackTraceIsTruncatedProperlyFromHelperMethod() {
        this.thrown.expectCause((Matcher)UserCodeExceptionTest.hasBottomStackFrame((Matcher<StackTraceElement>)UserCodeExceptionTest.method("userCode")));
        this.throwUserCodeExceptionFromHelper();
    }

    @Test
    public void testWrapIfOnlyWrapsWhenTrue() {
        IOException cause = new IOException();
        RuntimeException wrapped = UserCodeException.wrapIf((boolean)true, (Throwable)cause);
        Assert.assertThat((Object)wrapped, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(UserCodeException.class)));
    }

    @Test
    public void testWrapIfReturnsRuntimeExceptionWhenFalse() {
        IOException cause = new IOException();
        RuntimeException wrapped = UserCodeException.wrapIf((boolean)false, (Throwable)cause);
        Assert.assertThat((Object)wrapped, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.instanceOf(UserCodeException.class))));
        Assert.assertEquals((Object)cause, (Object)wrapped.getCause());
    }

    @Test
    public void testWrapIfReturnsSourceRuntimeExceptionWhenFalse() {
        RuntimeException runtimeException = new RuntimeException("oh noes!");
        RuntimeException wrapped = UserCodeException.wrapIf((boolean)false, (Throwable)runtimeException);
        Assert.assertEquals((Object)runtimeException, (Object)wrapped);
    }

    @Test
    public void robustAgainstEmptyStackTrace() {
        RuntimeException runtimeException = new RuntimeException("empty stack");
        runtimeException.setStackTrace(new StackTraceElement[0]);
        UserCodeException wrapped = UserCodeException.wrap((Throwable)runtimeException);
        Assert.assertEquals((Object)runtimeException, (Object)wrapped.getCause());
    }

    private void throwUserCodeException() {
        try {
            this.userCode();
        }
        catch (Exception ex) {
            throw UserCodeException.wrap((Throwable)ex);
        }
    }

    private void throwUserCodeExceptionFromHelper() {
        try {
            this.userCode();
        }
        catch (Exception ex) {
            throw this.wrap(ex);
        }
    }

    private UserCodeException wrap(Throwable t) {
        throw UserCodeException.wrap((Throwable)t);
    }

    private void userCode() throws IOException {
        this.userCode2();
    }

    private void userCode2() throws IOException {
        this.userCode3();
    }

    private void userCode3() throws IOException {
        IOException ex = new IOException("User processing error!");
        throw ex;
    }

    private static ThrowableBottomStackFrameMethodMatcher hasBottomStackFrame(Matcher<StackTraceElement> frameMatcher) {
        return new ThrowableBottomStackFrameMethodMatcher(frameMatcher);
    }

    private static StackFrameMethodMatcher method(String methodName) {
        return new StackFrameMethodMatcher((Matcher<String>)Matchers.is((Object)methodName));
    }

    static class StackFrameMethodMatcher
    extends TypeSafeMatcher<StackTraceElement> {
        private Matcher<String> methodNameMatcher;

        public StackFrameMethodMatcher(Matcher<String> methodNameMatcher) {
            this.methodNameMatcher = methodNameMatcher;
        }

        public void describeTo(Description description) {
            description.appendText("stack frame where method name ");
            this.methodNameMatcher.describeTo(description);
        }

        protected boolean matchesSafely(StackTraceElement item) {
            return this.methodNameMatcher.matches((Object)item.getMethodName());
        }
    }

    static class ThrowableBottomStackFrameMethodMatcher
    extends FeatureMatcher<Throwable, StackTraceElement> {
        public ThrowableBottomStackFrameMethodMatcher(Matcher<StackTraceElement> subMatcher) {
            super(subMatcher, "Throwable with bottom stack frame:", "stack frame");
        }

        protected StackTraceElement featureValueOf(Throwable actual) {
            StackTraceElement[] stackTrace = actual.getStackTrace();
            return stackTrace[stackTrace.length - 1];
        }
    }
}

