/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.util.UnownedOutputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class UnownedOutputStreamTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ByteArrayOutputStream baos;
    private UnownedOutputStream os;

    @Before
    public void setup() {
        this.baos = new ByteArrayOutputStream();
        this.os = new UnownedOutputStream((OutputStream)this.baos);
    }

    @Test
    public void testHashCodeEqualsAndToString() throws Exception {
        Assert.assertEquals((long)this.baos.hashCode(), (long)this.os.hashCode());
        Assert.assertEquals((Object)("UnownedOutputStream{out=" + this.baos + "}"), (Object)this.os.toString());
        Assert.assertEquals((Object)new UnownedOutputStream((OutputStream)this.baos), (Object)this.os);
    }

    @Test
    public void testClosingThrows() throws Exception {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Caller does not own the underlying");
        this.os.close();
    }
}

