/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.beam.sdk.util.UnownedInputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class UnownedInputStreamTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ByteArrayInputStream bais;
    private UnownedInputStream os;

    @Before
    public void setup() {
        this.bais = new ByteArrayInputStream(new byte[]{1, 2, 3});
        this.os = new UnownedInputStream((InputStream)this.bais);
    }

    @Test
    public void testHashCodeEqualsAndToString() throws Exception {
        Assert.assertEquals((long)this.bais.hashCode(), (long)this.os.hashCode());
        Assert.assertEquals((Object)("UnownedInputStream{in=" + this.bais + "}"), (Object)this.os.toString());
        Assert.assertEquals((Object)new UnownedInputStream((InputStream)this.bais), (Object)this.os);
    }

    @Test
    public void testClosingThrows() throws Exception {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Caller does not own the underlying");
        this.expectedException.expectMessage("close()");
        this.os.close();
    }

    @Test
    public void testMarkThrows() throws Exception {
        Assert.assertFalse((boolean)this.os.markSupported());
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Caller does not own the underlying");
        this.expectedException.expectMessage("mark()");
        this.os.mark(1);
    }

    @Test
    public void testResetThrows() throws Exception {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Caller does not own the underlying");
        this.expectedException.expectMessage("reset()");
        this.os.reset();
    }
}

