/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import org.apache.beam.sdk.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class StringUtilsTest {
    @Test
    public void testTranscodeEmptyByteArray() {
        byte[] bytes = new byte[]{};
        String string = "";
        Assert.assertEquals((Object)string, (Object)StringUtils.byteArrayToJsonString((byte[])bytes));
        Assert.assertArrayEquals((byte[])bytes, (byte[])StringUtils.jsonStringToByteArray((String)string));
    }

    @Test
    public void testTranscodeMixedByteArray() {
        byte[] bytes = new byte[]{0, 5, 12, 16, 31, 32, 65, 66, 126, 127, -128, -1, 67, 0};
        String string = "%00%05%0c%10%1f AB~%7f%80%ffC%00";
        Assert.assertEquals((Object)string, (Object)StringUtils.byteArrayToJsonString((byte[])bytes));
        Assert.assertArrayEquals((byte[])bytes, (byte[])StringUtils.jsonStringToByteArray((String)string));
    }

    @Test
    public void testLevenshteinDistance() {
        Assert.assertEquals((long)0L, (long)StringUtils.getLevenshteinDistance((String)"", (String)""));
        Assert.assertEquals((long)3L, (long)StringUtils.getLevenshteinDistance((String)"", (String)"abc"));
        Assert.assertEquals((long)3L, (long)StringUtils.getLevenshteinDistance((String)"abc", (String)""));
        Assert.assertEquals((long)5L, (long)StringUtils.getLevenshteinDistance((String)"abc", (String)"12345"));
        Assert.assertEquals((long)1L, (long)StringUtils.getLevenshteinDistance((String)"abc", (String)"ac"));
        Assert.assertEquals((long)1L, (long)StringUtils.getLevenshteinDistance((String)"abc", (String)"ab1c"));
        Assert.assertEquals((long)1L, (long)StringUtils.getLevenshteinDistance((String)"abc", (String)"a1c"));
    }
}

