/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.beam.sdk.util.ExposedByteArrayInputStream;
import org.apache.beam.sdk.util.StreamUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class StreamUtilsTest {
    private byte[] testData = null;

    @Before
    public void setUp() {
        this.testData = new byte[61440];
        Arrays.fill(this.testData, (byte)32);
    }

    @Test
    public void testGetBytesFromExposedByteArrayInputStream() throws IOException {
        ExposedByteArrayInputStream stream = new ExposedByteArrayInputStream(this.testData);
        byte[] bytes = StreamUtils.getBytesWithoutClosing((InputStream)stream);
        Assert.assertArrayEquals((byte[])this.testData, (byte[])bytes);
        Assert.assertSame((Object)this.testData, (Object)bytes);
        Assert.assertEquals((long)0L, (long)stream.available());
    }

    @Test
    public void testGetBytesFromByteArrayInputStream() throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(this.testData);
        byte[] bytes = StreamUtils.getBytesWithoutClosing((InputStream)stream);
        Assert.assertArrayEquals((byte[])this.testData, (byte[])bytes);
        Assert.assertEquals((long)0L, (long)((InputStream)stream).available());
    }

    @Test
    public void testGetBytesFromInputStream() throws IOException {
        BufferedInputStream stream = new BufferedInputStream(new ByteArrayInputStream(this.testData));
        byte[] bytes = StreamUtils.getBytesWithoutClosing((InputStream)stream);
        Assert.assertArrayEquals((byte[])this.testData, (byte[])bytes);
        Assert.assertEquals((long)0L, (long)((InputStream)stream).available());
    }
}

