/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Charsets;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.testing.InterceptingUrlClassLoader;
import org.apache.beam.sdk.util.SerializableUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SerializableUtilsTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void customClassLoader() throws Exception {
        ClassLoader testLoader = Thread.currentThread().getContextClassLoader();
        InterceptingUrlClassLoader loader = new InterceptingUrlClassLoader(testLoader, MySource.class.getName());
        Class<?> source = ((ClassLoader)loader).loadClass("org.apache.beam.sdk.util.SerializableUtilsTest$MySource");
        Assert.assertNotSame((Object)source.getClassLoader(), (Object)MySource.class.getClassLoader());
        Serializable customLoaderSourceInstance = (Serializable)Serializable.class.cast(source.getConstructor(new Class[0]).newInstance(new Object[0]));
        Thread thread = Thread.currentThread();
        thread.setContextClassLoader(loader);
        try {
            this.assertSerializationClassLoader(loader, customLoaderSourceInstance);
        }
        finally {
            thread.setContextClassLoader(testLoader);
        }
        this.assertSerializationClassLoader(loader, customLoaderSourceInstance);
    }

    @Test
    public void testTranscode() {
        String stringValue = "hi bob";
        int intValue = 42;
        SerializableByJava testObject = new SerializableByJava(stringValue, intValue);
        SerializableByJava testCopy = (SerializableByJava)SerializableUtils.ensureSerializable((Serializable)testObject);
        Assert.assertEquals((Object)stringValue, (Object)testCopy.stringValue);
        Assert.assertEquals((long)intValue, (long)testCopy.intValue);
    }

    @Test
    public void testDeserializationError() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("unable to deserialize a bogus string");
        SerializableUtils.deserializeFromByteArray((byte[])"this isn't legal".getBytes(Charsets.UTF_8), (String)"a bogus string");
    }

    @Test
    public void testSerializationError() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("unable to serialize");
        SerializableUtils.serializeToByteArray((Serializable)new UnserializableByJava());
    }

    @Test
    public void testEnsureSerializableWithUnserializableCoderByJava() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("unable to serialize");
        SerializableUtils.ensureSerializable((Coder)new UnserializableCoderByJava());
    }

    private void assertSerializationClassLoader(ClassLoader loader, Serializable customLoaderSourceInstance) {
        Serializable copy = SerializableUtils.ensureSerializable((Serializable)customLoaderSourceInstance);
        Assert.assertEquals((Object)loader, (Object)copy.getClass().getClassLoader());
        Assert.assertEquals((Object)copy.getClass().getClassLoader(), (Object)customLoaderSourceInstance.getClass().getClassLoader());
    }

    public static class MySource
    extends BoundedSource<String> {
        public List<? extends BoundedSource<String>> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
            return null;
        }

        public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
            return 0L;
        }

        public BoundedSource.BoundedReader<String> createReader(PipelineOptions options) throws IOException {
            return null;
        }
    }

    private static class UnserializableCoderByJava
    extends AtomicCoder<Object> {
        private final Object unserializableField = new Object();

        private UnserializableCoderByJava() {
        }

        public void encode(Object value, OutputStream outStream) throws CoderException, IOException {
        }

        public Object decode(InputStream inStream) throws CoderException, IOException {
            return this.unserializableField;
        }

        public List<? extends Coder<?>> getCoderArguments() {
            return ImmutableList.of();
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
        }
    }

    private static class UnserializableByJava
    implements Serializable {
        private Object unserializableField = new Object();

        private UnserializableByJava() {
        }
    }

    private static class SerializableByJava
    implements Serializable {
        final String stringValue;
        final int intValue;

        public SerializableByJava(String stringValue, int intValue) {
            this.stringValue = stringValue;
            this.intValue = intValue;
        }
    }
}

