/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.util.RowJsonDeserializer;
import org.apache.beam.sdk.values.Row;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RowJsonDeserializerTest {
    private static final Boolean BOOLEAN_TRUE_VALUE = true;
    private static final String BOOLEAN_TRUE_STRING = "true";
    private static final Byte BYTE_VALUE = 126;
    private static final String BYTE_STRING = "126";
    private static final Short SHORT_VALUE = 32766;
    private static final String SHORT_STRING = "32766";
    private static final Integer INT_VALUE = 0x7FFFFFFE;
    private static final String INT_STRING = "2147483646";
    private static final Long LONG_VALUE = 0x7FFFFFFFFFFFFFFEL;
    private static final String LONG_STRING = "9223372036854775806";
    private static final Float FLOAT_VALUE = Float.valueOf(102000.0f);
    private static final String FLOAT_STRING = "1.02e5";
    private static final Double DOUBLE_VALUE = 1.02;
    private static final String DOUBLE_STRING = "1.02";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testParsesFlatRow() throws Exception {
        Schema schema = Schema.builder().addByteField("f_byte").addInt16Field("f_int16").addInt32Field("f_int32").addInt64Field("f_int64").addFloatField("f_float").addDoubleField("f_double").addBooleanField("f_boolean").addStringField("f_string").addDecimalField("f_decimal").build();
        String rowString = "{\n\"f_byte\" : 12,\n\"f_int16\" : 22,\n\"f_int32\" : 32,\n\"f_int64\" : 42,\n\"f_float\" : 1.02E5,\n\"f_double\" : 62.2,\n\"f_boolean\" : true,\n\"f_string\" : \"hello\",\n\"f_decimal\" : 123.12\n}";
        RowJsonDeserializer deserializer = RowJsonDeserializer.forSchema((Schema)schema);
        Row parsedRow = (Row)this.newObjectMapperWith(deserializer).readValue(rowString, Row.class);
        Row expectedRow = Row.withSchema((Schema)schema).addValues(new Object[]{(byte)12, (short)22, 32, 42L, Float.valueOf(102000.0f), 62.2, true, "hello", new BigDecimal("123.12")}).build();
        Assert.assertEquals((Object)expectedRow, (Object)parsedRow);
    }

    @Test
    public void testParsesArrayField() throws Exception {
        Schema schema = Schema.builder().addInt32Field("f_int32").addArrayField("f_intArray", Schema.FieldType.INT32).build();
        String rowString = "{\n\"f_int32\" : 32,\n\"f_intArray\" : [ 1, 2, 3, 4, 5]\n}";
        RowJsonDeserializer deserializer = RowJsonDeserializer.forSchema((Schema)schema);
        Row parsedRow = (Row)this.newObjectMapperWith(deserializer).readValue(rowString, Row.class);
        Row expectedRow = Row.withSchema((Schema)schema).addValues(new Object[]{32, Arrays.asList(1, 2, 3, 4, 5)}).build();
        Assert.assertEquals((Object)expectedRow, (Object)parsedRow);
    }

    @Test
    public void testParsesArrayOfArrays() throws Exception {
        Schema schema = Schema.builder().addArrayField("f_arrayOfIntArrays", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT32)).build();
        String rowString = "{\n\"f_arrayOfIntArrays\" : [ [1, 2], [3, 4], [5]]\n}";
        RowJsonDeserializer deserializer = RowJsonDeserializer.forSchema((Schema)schema);
        Row parsedRow = (Row)this.newObjectMapperWith(deserializer).readValue(rowString, Row.class);
        Row expectedRow = Row.withSchema((Schema)schema).addArray(new Object[]{Arrays.asList(1, 2), Arrays.asList(3, 4), Arrays.asList(5)}).build();
        Assert.assertEquals((Object)expectedRow, (Object)parsedRow);
    }

    @Test
    public void testThrowsForMismatchedArrayField() throws Exception {
        Schema schema = Schema.builder().addArrayField("f_arrayOfIntArrays", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT32)).build();
        String rowString = "{\n\"f_arrayOfIntArrays\" : { }\n}";
        RowJsonDeserializer deserializer = RowJsonDeserializer.forSchema((Schema)schema);
        this.thrown.expect(RowJsonDeserializer.UnsupportedRowJsonException.class);
        this.thrown.expectMessage("Expected JSON array");
        this.newObjectMapperWith(deserializer).readValue(rowString, Row.class);
    }

    @Test
    public void testParsesRowField() throws Exception {
        Schema nestedRowSchema = Schema.builder().addInt32Field("f_nestedInt32").addStringField("f_nestedString").build();
        Schema schema = Schema.builder().addInt32Field("f_int32").addRowField("f_row", nestedRowSchema).build();
        String rowString = "{\n\"f_int32\" : 32,\n\"f_row\" : {\n             \"f_nestedInt32\" : 54,\n             \"f_nestedString\" : \"foo\"\n            }\n}";
        RowJsonDeserializer deserializer = RowJsonDeserializer.forSchema((Schema)schema);
        Row parsedRow = (Row)this.newObjectMapperWith(deserializer).readValue(rowString, Row.class);
        Row expectedRow = Row.withSchema((Schema)schema).addValues(new Object[]{32, Row.withSchema((Schema)nestedRowSchema).addValues(new Object[]{54, "foo"}).build()}).build();
        Assert.assertEquals((Object)expectedRow, (Object)parsedRow);
    }

    @Test
    public void testThrowsForMismatchedRowField() throws Exception {
        Schema nestedRowSchema = Schema.builder().addInt32Field("f_nestedInt32").addStringField("f_nestedString").build();
        Schema schema = Schema.builder().addInt32Field("f_int32").addRowField("f_row", nestedRowSchema).build();
        String rowString = "{\n\"f_int32\" : 32,\n\"f_row\" : []\n}";
        RowJsonDeserializer deserializer = RowJsonDeserializer.forSchema((Schema)schema);
        this.thrown.expect(RowJsonDeserializer.UnsupportedRowJsonException.class);
        this.thrown.expectMessage("Expected JSON object");
        this.newObjectMapperWith(deserializer).readValue(rowString, Row.class);
    }

    @Test
    public void testParsesNestedRowField() throws Exception {
        Schema doubleNestedRowSchema = Schema.builder().addStringField("f_doubleNestedString").build();
        Schema nestedRowSchema = Schema.builder().addRowField("f_nestedRow", doubleNestedRowSchema).build();
        Schema schema = Schema.builder().addRowField("f_row", nestedRowSchema).build();
        String rowString = "{\n\"f_row\" : {\n             \"f_nestedRow\" : {\n                                \"f_doubleNestedString\":\"foo\"\n                               }\n            }\n}";
        RowJsonDeserializer deserializer = RowJsonDeserializer.forSchema((Schema)schema);
        Row parsedRow = (Row)this.newObjectMapperWith(deserializer).readValue(rowString, Row.class);
        Row expectedRow = Row.withSchema((Schema)schema).addValues(new Object[]{Row.withSchema((Schema)nestedRowSchema).addValues(new Object[]{Row.withSchema((Schema)doubleNestedRowSchema).addValues(new Object[]{"foo"}).build()}).build()}).build();
        Assert.assertEquals((Object)expectedRow, (Object)parsedRow);
    }

    @Test
    public void testThrowsForUnsupportedType() throws Exception {
        Schema schema = Schema.builder().addDateTimeField("f_dateTime").build();
        this.thrown.expect(RowJsonDeserializer.UnsupportedRowJsonException.class);
        this.thrown.expectMessage("DATETIME is not supported");
        RowJsonDeserializer.forSchema((Schema)schema);
    }

    @Test
    public void testThrowsForUnsupportedArrayElementType() throws Exception {
        Schema schema = Schema.builder().addArrayField("f_dateTimeArray", Schema.FieldType.DATETIME).build();
        this.thrown.expect(RowJsonDeserializer.UnsupportedRowJsonException.class);
        this.thrown.expectMessage("DATETIME is not supported");
        RowJsonDeserializer.forSchema((Schema)schema);
    }

    @Test
    public void testThrowsForUnsupportedNestedFieldType() throws Exception {
        Schema nestedSchema = Schema.builder().addArrayField("f_dateTimeArray", Schema.FieldType.DATETIME).build();
        Schema schema = Schema.builder().addRowField("f_nestedRow", nestedSchema).build();
        this.thrown.expect(RowJsonDeserializer.UnsupportedRowJsonException.class);
        this.thrown.expectMessage("DATETIME is not supported");
        RowJsonDeserializer.forSchema((Schema)schema);
    }

    @Test
    public void testParsesNulls() throws Exception {
        Schema schema = Schema.builder().addByteField("f_byte").addNullableField("f_string", Schema.FieldType.STRING).build();
        String rowString = "{\n\"f_byte\" : 12,\n\"f_string\" : null\n}";
        RowJsonDeserializer deserializer = RowJsonDeserializer.forSchema((Schema)schema);
        Row parsedRow = (Row)this.newObjectMapperWith(deserializer).readValue(rowString, Row.class);
        Row expectedRow = Row.withSchema((Schema)schema).addValues(new Object[]{(byte)12, null}).build();
        Assert.assertEquals((Object)expectedRow, (Object)parsedRow);
    }

    @Test
    public void testThrowsForMissingNotNullableField() throws Exception {
        Schema schema = Schema.builder().addByteField("f_byte").addStringField("f_string").build();
        String rowString = "{\n\"f_byte\" : 12\n}";
        RowJsonDeserializer deserializer = RowJsonDeserializer.forSchema((Schema)schema);
        this.thrown.expect(RowJsonDeserializer.UnsupportedRowJsonException.class);
        this.thrown.expectMessage("'f_string' is not present");
        this.newObjectMapperWith(deserializer).readValue(rowString, Row.class);
    }

    @Test
    public void testSupportedBooleanConversions() throws Exception {
        this.testSupportedConversion(Schema.FieldType.BOOLEAN, BOOLEAN_TRUE_STRING, BOOLEAN_TRUE_VALUE);
    }

    @Test
    public void testSupportedStringConversions() throws Exception {
        this.testSupportedConversion(Schema.FieldType.STRING, this.quoted(FLOAT_STRING), FLOAT_STRING);
    }

    @Test
    public void testSupportedByteConversions() throws Exception {
        this.testSupportedConversion(Schema.FieldType.BYTE, BYTE_STRING, BYTE_VALUE);
    }

    @Test
    public void testSupportedShortConversions() throws Exception {
        this.testSupportedConversion(Schema.FieldType.INT16, BYTE_STRING, BYTE_VALUE);
        this.testSupportedConversion(Schema.FieldType.INT16, SHORT_STRING, SHORT_VALUE);
    }

    @Test
    public void testSupportedIntConversions() throws Exception {
        this.testSupportedConversion(Schema.FieldType.INT32, BYTE_STRING, BYTE_VALUE);
        this.testSupportedConversion(Schema.FieldType.INT32, SHORT_STRING, SHORT_VALUE);
        this.testSupportedConversion(Schema.FieldType.INT32, INT_STRING, INT_VALUE);
    }

    @Test
    public void testSupportedLongConversions() throws Exception {
        this.testSupportedConversion(Schema.FieldType.INT64, BYTE_STRING, BYTE_VALUE);
        this.testSupportedConversion(Schema.FieldType.INT64, SHORT_STRING, SHORT_VALUE);
        this.testSupportedConversion(Schema.FieldType.INT64, INT_STRING, INT_VALUE);
        this.testSupportedConversion(Schema.FieldType.INT64, LONG_STRING, LONG_VALUE);
    }

    @Test
    public void testSupportedFloatConversions() throws Exception {
        this.testSupportedConversion(Schema.FieldType.FLOAT, FLOAT_STRING, FLOAT_VALUE);
        this.testSupportedConversion(Schema.FieldType.FLOAT, SHORT_STRING, Float.valueOf(SHORT_VALUE.shortValue()));
    }

    @Test
    public void testSupportedDoubleConversions() throws Exception {
        this.testSupportedConversion(Schema.FieldType.DOUBLE, DOUBLE_STRING, DOUBLE_VALUE);
        this.testSupportedConversion(Schema.FieldType.DOUBLE, FLOAT_STRING, FLOAT_VALUE.floatValue());
        this.testSupportedConversion(Schema.FieldType.DOUBLE, INT_STRING, INT_VALUE);
    }

    private void testSupportedConversion(Schema.FieldType fieldType, String jsonFieldValue, Object expectedRowFieldValue) throws Exception {
        String fieldName = "f_" + fieldType.getTypeName().name().toLowerCase();
        Schema schema = this.schemaWithField(fieldName, fieldType);
        Row expectedRow = Row.withSchema((Schema)schema).addValues(new Object[]{expectedRowFieldValue}).build();
        ObjectMapper jsonParser = this.newObjectMapperWith(RowJsonDeserializer.forSchema((Schema)schema));
        Row parsedRow = (Row)jsonParser.readValue(this.jsonObjectWith(fieldName, jsonFieldValue), Row.class);
        Assert.assertEquals((Object)expectedRow, (Object)parsedRow);
    }

    @Test
    public void testUnsupportedBooleanConversions() throws Exception {
        this.testUnsupportedConversion(Schema.FieldType.BOOLEAN, this.quoted(BOOLEAN_TRUE_STRING));
        this.testUnsupportedConversion(Schema.FieldType.BOOLEAN, BYTE_STRING);
        this.testUnsupportedConversion(Schema.FieldType.BOOLEAN, SHORT_STRING);
        this.testUnsupportedConversion(Schema.FieldType.BOOLEAN, INT_STRING);
        this.testUnsupportedConversion(Schema.FieldType.BOOLEAN, LONG_STRING);
        this.testUnsupportedConversion(Schema.FieldType.BOOLEAN, FLOAT_STRING);
        this.testUnsupportedConversion(Schema.FieldType.BOOLEAN, DOUBLE_STRING);
    }

    @Test
    public void testUnsupportedStringConversions() throws Exception {
        this.testUnsupportedConversion(Schema.FieldType.STRING, BOOLEAN_TRUE_STRING);
        this.testUnsupportedConversion(Schema.FieldType.STRING, BYTE_STRING);
        this.testUnsupportedConversion(Schema.FieldType.STRING, SHORT_STRING);
        this.testUnsupportedConversion(Schema.FieldType.STRING, INT_STRING);
        this.testUnsupportedConversion(Schema.FieldType.STRING, LONG_STRING);
        this.testUnsupportedConversion(Schema.FieldType.STRING, FLOAT_STRING);
        this.testUnsupportedConversion(Schema.FieldType.STRING, DOUBLE_STRING);
    }

    @Test
    public void testUnsupportedByteConversions() throws Exception {
        this.testUnsupportedConversion(Schema.FieldType.BYTE, BOOLEAN_TRUE_STRING);
        this.testUnsupportedConversion(Schema.FieldType.BYTE, this.quoted(BYTE_STRING));
        this.testUnsupportedConversion(Schema.FieldType.BYTE, SHORT_STRING);
        this.testUnsupportedConversion(Schema.FieldType.BYTE, INT_STRING);
        this.testUnsupportedConversion(Schema.FieldType.BYTE, LONG_STRING);
        this.testUnsupportedConversion(Schema.FieldType.BYTE, FLOAT_STRING);
        this.testUnsupportedConversion(Schema.FieldType.BYTE, DOUBLE_STRING);
    }

    @Test
    public void testUnsupportedShortConversions() throws Exception {
        this.testUnsupportedConversion(Schema.FieldType.INT16, BOOLEAN_TRUE_STRING);
        this.testUnsupportedConversion(Schema.FieldType.INT16, this.quoted(SHORT_STRING));
        this.testUnsupportedConversion(Schema.FieldType.INT16, INT_STRING);
        this.testUnsupportedConversion(Schema.FieldType.INT16, LONG_STRING);
        this.testUnsupportedConversion(Schema.FieldType.INT16, FLOAT_STRING);
        this.testUnsupportedConversion(Schema.FieldType.INT16, DOUBLE_STRING);
    }

    @Test
    public void testUnsupportedIntConversions() throws Exception {
        this.testUnsupportedConversion(Schema.FieldType.INT32, this.quoted(INT_STRING));
        this.testUnsupportedConversion(Schema.FieldType.INT32, BOOLEAN_TRUE_STRING);
        this.testUnsupportedConversion(Schema.FieldType.INT32, LONG_STRING);
        this.testUnsupportedConversion(Schema.FieldType.INT32, FLOAT_STRING);
        this.testUnsupportedConversion(Schema.FieldType.INT32, DOUBLE_STRING);
    }

    @Test
    public void testUnsupportedLongConversions() throws Exception {
        this.testUnsupportedConversion(Schema.FieldType.INT64, this.quoted(LONG_STRING));
        this.testUnsupportedConversion(Schema.FieldType.INT64, BOOLEAN_TRUE_STRING);
        this.testUnsupportedConversion(Schema.FieldType.INT64, FLOAT_STRING);
        this.testUnsupportedConversion(Schema.FieldType.INT64, DOUBLE_STRING);
    }

    @Test
    public void testUnsupportedFloatConversions() throws Exception {
        this.testUnsupportedConversion(Schema.FieldType.FLOAT, this.quoted(FLOAT_STRING));
        this.testUnsupportedConversion(Schema.FieldType.FLOAT, BOOLEAN_TRUE_STRING);
        this.testUnsupportedConversion(Schema.FieldType.FLOAT, DOUBLE_STRING);
        this.testUnsupportedConversion(Schema.FieldType.FLOAT, INT_STRING);
    }

    @Test
    public void testUnsupportedDoubleConversions() throws Exception {
        this.testUnsupportedConversion(Schema.FieldType.DOUBLE, this.quoted(DOUBLE_STRING));
        this.testUnsupportedConversion(Schema.FieldType.DOUBLE, BOOLEAN_TRUE_STRING);
        this.testUnsupportedConversion(Schema.FieldType.DOUBLE, LONG_STRING);
    }

    private void testUnsupportedConversion(Schema.FieldType fieldType, String jsonFieldValue) throws Exception {
        String fieldName = "f_" + fieldType.getTypeName().name().toLowerCase();
        ObjectMapper jsonParser = this.newObjectMapperWith(RowJsonDeserializer.forSchema((Schema)this.schemaWithField(fieldName, fieldType)));
        this.thrown.expectMessage(fieldName);
        this.thrown.expectCause(this.unsupportedWithMessage(jsonFieldValue, "out of range"));
        jsonParser.readValue(this.jsonObjectWith(fieldName, jsonFieldValue), Row.class);
    }

    private String quoted(String string) {
        return "\"" + string + "\"";
    }

    private Schema schemaWithField(String fieldName, Schema.FieldType fieldType) {
        return Schema.builder().addField(fieldName, fieldType).build();
    }

    private String jsonObjectWith(String fieldName, String fieldValue) {
        return "{\n\"" + fieldName + "\" : " + fieldValue + "\n}";
    }

    private Matcher<RowJsonDeserializer.UnsupportedRowJsonException> unsupportedWithMessage(String ... message) {
        return Matchers.allOf((Matcher)Matchers.isA(RowJsonDeserializer.UnsupportedRowJsonException.class), (Matcher)Matchers.hasProperty((String)"message", (Matcher)Matchers.stringContainsInOrder(Arrays.asList(message))));
    }

    private ObjectMapper newObjectMapperWith(RowJsonDeserializer deserializer) {
        SimpleModule simpleModule = new SimpleModule("rowSerializationTesModule");
        simpleModule.addDeserializer(Row.class, (JsonDeserializer)deserializer);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)simpleModule);
        return objectMapper;
    }
}

