/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.io.Files;
import org.apache.beam.sdk.io.LocalResources;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.NumberedShardedFile;
import org.apache.beam.sdk.util.Sleeper;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class NumberedShardedFileTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private Sleeper fastClock = millis -> {};
    private final BackOff backOff = NumberedShardedFile.BACK_OFF_FACTORY.backoff();
    private String filePattern;

    @Before
    public void setup() throws IOException {
        this.filePattern = LocalResources.fromFile((File)this.tmpFolder.getRoot(), (boolean)true).resolve("*", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE).toString();
    }

    @Test
    public void testPreconditionFilePathIsNull() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(Matchers.containsString((String)"Expected valid file path, but received"));
        new NumberedShardedFile(null);
    }

    @Test
    public void testPreconditionFilePathIsEmpty() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage(Matchers.containsString((String)"Expected valid file path, but received"));
        new NumberedShardedFile("");
    }

    @Test
    public void testReadMultipleShards() throws Exception {
        String contents1 = "To be or not to be, ";
        String contents2 = "it is not a question.";
        String contents3 = "should not be included";
        File tmpFile1 = this.tmpFolder.newFile("result-000-of-002");
        File tmpFile2 = this.tmpFolder.newFile("result-001-of-002");
        File tmpFile3 = this.tmpFolder.newFile("tmp");
        Files.write(contents1, tmpFile1, StandardCharsets.UTF_8);
        Files.write(contents2, tmpFile2, StandardCharsets.UTF_8);
        Files.write(contents3, tmpFile3, StandardCharsets.UTF_8);
        this.filePattern = LocalResources.fromFile((File)this.tmpFolder.getRoot(), (boolean)true).resolve("result-*", (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE).toString();
        NumberedShardedFile shardedFile = new NumberedShardedFile(this.filePattern);
        MatcherAssert.assertThat((Object)shardedFile.readFilesWithRetries(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{contents1, contents2}));
    }

    @Test
    public void testReadEmpty() throws Exception {
        File emptyFile = this.tmpFolder.newFile("result-000-of-001");
        Files.write("", emptyFile, StandardCharsets.UTF_8);
        NumberedShardedFile shardedFile = new NumberedShardedFile(this.filePattern);
        MatcherAssert.assertThat((Object)shardedFile.readFilesWithRetries(), (Matcher)Matchers.empty());
    }

    @Test
    public void testReadCustomTemplate() throws Exception {
        String contents1 = "To be or not to be, ";
        String contents2 = "it is not a question.";
        File tmpFile1 = this.tmpFolder.newFile("result0-total2");
        File tmpFile2 = this.tmpFolder.newFile("result1-total2");
        Files.write(contents1, tmpFile1, StandardCharsets.UTF_8);
        Files.write(contents2, tmpFile2, StandardCharsets.UTF_8);
        Pattern customizedTemplate = Pattern.compile("(?x) result (?<shardnum>\\d+) - total (?<numshards>\\d+)");
        NumberedShardedFile shardedFile = new NumberedShardedFile(this.filePattern, customizedTemplate);
        MatcherAssert.assertThat((Object)shardedFile.readFilesWithRetries(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{contents1, contents2}));
    }

    @Test
    public void testReadWithRetriesFailsWhenTemplateIncorrect() throws Exception {
        File tmpFile = this.tmpFolder.newFile();
        Files.write("Test for file checksum verifier.", tmpFile, StandardCharsets.UTF_8);
        NumberedShardedFile shardedFile = new NumberedShardedFile(this.filePattern, Pattern.compile("incorrect-template"));
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage(Matchers.containsString((String)"Unable to read file(s) after retrying 4"));
        shardedFile.readFilesWithRetries(this.fastClock, this.backOff);
    }

    @Test
    public void testReadWithRetriesFailsSinceFilesystemError() throws Exception {
        File tmpFile = this.tmpFolder.newFile();
        Files.write("Test for file checksum verifier.", tmpFile, StandardCharsets.UTF_8);
        NumberedShardedFile shardedFile = (NumberedShardedFile)Mockito.spy((Object)new NumberedShardedFile(this.filePattern));
        ((NumberedShardedFile)Mockito.doThrow(IOException.class).when((Object)shardedFile)).readLines(org.mockito.Matchers.anyCollection());
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage(Matchers.containsString((String)"Unable to read file(s) after retrying 4"));
        shardedFile.readFilesWithRetries(this.fastClock, this.backOff);
    }

    @Test
    public void testReadWithRetriesFailsWhenOutputDirEmpty() throws Exception {
        NumberedShardedFile shardedFile = new NumberedShardedFile(this.filePattern);
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage(Matchers.containsString((String)"Unable to read file(s) after retrying 4"));
        shardedFile.readFilesWithRetries(this.fastClock, this.backOff);
    }

    @Test
    public void testReadWithRetriesFailsWhenRedundantFileLoaded() throws Exception {
        this.tmpFolder.newFile("result-000-of-001");
        this.tmpFolder.newFile("tmp-result-000-of-001");
        NumberedShardedFile shardedFile = new NumberedShardedFile(this.filePattern);
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage(Matchers.containsString((String)"Unable to read file(s) after retrying 4"));
        shardedFile.readFilesWithRetries(this.fastClock, this.backOff);
    }
}

