/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import com.google.auto.value.AutoValue;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.AutoValue_NameUtilsTest_SomeTransform;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PDone;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class NameUtilsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testDropsStandardSuffixes() {
        Assert.assertEquals((Object)"Embedded", (Object)NameUtils.approximateSimpleName((String)"EmbeddedDoFn", (boolean)true));
        Assert.assertEquals((Object)"Embedded", (Object)NameUtils.approximateSimpleName((String)"EmbeddedFn", (boolean)true));
        Assert.assertEquals((Object)"Embedded", (Object)NameUtils.approximateSimpleName((String)"EmbeddedDoFn", (boolean)false));
        Assert.assertEquals((Object)"Embedded", (Object)NameUtils.approximateSimpleName((String)"EmbeddedFn", (boolean)false));
    }

    @Test
    public void testDropsStandardSuffixesInAllComponents() {
        Assert.assertEquals((Object)"Embedded", (Object)NameUtils.approximateSimpleName((String)"SomeDoFn$EmbeddedDoFn", (boolean)true));
        Assert.assertEquals((Object)"Embedded", (Object)NameUtils.approximateSimpleName((String)"SomeFn$EmbeddedFn", (boolean)true));
        Assert.assertEquals((Object)"Some.Embedded", (Object)NameUtils.approximateSimpleName((String)"SomeDoFn$EmbeddedDoFn", (boolean)false));
        Assert.assertEquals((Object)"Some.Embedded", (Object)NameUtils.approximateSimpleName((String)"SomeFn$EmbeddedFn", (boolean)false));
    }

    @Test
    public void testDropsOuterClassNamesTrue() {
        Assert.assertEquals((Object)"Bar", (Object)NameUtils.approximateSimpleName((String)"Foo$1$Bar", (boolean)true));
        Assert.assertEquals((Object)"Foo$1", (Object)NameUtils.approximateSimpleName((String)"Foo$1", (boolean)true));
        Assert.assertEquals((Object)"Foo$1$2", (Object)NameUtils.approximateSimpleName((String)"Foo$1$2", (boolean)true));
    }

    @Test
    public void testDropsOuterClassNamesFalse() {
        Assert.assertEquals((Object)"Foo.Bar", (Object)NameUtils.approximateSimpleName((String)"Foo$1$Bar", (boolean)false));
        Assert.assertEquals((Object)"Foo.1", (Object)NameUtils.approximateSimpleName((String)"Foo$1", (boolean)false));
        Assert.assertEquals((Object)"Foo.2", (Object)NameUtils.approximateSimpleName((String)"Foo$1$2", (boolean)false));
    }

    @Test
    public void testSimpleName() {
        Assert.assertEquals((Object)"Embedded", (Object)NameUtils.approximateSimpleName((Object)new EmbeddedDoFn()));
    }

    @Test
    public void testAnonSimpleName() throws Exception {
        Assert.assertEquals((Object)"Anonymous", (Object)NameUtils.approximateSimpleName((Object)new EmbeddedDoFn(){}));
    }

    @Test
    public void testNestedSimpleName() {
        EmbeddedDoFn fn = new EmbeddedDoFn();
        EmbeddedDoFn inner = fn.getEmbedded();
        Assert.assertEquals((Object)"DeeperEmbedded", (Object)NameUtils.approximateSimpleName((Object)inner));
    }

    @Test
    public void testPTransformName() {
        EmbeddedPTransform transform = new EmbeddedPTransform();
        Assert.assertEquals((Object)"NameUtilsTest.EmbeddedPTransform", (Object)NameUtils.approximatePTransformName(((Object)((Object)transform)).getClass()));
        Assert.assertEquals((Object)"NameUtilsTest.EmbeddedPTransform", (Object)NameUtils.approximatePTransformName(((Object)((Object)transform.getBound())).getClass()));
        Assert.assertEquals((Object)"NameUtilsTest.SomeTransform", (Object)NameUtils.approximatePTransformName(AutoValue_NameUtilsTest_SomeTransform.class));
        Assert.assertEquals((Object)"TextIO.Write", (Object)NameUtils.approximatePTransformName(TextIO.Write.class));
    }

    @Test
    public void testPTransformNameWithAnonOuterClass() throws Exception {
        AnonymousClass anonymousClassObj = new AnonymousClass(){

            @Override
            public Object getInnerClassInstance() {
                return new NamedInnerClass();
            }

            class NamedInnerClass
            extends PTransform<PBegin, PDone> {
                NamedInnerClass() {
                }

                public PDone expand(PBegin begin) {
                    throw new IllegalArgumentException("Should never be applied");
                }
            }
        };
        Assert.assertEquals((Object)"NamedInnerClass", (Object)NameUtils.approximateSimpleName((Object)anonymousClassObj.getInnerClassInstance()));
        Assert.assertEquals((Object)"NameUtilsTest.NamedInnerClass", (Object)NameUtils.approximatePTransformName(anonymousClassObj.getInnerClassInstance().getClass()));
    }

    @Test
    public void testApproximateSimpleNameOverride() {
        NameUtils.NameOverride overriddenName = () -> "CUSTOM_NAME";
        Assert.assertEquals((Object)"CUSTOM_NAME", (Object)NameUtils.approximateSimpleName((Object)overriddenName));
    }

    @Test
    public void testApproximateSimpleNameCustomAnonymous() {
        Object overriddenName = new Object(){};
        Assert.assertEquals((Object)"CUSTOM_NAME", (Object)NameUtils.approximateSimpleName((Object)overriddenName, (String)"CUSTOM_NAME"));
    }

    @AutoValue
    static abstract class SomeTransform
    extends PTransform<PBegin, PDone> {
        SomeTransform() {
        }

        public PDone expand(PBegin input) {
            return null;
        }
    }

    private static interface AnonymousClass {
        public Object getInnerClassInstance();
    }

    private static class EmbeddedPTransform
    extends PTransform<PBegin, PDone> {
        private EmbeddedPTransform() {
        }

        public PDone expand(PBegin begin) {
            throw new IllegalArgumentException("Should never be applied");
        }

        private Bound getBound() {
            return new Bound();
        }

        private class Bound
        extends PTransform<PBegin, PDone> {
            private Bound() {
            }

            public PDone expand(PBegin begin) {
                throw new IllegalArgumentException("Should never be applied");
            }
        }
    }

    private class EmbeddedDoFn {
        private EmbeddedDoFn() {
        }

        private EmbeddedDoFn getEmbedded() {
            return new DeeperEmbeddedDoFn();
        }

        private class DeeperEmbeddedDoFn
        extends EmbeddedDoFn {
            private DeeperEmbeddedDoFn() {
            }
        }
    }
}

