/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.FluentIterable;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Sets;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.util.IllegalMutationException;
import org.apache.beam.sdk.util.MutationDetector;
import org.apache.beam.sdk.util.MutationDetectors;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MutationDetectorsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testMutationBasedOnStructuralValue() throws Exception {
        AtomicInteger value = new AtomicInteger();
        MutationDetector detector = MutationDetectors.forValueWithCoder((Object)value, (Coder)new ForSDKMutationDetectionTestCoder());
        value.incrementAndGet();
        detector.verifyUnmodified();
    }

    @Test
    public void testMutationWithEqualEncodings() throws Exception {
        ArrayList<Object> ls = new ArrayList<Object>();
        ls.add(1);
        ls.add("foo");
        class EncodingBadStructuralValueCoder
        extends AtomicCoder<List<Object>> {
            EncodingBadStructuralValueCoder() {
            }

            public void encode(List<Object> value, OutputStream outStream) throws CoderException, IOException {
                outStream.write(new byte[]{1, 2, -3, 45});
            }

            public List<Object> decode(InputStream inStream) throws CoderException, IOException {
                int read = inStream.read(new byte[4]);
                return new ArrayList<Object>();
            }

            public Object structuralValue(List<Object> value) {
                return new Object();
            }
        }
        MutationDetector detector = MutationDetectors.forValueWithCoder(ls, (Coder)new EncodingBadStructuralValueCoder());
        ls.add(new Byte[]{(byte)1, (byte)2, (byte)-3, (byte)45});
        detector.verifyUnmodified();
    }

    @Test
    public void testMutatingList() throws Exception {
        List<Integer> value = Arrays.asList(1, 2, 3, 4);
        MutationDetector detector = MutationDetectors.forValueWithCoder(value, (Coder)ListCoder.of((Coder)VarIntCoder.of()));
        value.set(0, 37);
        this.thrown.expect(IllegalMutationException.class);
        detector.verifyUnmodified();
    }

    @Test
    public void testUnmodifiedLinkedList() throws Exception {
        LinkedList<Integer> value = Lists.newLinkedList(Arrays.asList(1, 2, 3, 4));
        MutationDetector detector = MutationDetectors.forValueWithCoder(value, (Coder)ListCoder.of((Coder)VarIntCoder.of()));
        detector.verifyUnmodified();
    }

    @Test
    public void testImmutableList() throws Exception {
        LinkedList<Integer> value = Lists.newLinkedList(Arrays.asList(1, 2, 3, 4));
        MutationDetector detector = MutationDetectors.forValueWithCoder(value, (Coder)IterableCoder.of((Coder)VarIntCoder.of()));
        detector.verifyUnmodified();
    }

    @Test
    public void testImmutableSet() throws Exception {
        HashSet<Integer> value = Sets.newHashSet(Arrays.asList(1, 2, 3, 4));
        MutationDetector detector = MutationDetectors.forValueWithCoder(value, (Coder)IterableCoder.of((Coder)VarIntCoder.of()));
        detector.verifyUnmodified();
    }

    @Test
    public void testStructuralValue() throws Exception {
        HashSet<Integer> value = Sets.newHashSet(Arrays.asList(1, 2, 3, 4));
        MutationDetector detector = MutationDetectors.forValueWithCoder(value, (Coder)IterableCoder.of((Coder)VarIntCoder.of()));
        detector.verifyUnmodified();
    }

    @Test
    public void testImmutableIterable() throws Exception {
        FluentIterable<Integer> value = FluentIterable.from(Arrays.asList(1, 2, 3, 4)).cycle().limit(50);
        MutationDetector detector = MutationDetectors.forValueWithCoder(value, (Coder)IterableCoder.of((Coder)VarIntCoder.of()));
        detector.verifyUnmodified();
    }

    @Test
    public void testMutatingArray() throws Exception {
        byte[] value = new byte[]{1, 2, 3, 4};
        MutationDetector detector = MutationDetectors.forValueWithCoder((Object)value, (Coder)ByteArrayCoder.of());
        value[0] = 10;
        this.thrown.expect(IllegalMutationException.class);
        detector.verifyUnmodified();
    }

    @Test
    public void testUnmodifiedArray() throws Exception {
        byte[] value = new byte[]{1, 2, 3, 4};
        MutationDetector detector = MutationDetectors.forValueWithCoder((Object)value, (Coder)ByteArrayCoder.of());
        detector.verifyUnmodified();
    }

    @Test
    public void testEquivalentListOfArrays() throws Exception {
        List value = Arrays.asList({1}, {2, 3}, {4});
        MutationDetector detector = MutationDetectors.forValueWithCoder(value, (Coder)ListCoder.of((Coder)ByteArrayCoder.of()));
        value.set(0, new byte[]{1});
        detector.verifyUnmodified();
    }

    private static class ForSDKMutationDetectionTestCoder
    extends AtomicCoder<Object> {
        private final Object uniqueInstance = new Object();

        private ForSDKMutationDetectionTestCoder() {
        }

        public void encode(Object value, OutputStream outStream) throws IOException {
        }

        public Object decode(InputStream inStream) throws IOException {
            return new AtomicInteger();
        }

        public Object structuralValue(Object value) {
            return this.uniqueInstance;
        }
    }
}

