/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.util.MovingFunction;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MovingFunctionTest {
    private static final long SAMPLE_PERIOD = 100L;
    private static final int SAMPLE_UPDATE = 10;
    private static final int SIGNIFICANT_BUCKETS = 2;
    private static final int SIGNIFICANT_SAMPLES = 10;
    private static final Combine.BinaryCombineLongFn SUM = new Combine.BinaryCombineLongFn(){

        public long apply(long left, long right) {
            return left + right;
        }

        public long identity() {
            return 0L;
        }
    };

    private MovingFunction newFunc() {
        return new MovingFunction(100L, 10L, 2, 10, SUM);
    }

    @Test
    public void significantSamples() {
        MovingFunction f = this.newFunc();
        Assert.assertFalse((boolean)f.isSignificant());
        for (int i = 0; i < 9; ++i) {
            f.add(0L, 0L);
            Assert.assertFalse((boolean)f.isSignificant());
        }
        f.add(0L, 0L);
        Assert.assertTrue((boolean)f.isSignificant());
    }

    @Test
    public void significantBuckets() {
        MovingFunction f = this.newFunc();
        Assert.assertFalse((boolean)f.isSignificant());
        f.add(0L, 0L);
        Assert.assertFalse((boolean)f.isSignificant());
        f.add(10L, 0L);
        Assert.assertTrue((boolean)f.isSignificant());
    }

    @Test
    public void sum() {
        MovingFunction f = this.newFunc();
        int i = 0;
        while ((long)i < 100L) {
            f.add((long)i, (long)i);
            Assert.assertEquals((long)((i + 1) * i / 2), (long)f.get((long)i));
            ++i;
        }
    }

    @Test
    public void movingSum() {
        MovingFunction f = this.newFunc();
        int lost = 0;
        int i = 0;
        while ((long)i < 200L) {
            f.add((long)i, 1L);
            if ((long)i >= 100L && i % 10 == 0) {
                lost += 10;
            }
            Assert.assertEquals((long)(i + 1 - lost), (long)f.get((long)i));
            ++i;
        }
    }

    @Test
    public void jumpingSum() {
        MovingFunction f = this.newFunc();
        f.add(0L, 1L);
        f.add(99L, 1L);
        Assert.assertEquals((long)2L, (long)f.get(99L));
        Assert.assertEquals((long)1L, (long)f.get(130L));
        Assert.assertEquals((long)0L, (long)f.get(200L));
    }
}

