/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.sdk.util.MoreFutures;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MoreFuturesTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void supplyAsyncSuccess() throws Exception {
        CompletionStage future = MoreFutures.supplyAsync(() -> 42);
        Assert.assertThat((Object)((Integer)MoreFutures.get((CompletionStage)future)), (Matcher)Matchers.equalTo((Object)42));
    }

    @Test
    public void supplyAsyncFailure() throws Exception {
        String testMessage = "this is just a test";
        CompletionStage future = MoreFutures.supplyAsync(() -> {
            throw new IllegalStateException("this is just a test");
        });
        this.thrown.expect(ExecutionException.class);
        this.thrown.expectCause(Matchers.isA(IllegalStateException.class));
        this.thrown.expectMessage("this is just a test");
        MoreFutures.get((CompletionStage)future);
    }

    @Test
    public void runAsyncSuccess() throws Exception {
        AtomicInteger result = new AtomicInteger(0);
        CompletionStage sideEffectFuture = MoreFutures.runAsync(() -> result.set(42));
        MoreFutures.get((CompletionStage)sideEffectFuture);
        Assert.assertThat((Object)result.get(), (Matcher)Matchers.equalTo((Object)42));
    }

    @Test
    public void runAsyncFailure() throws Exception {
        String testMessage = "this is just a test";
        CompletionStage sideEffectFuture = MoreFutures.runAsync(() -> {
            throw new IllegalStateException("this is just a test");
        });
        this.thrown.expect(ExecutionException.class);
        this.thrown.expectCause(Matchers.isA(IllegalStateException.class));
        this.thrown.expectMessage("this is just a test");
        MoreFutures.get((CompletionStage)sideEffectFuture);
    }
}

