/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.sdk.values.TupleTag;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class InstanceBuilderTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    private static TupleTag createTag(String id) {
        return new TupleTag(id);
    }

    @Test
    public void testFullNameLookup() throws Exception {
        TupleTag tag = (TupleTag)InstanceBuilder.ofType(TupleTag.class).fromClassName(InstanceBuilderTest.class.getName()).fromFactoryMethod("createTag").withArg(String.class, (Object)"hello world!").build();
        Assert.assertEquals((Object)"hello world!", (Object)tag.getId());
    }

    @Test
    public void testConstructor() throws Exception {
        TupleTag tag = (TupleTag)InstanceBuilder.ofType(TupleTag.class).withArg(String.class, (Object)"hello world!").build();
        Assert.assertEquals((Object)"hello world!", (Object)tag.getId());
    }

    @Test
    public void testBadMethod() throws Exception {
        this.expectedEx.expect(RuntimeException.class);
        this.expectedEx.expectMessage(Matchers.containsString((String)"Unable to find factory method"));
        InstanceBuilder.ofType(String.class).fromClassName(InstanceBuilderTest.class.getName()).fromFactoryMethod("nonexistantFactoryMethod").withArg(String.class, (Object)"hello").withArg(String.class, (Object)" world!").build();
    }

    @Test
    public void testBadArgs() throws Exception {
        this.expectedEx.expect(RuntimeException.class);
        this.expectedEx.expectMessage(Matchers.containsString((String)"Unable to find factory method"));
        InstanceBuilder.ofType(TupleTag.class).fromClassName(InstanceBuilderTest.class.getName()).fromFactoryMethod("createTag").withArg(String.class, (Object)"hello").withArg(Integer.class, (Object)42).build();
    }

    @Test
    public void testBadReturnType() throws Exception {
        this.expectedEx.expect(RuntimeException.class);
        this.expectedEx.expectMessage(Matchers.containsString((String)"must be assignable to String"));
        InstanceBuilder.ofType(String.class).fromClassName(InstanceBuilderTest.class.getName()).fromFactoryMethod("createTag").withArg(String.class, (Object)"hello").build();
    }

    @Test
    public void testWrongType() throws Exception {
        this.expectedEx.expect(RuntimeException.class);
        this.expectedEx.expectMessage(Matchers.containsString((String)"must be assignable to TupleTag"));
        InstanceBuilder.ofType(TupleTag.class).fromClassName(InstanceBuilderTest.class.getName()).build();
    }
}

