/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.IOException;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.FluentBackoff;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FluentBackoffTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private final FluentBackoff defaultBackoff = FluentBackoff.DEFAULT;

    @Test
    public void testInvalidExponent() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("exponent -2.0 must be greater than 0");
        this.defaultBackoff.withExponent(-2.0);
    }

    @Test
    public void testInvalidInitialBackoff() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("initialBackoff PT0S must be at least 1 millisecond");
        this.defaultBackoff.withInitialBackoff(Duration.ZERO);
    }

    @Test
    public void testInvalidMaxBackoff() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("maxBackoff PT0S must be at least 1 millisecond");
        this.defaultBackoff.withMaxBackoff(Duration.ZERO);
    }

    @Test
    public void testInvalidMaxRetries() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("maxRetries -1 cannot be negative");
        this.defaultBackoff.withMaxRetries(-1);
    }

    @Test
    public void testInvalidCumulativeBackoff() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("maxCumulativeBackoff PT-0.002S must be at least 1 millisecond");
        this.defaultBackoff.withMaxCumulativeBackoff(Duration.millis((long)-2L));
    }

    @Test
    public void testBoundedIntervalWithReset() throws Exception {
        BackOff backOff = FluentBackoff.DEFAULT.withInitialBackoff(Duration.millis((long)500L)).withMaxBackoff(Duration.standardSeconds((long)1L)).backoff();
        Assert.assertThat((Object)backOff.nextBackOffMillis(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(249L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(751L))));
        Assert.assertThat((Object)backOff.nextBackOffMillis(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(374L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(1126L))));
        Assert.assertThat((Object)backOff.nextBackOffMillis(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(500L)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(1500L))));
        Assert.assertThat((Object)backOff.nextBackOffMillis(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(500L)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(1500L))));
        Assert.assertThat((Object)backOff.nextBackOffMillis(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(500L)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(1500L))));
        Assert.assertThat((Object)backOff.nextBackOffMillis(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(500L)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(1500L))));
        Assert.assertThat((Object)backOff.nextBackOffMillis(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(500L)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(1500L))));
        backOff.reset();
        Assert.assertThat((Object)backOff.nextBackOffMillis(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(249L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(751L))));
        Assert.assertThat((Object)backOff.nextBackOffMillis(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(374L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(1126L))));
        Assert.assertThat((Object)backOff.nextBackOffMillis(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(500L)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(1500L))));
        Assert.assertThat((Object)backOff.nextBackOffMillis(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(500L)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(1500L))));
    }

    @Test
    public void testMaxRetriesWithReset() throws Exception {
        BackOff backOff = FluentBackoff.DEFAULT.withInitialBackoff(Duration.millis((long)500L)).withMaxRetries(1).backoff();
        Assert.assertThat((Object)backOff.nextBackOffMillis(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(249L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(751L))));
        Assert.assertThat((Object)backOff.nextBackOffMillis(), (Matcher)Matchers.equalTo((Object)-1L));
        Assert.assertThat((Object)backOff.nextBackOffMillis(), (Matcher)Matchers.equalTo((Object)-1L));
        Assert.assertThat((Object)backOff.nextBackOffMillis(), (Matcher)Matchers.equalTo((Object)-1L));
        Assert.assertThat((Object)backOff.nextBackOffMillis(), (Matcher)Matchers.equalTo((Object)-1L));
        backOff.reset();
        Assert.assertThat((Object)backOff.nextBackOffMillis(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(249L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(751L))));
        Assert.assertThat((Object)backOff.nextBackOffMillis(), (Matcher)Matchers.equalTo((Object)-1L));
    }

    private static long countMaximumBackoff(BackOff backOff) throws IOException {
        long cumulativeBackoffMillis = 0L;
        long currentBackoffMillis = backOff.nextBackOffMillis();
        while (currentBackoffMillis != -1L) {
            cumulativeBackoffMillis += currentBackoffMillis;
            currentBackoffMillis = backOff.nextBackOffMillis();
        }
        return cumulativeBackoffMillis;
    }

    @Test
    public void testBoundedIntervalAndCumTimeWithReset() throws Exception {
        BackOff backOff = FluentBackoff.DEFAULT.withInitialBackoff(Duration.millis((long)500L)).withMaxBackoff(Duration.standardSeconds((long)1L)).withMaxCumulativeBackoff(Duration.standardMinutes((long)1L)).backoff();
        Assert.assertThat((Object)FluentBackoffTest.countMaximumBackoff(backOff), (Matcher)Matchers.equalTo((Object)Duration.standardMinutes((long)1L).getMillis()));
        backOff.reset();
        Assert.assertThat((Object)FluentBackoffTest.countMaximumBackoff(backOff), (Matcher)Matchers.equalTo((Object)Duration.standardMinutes((long)1L).getMillis()));
        Assert.assertThat((Object)FluentBackoffTest.countMaximumBackoff(backOff), (Matcher)Matchers.equalTo((Object)0L));
        backOff.reset();
        Assert.assertThat((Object)FluentBackoffTest.countMaximumBackoff(backOff), (Matcher)Matchers.equalTo((Object)Duration.standardMinutes((long)1L).getMillis()));
    }

    @Test
    public void testBoundedIntervalAndCumTimeAndRetriesWithReset() throws Exception {
        BackOff backOff = FluentBackoff.DEFAULT.withInitialBackoff(Duration.millis((long)500L)).withMaxBackoff(Duration.standardSeconds((long)1L)).withMaxCumulativeBackoff(Duration.standardMinutes((long)1L)).backoff();
        long cumulativeBackoffMillis = 0L;
        long currentBackoffMillis = backOff.nextBackOffMillis();
        while (currentBackoffMillis != -1L) {
            cumulativeBackoffMillis += currentBackoffMillis;
            currentBackoffMillis = backOff.nextBackOffMillis();
        }
        Assert.assertThat((Object)cumulativeBackoffMillis, (Matcher)Matchers.equalTo((Object)Duration.standardMinutes((long)1L).getMillis()));
    }

    @Test
    public void testFluentBackoffToString() throws IOException {
        FluentBackoff config = FluentBackoff.DEFAULT.withExponent(3.4).withMaxRetries(4).withInitialBackoff(Duration.standardSeconds((long)3L)).withMaxBackoff(Duration.standardHours((long)1L)).withMaxCumulativeBackoff(Duration.standardDays((long)1L));
        Assert.assertEquals((Object)"FluentBackoff{exponent=3.4, initialBackoff=PT3S, maxBackoff=PT3600S, maxRetries=4, maxCumulativeBackoff=PT86400S}", (Object)config.toString());
    }

    @Test
    public void testBackoffImplToString() throws IOException {
        FluentBackoff config = FluentBackoff.DEFAULT.withExponent(3.4).withMaxRetries(4).withInitialBackoff(Duration.standardSeconds((long)3L)).withMaxBackoff(Duration.standardHours((long)1L)).withMaxCumulativeBackoff(Duration.standardDays((long)1L));
        BackOff backOff = config.backoff();
        Assert.assertEquals((Object)("BackoffImpl{backoffConfig=" + config.toString() + ", currentRetry=0, currentCumulativeBackoff=PT0S}"), (Object)backOff.toString());
        backOff.nextBackOffMillis();
        Assert.assertThat((Object)backOff.toString(), (Matcher)Matchers.containsString((String)"currentRetry=1"));
    }
}

