/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Charsets;
import org.apache.beam.sdk.util.ExposedByteArrayOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ExposedByteArrayOutputStreamTest {
    private static final byte[] TEST_DATA = "Hello World!".getBytes(Charsets.UTF_8);
    private ExposedByteArrayOutputStream exposedStream = new ExposedByteArrayOutputStream();
    private ByteArrayOutputStream stream = new ByteArrayOutputStream();

    @Test
    public void testNoWrite() {
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
    }

    @Test
    public void testWriteZeroLengthArray() throws IOException {
        this.writeToBoth(new byte[0]);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
    }

    @Test
    public void testWriteZeroLengthArrayWithOffset() {
        this.writeToBoth(new byte[0], 0, 0);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
    }

    @Test
    public void testWriteSingleByte() {
        this.writeToBoth(32);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
    }

    @Test
    public void testWriteSingleByteTwice() {
        this.writeToBoth(32);
        this.writeToBoth(32);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
    }

    @Test
    public void testWriteSingleArray() throws IOException {
        this.writeToBoth(TEST_DATA);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
        Assert.assertNotSame((Object)TEST_DATA, (Object)this.exposedStream.toByteArray());
    }

    @Test
    public void testWriteSingleArrayFast() throws IOException {
        this.writeToBothFast(TEST_DATA);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
        Assert.assertSame((Object)TEST_DATA, (Object)this.exposedStream.toByteArray());
    }

    @Test
    public void testWriteSingleArrayTwice() throws IOException {
        this.writeToBoth(TEST_DATA);
        this.writeToBoth(TEST_DATA);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
    }

    @Test
    public void testWriteSingleArrayTwiceFast() throws IOException {
        this.writeToBothFast(TEST_DATA);
        this.writeToBothFast(TEST_DATA);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
    }

    @Test
    public void testWriteSingleArrayTwiceFast1() throws IOException {
        this.writeToBothFast(TEST_DATA);
        this.writeToBoth(TEST_DATA);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
    }

    @Test
    public void testWriteSingleArrayTwiceFast2() throws IOException {
        this.writeToBoth(TEST_DATA);
        this.writeToBothFast(TEST_DATA);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
    }

    @Test
    public void testWriteSingleArrayWithLength() {
        this.writeToBoth(TEST_DATA, 0, TEST_DATA.length);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
        Assert.assertNotSame((Object)TEST_DATA, (Object)this.exposedStream.toByteArray());
    }

    @Test
    public void testWritePartial() {
        this.writeToBoth(TEST_DATA, 0, TEST_DATA.length - 1);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
    }

    @Test
    public void testWritePartialWithNonZeroBegin() {
        this.writeToBoth(TEST_DATA, 1, TEST_DATA.length - 1);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
    }

    @Test
    public void testWriteByteAfterWriteArrayFast() throws IOException {
        this.writeToBothFast(TEST_DATA);
        this.writeToBoth(32);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
    }

    @Test
    public void testWriteArrayFastAfterByte() throws IOException {
        this.writeToBoth(32);
        this.writeToBothFast(TEST_DATA);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
    }

    @Test
    public void testResetAfterWriteFast() throws IOException {
        this.writeToBothFast(TEST_DATA);
        this.resetBoth();
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
    }

    @Test
    public void testWriteArrayFastAfterReset() throws IOException {
        this.writeToBothFast(TEST_DATA);
        this.resetBoth();
        this.writeToBothFast(TEST_DATA);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
        Assert.assertSame((Object)TEST_DATA, (Object)this.exposedStream.toByteArray());
    }

    @Test
    public void testWriteArrayFastAfterReset1() throws IOException {
        this.writeToBothFast(TEST_DATA);
        this.writeToBothFast(TEST_DATA);
        this.resetBoth();
        this.writeToBothFast(TEST_DATA);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
        Assert.assertSame((Object)TEST_DATA, (Object)this.exposedStream.toByteArray());
    }

    @Test
    public void testWriteArrayFastAfterReset2() throws IOException {
        this.resetBoth();
        this.writeToBothFast(TEST_DATA);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
        Assert.assertSame((Object)TEST_DATA, (Object)this.exposedStream.toByteArray());
    }

    @Test
    public void testWriteArrayFastTwiceAfterReset() throws IOException {
        this.writeToBothFast(TEST_DATA);
        this.resetBoth();
        this.writeToBothFast(TEST_DATA);
        this.writeToBothFast(TEST_DATA);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
    }

    @Test
    public void testWriteArrayFastTwiceAfterReset1() throws IOException {
        this.writeToBothFast(TEST_DATA);
        this.writeToBothFast(TEST_DATA);
        this.resetBoth();
        this.writeToBothFast(TEST_DATA);
        this.writeToBothFast(TEST_DATA);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
    }

    @Test
    public void testWriteByteAfterReset() {
        this.writeToBoth(32);
        this.resetBoth();
        this.writeToBoth(32);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
    }

    @Test
    public void testWriteByteAfterReset1() {
        this.resetBoth();
        this.writeToBoth(32);
        this.assertStreamContentsEquals(this.stream, (ByteArrayOutputStream)this.exposedStream);
    }

    private void assertStreamContentsEquals(ByteArrayOutputStream stream1, ByteArrayOutputStream stream2) {
        Assert.assertArrayEquals((byte[])stream1.toByteArray(), (byte[])stream2.toByteArray());
        Assert.assertEquals((Object)stream1.toString(), (Object)stream2.toString());
        Assert.assertEquals((long)stream1.size(), (long)stream2.size());
    }

    private void writeToBoth(int b) {
        this.exposedStream.write(b);
        this.stream.write(b);
    }

    private void writeToBoth(byte[] b) throws IOException {
        this.exposedStream.write(b);
        this.stream.write(b);
    }

    private void writeToBothFast(byte[] b) throws IOException {
        this.exposedStream.writeAndOwn(b);
        this.stream.write(b);
    }

    private void writeToBoth(byte[] b, int off, int length) {
        this.exposedStream.write(b, off, length);
        this.stream.write(b, off, length);
    }

    private void resetBoth() {
        this.exposedStream.reset();
        this.stream.reset();
    }
}

