/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.base.Charsets;
import org.apache.beam.sdk.util.ExposedByteArrayInputStream;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ExposedByteArrayInputStreamTest {
    private static final byte[] TEST_DATA = "Hello World!".getBytes(Charsets.UTF_8);
    private ByteArrayInputStream stream = new ByteArrayInputStream(TEST_DATA);
    private ExposedByteArrayInputStream exposedStream = new ExposedByteArrayInputStream(TEST_DATA);

    @Test
    public void testConstructWithEmptyArray() throws IOException {
        try (ExposedByteArrayInputStream s = new ExposedByteArrayInputStream(new byte[0]);){
            Assert.assertEquals((long)0L, (long)s.available());
            byte[] data = s.readAll();
            Assert.assertEquals((long)0L, (long)data.length);
        }
    }

    @Test
    public void testReadAll() throws IOException {
        Assert.assertEquals((long)TEST_DATA.length, (long)this.exposedStream.available());
        byte[] data = this.exposedStream.readAll();
        Assert.assertArrayEquals((byte[])TEST_DATA, (byte[])data);
        Assert.assertSame((Object)TEST_DATA, (Object)data);
        Assert.assertEquals((long)0L, (long)this.exposedStream.available());
    }

    @Test
    public void testReadPartial() throws IOException {
        Assert.assertEquals((long)TEST_DATA.length, (long)this.exposedStream.available());
        Assert.assertEquals((long)TEST_DATA.length, (long)this.stream.available());
        byte[] data1 = new byte[4];
        byte[] data2 = new byte[4];
        int ret1 = this.exposedStream.read(data1);
        int ret2 = this.stream.read(data2);
        Assert.assertEquals((long)ret2, (long)ret1);
        Assert.assertArrayEquals((byte[])data2, (byte[])data1);
        Assert.assertEquals((long)this.stream.available(), (long)this.exposedStream.available());
    }

    @Test
    public void testReadAllAfterReadPartial() throws IOException {
        Assert.assertNotEquals((long)-1L, (long)this.exposedStream.read());
        byte[] ret = this.exposedStream.readAll();
        Assert.assertArrayEquals((byte[])"ello World!".getBytes(Charsets.UTF_8), (byte[])ret);
    }
}

