/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.state.StateContext;
import org.apache.beam.sdk.state.StateContexts;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.Sum;
import org.apache.beam.sdk.util.CombineContextFactory;
import org.apache.beam.sdk.util.CombineFnUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.MockSettings;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class CombineFnUtilTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    CombineWithContext.CombineFnWithContext<Integer, Integer, Integer> mockCombineFn;

    @Before
    public void setUp() {
        this.mockCombineFn = (CombineWithContext.CombineFnWithContext)Mockito.mock(CombineWithContext.CombineFnWithContext.class, (MockSettings)Mockito.withSettings().serializable());
    }

    @Test
    public void testNonSerializable() throws Exception {
        this.expectedException.expect(NotSerializableException.class);
        this.expectedException.expectMessage("Cannot serialize the CombineFn resulting from CombineFnUtil.bindContext.");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(buffer);
        oos.writeObject(CombineFnUtil.bindContext(this.mockCombineFn, (StateContext)StateContexts.nullContext()));
    }

    @Test
    public void testToFnWithContextIdempotent() throws Exception {
        CombineWithContext.CombineFnWithContext fnWithContext = CombineFnUtil.toFnWithContext((CombineFnBase.GlobalCombineFn)Sum.ofIntegers());
        Assert.assertTrue((fnWithContext == CombineFnUtil.toFnWithContext((CombineFnBase.GlobalCombineFn)fnWithContext) ? 1 : 0) != 0);
    }

    @Test
    public void testToFnWithContext() throws Exception {
        CombineWithContext.CombineFnWithContext fnWithContext = CombineFnUtil.toFnWithContext((CombineFnBase.GlobalCombineFn)Sum.ofIntegers());
        ImmutableList<Integer> inputs = ImmutableList.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4));
        CombineWithContext.Context nullContext = CombineContextFactory.nullContext();
        int[] accum = (int[])fnWithContext.createAccumulator(nullContext);
        for (Integer i : inputs) {
            accum = (int[])fnWithContext.addInput((Object)accum, (Object)i, nullContext);
        }
        Assert.assertEquals((long)10L, (long)((Integer)fnWithContext.extractOutput((Object)accum, nullContext)).intValue());
    }
}

