/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.testing.CoderPropertiesTest;
import org.apache.beam.sdk.util.CoderUtils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class CoderUtilsTest {
    @Rule
    public transient ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testCoderExceptionPropagation() throws Exception {
        Coder crashingCoder = (Coder)Mockito.mock(Coder.class);
        ((Coder)Mockito.doThrow((Throwable)new CoderException("testing exception")).when((Object)crashingCoder)).encode((Object)Matchers.anyString(), (OutputStream)Matchers.any(OutputStream.class), (Coder.Context)Matchers.any(Coder.Context.class));
        this.expectedException.expect(CoderException.class);
        this.expectedException.expectMessage("testing exception");
        CoderUtils.encodeToByteArray((Coder)crashingCoder, (Object)"hello");
    }

    @Test
    public void testClosingCoderFailsWhenDecodingBase64() throws Exception {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Caller does not own the underlying");
        CoderUtils.decodeFromBase64((Coder)new CoderPropertiesTest.ClosingCoder(), (String)"test-value");
    }

    @Test
    public void testClosingCoderFailsWhenDecodingByteArray() throws Exception {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Caller does not own the underlying");
        CoderUtils.decodeFromByteArray((Coder)new CoderPropertiesTest.ClosingCoder(), (byte[])new byte[0]);
    }

    @Test
    public void testClosingCoderFailsWhenDecodingByteArrayInContext() throws Exception {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Caller does not own the underlying");
        CoderUtils.decodeFromByteArray((Coder)new CoderPropertiesTest.ClosingCoder(), (byte[])new byte[0], (Coder.Context)Coder.Context.NESTED);
    }

    @Test
    public void testClosingCoderFailsWhenEncodingToBase64() throws Exception {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Caller does not own the underlying");
        CoderUtils.encodeToBase64((Coder)new CoderPropertiesTest.ClosingCoder(), (Object)"test-value");
    }

    @Test
    public void testClosingCoderFailsWhenEncodingToByteArray() throws Exception {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Caller does not own the underlying");
        CoderUtils.encodeToByteArray((Coder)new CoderPropertiesTest.ClosingCoder(), (Object)"test-value");
    }

    @Test
    public void testClosingCoderFailsWhenEncodingToByteArrayInContext() throws Exception {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Caller does not own the underlying");
        CoderUtils.encodeToByteArray((Coder)new CoderPropertiesTest.ClosingCoder(), (Object)"test-value", (Coder.Context)Coder.Context.NESTED);
    }

    static class TestCoder
    extends AtomicCoder<Integer> {
        TestCoder() {
        }

        public static TestCoder of() {
            return new TestCoder();
        }

        public void encode(Integer value, OutputStream outStream) {
            throw new RuntimeException("not expecting to be called");
        }

        public Integer decode(InputStream inStream) {
            throw new RuntimeException("not expecting to be called");
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
            throw new Coder.NonDeterministicException((Coder)this, "TestCoder does not actually encode or decode.");
        }
    }
}

