/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.util.BucketingFunction;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BucketingFunctionTest {
    private static final int BUCKET_WIDTH = 10;
    private static final int SIGNIFICANT_BUCKETS = 2;
    private static final int SIGNIFICANT_SAMPLES = 10;
    private static final Combine.BinaryCombineLongFn SUM = new Combine.BinaryCombineLongFn(){

        public long apply(long left, long right) {
            return left + right;
        }

        public long identity() {
            return 0L;
        }
    };

    private BucketingFunction newFunc() {
        return new BucketingFunction(10L, 2, 10, SUM);
    }

    @Test
    public void significantSamples() {
        BucketingFunction f = this.newFunc();
        Assert.assertFalse((boolean)f.isSignificant());
        for (int i = 0; i < 9; ++i) {
            f.add(0L, 0L);
            Assert.assertFalse((boolean)f.isSignificant());
        }
        f.add(0L, 0L);
        Assert.assertTrue((boolean)f.isSignificant());
    }

    @Test
    public void significantBuckets() {
        BucketingFunction f = this.newFunc();
        Assert.assertFalse((boolean)f.isSignificant());
        f.add(0L, 0L);
        Assert.assertFalse((boolean)f.isSignificant());
        f.add(10L, 0L);
        Assert.assertTrue((boolean)f.isSignificant());
    }

    @Test
    public void sum() {
        BucketingFunction f = this.newFunc();
        for (int i = 0; i < 100; ++i) {
            f.add((long)i, (long)i);
            Assert.assertEquals((long)((i + 1) * i / 2), (long)f.get());
        }
    }

    @Test
    public void movingSum() {
        BucketingFunction f = this.newFunc();
        int lost = 0;
        for (int i = 0; i < 200; ++i) {
            f.add((long)i, 1L);
            if (i >= 100) {
                f.remove((long)(i - 100));
                if (i % 10 == 9) {
                    lost += 10;
                }
            }
            Assert.assertEquals((long)(i + 1 - lost), (long)f.get());
        }
    }
}

