/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.FluentIterable;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableSet;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Iterables;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Sets;
import org.apache.beam.sdk.util.ApiSurface;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ApiSurfaceTest {
    private void assertExposed(Class classToExamine, Class ... exposedClasses) {
        ApiSurface apiSurface = ApiSurface.ofClass((Class)classToExamine).pruningPrefix("java");
        ImmutableSet allowed = FluentIterable.from(Iterables.concat(Sets.newHashSet(classToExamine), Sets.newHashSet(exposedClasses))).transform(Matchers::equalTo).toSet();
        Assert.assertThat((Object)apiSurface, (Matcher)ApiSurface.containsOnlyClassesMatching(allowed));
    }

    @Test
    public void testExposedReturnType() throws Exception {
        this.assertExposed(ExposedReturnType.class, Exposed.class);
    }

    @Test
    public void testExposedParameterTypeVarBound() throws Exception {
        this.assertExposed(ExposedParameterTypeVarBound.class, Exposed.class);
    }

    @Test
    public void testExposedWildcardBound() throws Exception {
        this.assertExposed(ExposedWildcardBound.class, Exposed.class);
    }

    @Test
    public void testExposedActualTypeArgument() throws Exception {
        this.assertExposed(ExposedActualTypeArgument.class, Exposed.class);
    }

    @Test
    public void testIgnoreAll() throws Exception {
        ApiSurface apiSurface = ApiSurface.ofClass(ExposedWildcardBound.class).includingClass(Object.class).includingClass(ApiSurface.class).pruningPattern(".*");
        Assert.assertThat((Object)apiSurface.getExposedClasses(), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void testprunedPattern() throws Exception {
        ApiSurface apiSurface = ApiSurface.ofClass(NotPruned.class).pruningClass(PrunedPattern.class);
        Assert.assertThat((Object)apiSurface.getExposedClasses(), (Matcher)Matchers.containsInAnyOrder((Object[])new Class[]{NotPruned.class}));
    }

    @Test
    public void testExposedTwice() throws Exception {
        this.assertExposed(ExposedTwice.class, Exposed.class);
    }

    @Test
    public void testExposedCycle() throws Exception {
        this.assertExposed(ExposedCycle.class, Exposed.class);
    }

    @Test
    public void testExposedGenericCycle() throws Exception {
        this.assertExposed(ExposedGenericCycle.class, Exposed.class);
    }

    @Test
    public void testExposedArrayCycle() throws Exception {
        this.assertExposed(ExposedArrayCycle.class, Exposed.class);
    }

    private static interface ExposedArrayCycle {
        public Exposed zero(ExposedArrayCycle[] var1);
    }

    private static interface ExposedGenericCycle {
        public Exposed zero(List<ExposedGenericCycle> var1);
    }

    private static interface ExposedCycle {
        public ExposedCycle zero(Exposed var1);
    }

    private static interface ExposedTwice {
        public Exposed zero();

        public Exposed one();
    }

    private static interface NotPruned
    extends PrunedPattern {
    }

    private static interface PrunedPattern {
    }

    private static interface ExposedActualTypeArgument
    extends List<Exposed> {
    }

    private static interface ExposedWildcardBound {
        public void acceptList(List<? extends Exposed> var1);
    }

    private static interface ExposedParameterTypeVarBound {
        public <T extends Exposed> void getList(T var1);
    }

    private static interface ExposedReturnType {
        public Exposed zero();
    }

    private static interface Exposed {
    }
}

