/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Iterables;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.UsesCustomWindowMerging;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataEvaluator;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Never;
import org.apache.beam.sdk.transforms.windowing.NonMergingWindowFn;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class WindowTest
implements Serializable {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create().enableAbandonedNodeEnforcement(false);
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    @Test
    public void testWindowIntoSetWindowfn() {
        WindowingStrategy strategy = ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"hello", (Object[])new String[]{"world"}).withCoder((Coder)StringUtf8Coder.of()))).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)10L))))).getWindowingStrategy();
        Assert.assertTrue((boolean)(strategy.getWindowFn() instanceof FixedWindows));
        Assert.assertTrue((boolean)(strategy.getTrigger() instanceof DefaultTrigger));
        Assert.assertEquals((Object)WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES, (Object)strategy.getMode());
    }

    @Test
    public void testWindowIntoTriggersAndAccumulating() {
        FixedWindows fixed10 = FixedWindows.of((Duration)Duration.standardMinutes((long)10L));
        Repeatedly trigger = Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)5));
        WindowingStrategy strategy = ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"hello", (Object[])new String[]{"world"}).withCoder((Coder)StringUtf8Coder.of()))).apply((PTransform)Window.into((WindowFn)fixed10).triggering((Trigger)trigger).accumulatingFiredPanes().withAllowedLateness(Duration.ZERO))).getWindowingStrategy();
        Assert.assertEquals((Object)fixed10, (Object)strategy.getWindowFn());
        Assert.assertEquals((Object)trigger, (Object)strategy.getTrigger());
        Assert.assertEquals((Object)WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES, (Object)strategy.getMode());
    }

    @Test
    public void testWindowIntoAccumulatingLatenessNoTrigger() {
        FixedWindows fixed = FixedWindows.of((Duration)Duration.standardMinutes((long)10L));
        WindowingStrategy strategy = ((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"hello", (Object[])new String[]{"world"}).withCoder((Coder)StringUtf8Coder.of()))).apply("Lateness", (PTransform)Window.into((WindowFn)fixed).withAllowedLateness(Duration.standardDays((long)1L)).accumulatingFiredPanes())).getWindowingStrategy();
        Assert.assertThat((Object)strategy.isTriggerSpecified(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)strategy.isModeSpecified(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)strategy.isAllowedLatenessSpecified(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)strategy.getMode(), (Matcher)Matchers.equalTo((Object)WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES));
        Assert.assertThat((Object)strategy.getAllowedLateness(), (Matcher)Matchers.equalTo((Object)Duration.standardDays((long)1L)));
    }

    @Test
    public void testWindowPropagatesEachPart() {
        FixedWindows fixed10 = FixedWindows.of((Duration)Duration.standardMinutes((long)10L));
        Repeatedly trigger = Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)5));
        WindowingStrategy strategy = ((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"hello", (Object[])new String[]{"world"}).withCoder((Coder)StringUtf8Coder.of()))).apply("Mode", (PTransform)Window.configure().accumulatingFiredPanes())).apply("Lateness", (PTransform)Window.configure().withAllowedLateness(Duration.standardDays((long)1L)))).apply("Trigger", (PTransform)Window.configure().triggering((Trigger)trigger))).apply("Window", (PTransform)Window.into((WindowFn)fixed10))).getWindowingStrategy();
        Assert.assertEquals((Object)fixed10, (Object)strategy.getWindowFn());
        Assert.assertEquals((Object)trigger, (Object)strategy.getTrigger());
        Assert.assertEquals((Object)WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES, (Object)strategy.getMode());
        Assert.assertEquals((Object)Duration.standardDays((long)1L), (Object)strategy.getAllowedLateness());
    }

    @Test
    public void testWindowIntoPropagatesLateness() {
        FixedWindows fixed10 = FixedWindows.of((Duration)Duration.standardMinutes((long)10L));
        FixedWindows fixed25 = FixedWindows.of((Duration)Duration.standardMinutes((long)25L));
        WindowingStrategy strategy = ((PCollection)((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"hello", (Object[])new String[]{"world"}).withCoder((Coder)StringUtf8Coder.of()))).apply("WindowInto10", (PTransform)Window.into((WindowFn)fixed10).withAllowedLateness(Duration.standardDays((long)1L)).triggering((Trigger)Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)5))).accumulatingFiredPanes())).apply("WindowInto25", (PTransform)Window.into((WindowFn)fixed25))).getWindowingStrategy();
        Assert.assertEquals((Object)Duration.standardDays((long)1L), (Object)strategy.getAllowedLateness());
        Assert.assertEquals((Object)fixed25, (Object)strategy.getWindowFn());
    }

    @Test
    public void testWindowIntoAssignesLongerAllowedLateness() {
        FixedWindows fixed10 = FixedWindows.of((Duration)Duration.standardMinutes((long)10L));
        FixedWindows fixed25 = FixedWindows.of((Duration)Duration.standardMinutes((long)25L));
        PCollection notChanged = (PCollection)((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"hello", (Object[])new String[]{"world"}).withCoder((Coder)StringUtf8Coder.of()))).apply("WindowInto25", (PTransform)Window.into((WindowFn)fixed25).withAllowedLateness(Duration.standardDays((long)1L)).triggering((Trigger)Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)5))).accumulatingFiredPanes())).apply("WindowInto10", (PTransform)Window.into((WindowFn)fixed10).withAllowedLateness(Duration.standardDays((long)2L)));
        Assert.assertEquals((Object)Duration.standardDays((long)2L), (Object)notChanged.getWindowingStrategy().getAllowedLateness());
        PCollection data = (PCollection)this.pipeline.apply("createChanged", (PTransform)Create.of((Object)"hello", (Object[])new String[]{"world"}).withCoder((Coder)StringUtf8Coder.of()));
        PCollection longWindow = (PCollection)data.apply("WindowInto25c", (PTransform)Window.into((WindowFn)fixed25).withAllowedLateness(Duration.standardDays((long)1L)).triggering((Trigger)Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)5))).accumulatingFiredPanes());
        Assert.assertEquals((Object)Duration.standardDays((long)1L), (Object)longWindow.getWindowingStrategy().getAllowedLateness());
        PCollection autoCorrectedWindow = (PCollection)longWindow.apply("WindowInto10c", (PTransform)Window.into((WindowFn)fixed10).withAllowedLateness(Duration.standardHours((long)1L)));
        Assert.assertEquals((Object)Duration.standardDays((long)1L), (Object)autoCorrectedWindow.getWindowingStrategy().getAllowedLateness());
    }

    @Test
    public void testWindowIntoWindowFnAssign() {
        ((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)11L).plus((ReadableDuration)Duration.millis((long)1L)))));
        final AtomicBoolean foundAssign = new AtomicBoolean(false);
        this.pipeline.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){

            public void visitPrimitiveTransform(TransformHierarchy.Node node) {
                if (node.getTransform() instanceof Window.Assign) {
                    foundAssign.set(true);
                }
            }
        });
        Assert.assertThat((Object)foundAssign.get(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testWindowIntoNullWindowFnNoAssign() {
        ((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3}))).apply((PTransform)Window.configure().triggering((Trigger)AfterWatermark.pastEndOfWindow()).withAllowedLateness(Duration.ZERO).accumulatingFiredPanes());
        this.pipeline.traverseTopologically((Pipeline.PipelineVisitor)new Pipeline.PipelineVisitor.Defaults(){

            public void visitPrimitiveTransform(TransformHierarchy.Node node) {
                Assert.assertThat((Object)node.getTransform(), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(Window.Assign.class)));
            }
        });
    }

    @Test
    public void testWindowGetName() {
        Assert.assertEquals((Object)"Window.Into()", (Object)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)10L))).getName());
    }

    @Test
    public void testNonDeterministicWindowCoder() throws Coder.NonDeterministicException {
        FixedWindows mockWindowFn = (FixedWindows)Mockito.mock(FixedWindows.class);
        Class<Coder> coderClazz = Coder.class;
        Coder mockCoder = (Coder)Mockito.mock(coderClazz);
        Mockito.when((Object)mockWindowFn.windowCoder()).thenReturn((Object)mockCoder);
        Coder.NonDeterministicException toBeThrown = new Coder.NonDeterministicException(mockCoder, "Its just not deterministic.");
        ((Coder)Mockito.doThrow((Throwable)toBeThrown).when((Object)mockCoder)).verifyDeterministic();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectCause(Matchers.sameInstance((Object)((Object)toBeThrown)));
        this.thrown.expectMessage("Window coders must be deterministic");
        Window.into((WindowFn)mockWindowFn);
    }

    @Test
    public void testMissingMode() {
        FixedWindows fixed10 = FixedWindows.of((Duration)Duration.standardMinutes((long)10L));
        Repeatedly trigger = Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)5));
        PCollection input = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"hello", (Object[])new String[]{"world"}).withCoder((Coder)StringUtf8Coder.of()))).apply("Window", (PTransform)Window.into((WindowFn)fixed10));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("requires that the accumulation mode");
        input.apply("Triggering", (PTransform)Window.configure().withAllowedLateness(Duration.standardDays((long)1L)).triggering((Trigger)trigger));
    }

    @Test
    public void testMissingModeViaLateness() {
        FixedWindows fixed = FixedWindows.of((Duration)Duration.standardMinutes((long)10L));
        PCollection input = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"hello", (Object[])new String[]{"world"}).withCoder((Coder)StringUtf8Coder.of()))).apply("Window", (PTransform)Window.into((WindowFn)fixed));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("allowed lateness");
        this.thrown.expectMessage("accumulation mode be specified");
        input.apply("Lateness", (PTransform)Window.configure().withAllowedLateness(Duration.standardDays((long)1L)));
    }

    @Test
    public void testMissingLateness() {
        FixedWindows fixed10 = FixedWindows.of((Duration)Duration.standardMinutes((long)10L));
        Repeatedly trigger = Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)5));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("requires that the allowed lateness");
        ((PCollection)((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"hello", (Object[])new String[]{"world"}).withCoder((Coder)StringUtf8Coder.of()))).apply("Mode", (PTransform)Window.configure().accumulatingFiredPanes())).apply("Window", (PTransform)Window.into((WindowFn)fixed10))).apply("Trigger", (PTransform)Window.configure().triggering((Trigger)trigger));
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testNoWindowFnDoesNotReassignWindows() {
        this.pipeline.enableAbandonedNodeEnforcement(true);
        PCollection initialWindows = (PCollection)((PCollection)this.pipeline.apply((PTransform)GenerateSequence.from((long)0L).to(10L))).apply("AssignWindows", (PTransform)Window.into((WindowFn)new WindowOddEvenBuckets()));
        PAssert.that((PCollection)initialWindows).inWindow((BoundedWindow)WindowOddEvenBuckets.EVEN_WINDOW).containsInAnyOrder((Object[])new Long[]{0L, 2L, 4L, 6L, 8L});
        PAssert.that((PCollection)initialWindows).inWindow((BoundedWindow)WindowOddEvenBuckets.ODD_WINDOW).containsInAnyOrder((Object[])new Long[]{1L, 3L, 5L, 7L, 9L});
        PCollection upOne = (PCollection)initialWindows.apply("ModifyTypes", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<Long, Boolean>(){

            public Boolean apply(Long input) {
                return input % 2L == 0L;
            }
        }));
        PAssert.that((PCollection)upOne).inWindow((BoundedWindow)WindowOddEvenBuckets.EVEN_WINDOW).containsInAnyOrder((Object[])new Boolean[]{true, true, true, true, true});
        PAssert.that((PCollection)upOne).inWindow((BoundedWindow)WindowOddEvenBuckets.ODD_WINDOW).containsInAnyOrder((Object[])new Boolean[]{false, false, false, false, false});
        upOne.apply("UpdateWindowingStrategy", (PTransform)Window.configure().triggering((Trigger)Never.ever()).withAllowedLateness(Duration.ZERO).accumulatingFiredPanes());
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testTimestampCombinerDefault() {
        this.pipeline.enableAbandonedNodeEnforcement(true);
        ((PCollection)((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)KV.of((Object)0, (Object)"hello"), (Instant)new Instant(0L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)KV.of((Object)0, (Object)"goodbye"), (Instant)new Instant(10L))}))).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)10L))))).apply((PTransform)GroupByKey.create())).apply((PTransform)ParDo.of((DoFn)new DoFn<KV<Integer, Iterable<String>>, Void>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                Assert.assertThat((Object)c.timestamp(), (Matcher)Matchers.equalTo((Object)new IntervalWindow(new Instant(0L), new Instant(0L).plus((ReadableDuration)Duration.standardMinutes((long)10L))).maxTimestamp()));
            }
        }));
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testTimestampCombinerEndOfWindow() {
        this.pipeline.enableAbandonedNodeEnforcement(true);
        ((PCollection)((PCollection)((PCollection)this.pipeline.apply((PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)KV.of((Object)0, (Object)"hello"), (Instant)new Instant(0L)), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)KV.of((Object)0, (Object)"goodbye"), (Instant)new Instant(10L))}))).apply((PTransform)Window.into((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)10L))).withTimestampCombiner(TimestampCombiner.END_OF_WINDOW))).apply((PTransform)GroupByKey.create())).apply((PTransform)ParDo.of((DoFn)new DoFn<KV<Integer, Iterable<String>>, Void>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                Assert.assertThat((Object)c.timestamp(), (Matcher)Matchers.equalTo((Object)new Instant(599999L)));
            }
        }));
        this.pipeline.run();
    }

    @Test
    public void testDisplayData() {
        FixedWindows windowFn = FixedWindows.of((Duration)Duration.standardHours((long)5L));
        AfterWatermark.FromEndOfWindow triggerBuilder = AfterWatermark.pastEndOfWindow();
        Duration allowedLateness = Duration.standardMinutes((long)10L);
        Window.ClosingBehavior closingBehavior = Window.ClosingBehavior.FIRE_IF_NON_EMPTY;
        TimestampCombiner timestampCombiner = TimestampCombiner.END_OF_WINDOW;
        Window window = Window.into((WindowFn)windowFn).triggering((Trigger)triggerBuilder).accumulatingFiredPanes().withAllowedLateness(allowedLateness, closingBehavior).withTimestampCombiner(timestampCombiner);
        DisplayData displayData = DisplayData.from((HasDisplayData)window);
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("windowFn", windowFn.getClass()));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.includesDisplayDataFor("windowFn", (HasDisplayData)windowFn));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("trigger", triggerBuilder.toString()));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("accumulationMode", WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES.toString()));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("allowedLateness", allowedLateness));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("closingBehavior", closingBehavior.toString()));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("timestampCombiner", timestampCombiner.toString()));
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testPrimitiveDisplayData() {
        FixedWindows windowFn = FixedWindows.of((Duration)Duration.standardHours((long)5L));
        AfterWatermark.FromEndOfWindow triggerBuilder = AfterWatermark.pastEndOfWindow();
        Duration allowedLateness = Duration.standardMinutes((long)10L);
        Window.ClosingBehavior closingBehavior = Window.ClosingBehavior.FIRE_IF_NON_EMPTY;
        TimestampCombiner timestampCombiner = TimestampCombiner.END_OF_WINDOW;
        Window window = Window.into((WindowFn)windowFn).triggering((Trigger)triggerBuilder).accumulatingFiredPanes().withAllowedLateness(allowedLateness, closingBehavior).withTimestampCombiner(timestampCombiner);
        DisplayData primitiveDisplayData = Iterables.getOnlyElement(DisplayDataEvaluator.create().displayDataForPrimitiveTransforms(window));
        Assert.assertThat((Object)primitiveDisplayData, DisplayDataMatchers.hasDisplayItem("windowFn", windowFn.getClass()));
        Assert.assertThat((Object)primitiveDisplayData, DisplayDataMatchers.includesDisplayDataFor("windowFn", (HasDisplayData)windowFn));
        Assert.assertThat((Object)primitiveDisplayData, DisplayDataMatchers.hasDisplayItem("trigger", triggerBuilder.toString()));
        Assert.assertThat((Object)primitiveDisplayData, DisplayDataMatchers.hasDisplayItem("accumulationMode", WindowingStrategy.AccumulationMode.ACCUMULATING_FIRED_PANES.toString()));
        Assert.assertThat((Object)primitiveDisplayData, DisplayDataMatchers.hasDisplayItem("allowedLateness", allowedLateness));
        Assert.assertThat((Object)primitiveDisplayData, DisplayDataMatchers.hasDisplayItem("closingBehavior", closingBehavior.toString()));
        Assert.assertThat((Object)primitiveDisplayData, DisplayDataMatchers.hasDisplayItem("timestampCombiner", timestampCombiner.toString()));
    }

    @Test
    public void testAssignDisplayDataUnchanged() {
        FixedWindows windowFn = FixedWindows.of((Duration)Duration.standardHours((long)5L));
        Window original = Window.into((WindowFn)windowFn);
        WindowingStrategy updated = WindowingStrategy.globalDefault().withWindowFn((WindowFn)windowFn);
        DisplayData displayData = DisplayData.from((HasDisplayData)new Window.Assign(original, updated));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("windowFn", windowFn.getClass()));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.includesDisplayDataFor("windowFn", (HasDisplayData)windowFn));
        Assert.assertThat((Object)displayData, (Matcher)Matchers.not(DisplayDataMatchers.hasDisplayItem("trigger")));
        Assert.assertThat((Object)displayData, (Matcher)Matchers.not(DisplayDataMatchers.hasDisplayItem("accumulationMode")));
        Assert.assertThat((Object)displayData, (Matcher)Matchers.not(DisplayDataMatchers.hasDisplayItem("allowedLateness")));
        Assert.assertThat((Object)displayData, (Matcher)Matchers.not(DisplayDataMatchers.hasDisplayItem("closingBehavior")));
        Assert.assertThat((Object)displayData, (Matcher)Matchers.not(DisplayDataMatchers.hasDisplayItem("timestampCombiner")));
    }

    @Test
    public void testDisplayDataExcludesUnspecifiedProperties() {
        Window onlyHasAccumulationMode = Window.configure().discardingFiredPanes();
        Assert.assertThat((Object)DisplayData.from((HasDisplayData)onlyHasAccumulationMode), (Matcher)Matchers.not(DisplayDataMatchers.hasDisplayItem(DisplayDataMatchers.hasKey((Matcher<String>)Matchers.isOneOf((Object[])new String[]{"windowFn", "trigger", "timestampCombiner", "allowedLateness", "closingBehavior"})))));
        Window noAccumulationMode = Window.into((WindowFn)new GlobalWindows());
        Assert.assertThat((Object)DisplayData.from((HasDisplayData)noAccumulationMode), (Matcher)Matchers.not(DisplayDataMatchers.hasDisplayItem(DisplayDataMatchers.hasKey("accumulationMode"))));
    }

    @Test
    public void testDisplayDataExcludesDefaults() {
        Window window = Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)DefaultTrigger.of()).withAllowedLateness(Duration.millis((long)BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis()));
        DisplayData data = DisplayData.from((HasDisplayData)window);
        Assert.assertThat((Object)data, (Matcher)Matchers.not(DisplayDataMatchers.hasDisplayItem("trigger")));
        Assert.assertThat((Object)data, (Matcher)Matchers.not(DisplayDataMatchers.hasDisplayItem("allowedLateness")));
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesCustomWindowMerging.class})
    public void testMergingCustomWindows() {
        Instant startInstant = new Instant(0L);
        PCollection inputCollection = (PCollection)this.pipeline.apply((PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)"big", (Instant)startInstant.plus((ReadableDuration)Duration.standardSeconds((long)10L))), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)"small1", (Instant)startInstant.plus((ReadableDuration)Duration.standardSeconds((long)20L))), TimestampedValue.of((Object)"small2", (Instant)startInstant.plus((ReadableDuration)Duration.standardSeconds((long)39L)))}));
        PCollection windowedCollection = (PCollection)inputCollection.apply((PTransform)Window.into(new CustomWindowFn()));
        PCollection count = (PCollection)windowedCollection.apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)Count.combineFn()).withoutDefaults());
        PAssert.that((String)"Wrong number of elements in output collection", (PCollection)count).containsInAnyOrder((Object[])new Long[]{2L, 1L});
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class, UsesCustomWindowMerging.class})
    public void testMergingCustomWindowsKeyedCollection() {
        Instant startInstant = new Instant(0L);
        PCollection inputCollection = (PCollection)this.pipeline.apply((PTransform)Create.timestamped((TimestampedValue)TimestampedValue.of((Object)KV.of((Object)0, (Object)"big"), (Instant)startInstant.plus((ReadableDuration)Duration.standardSeconds((long)10L))), (TimestampedValue[])new TimestampedValue[]{TimestampedValue.of((Object)KV.of((Object)1, (Object)"small1"), (Instant)startInstant.plus((ReadableDuration)Duration.standardSeconds((long)20L))), TimestampedValue.of((Object)KV.of((Object)2, (Object)"small2"), (Instant)startInstant.plus((ReadableDuration)Duration.standardSeconds((long)39L)))}));
        PCollection windowedCollection = (PCollection)inputCollection.apply((PTransform)Window.into(new CustomWindowFn()));
        PCollection count = (PCollection)windowedCollection.apply((PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)Count.combineFn()).withoutDefaults());
        PAssert.that((String)"Wrong number of elements in output collection", (PCollection)count).containsInAnyOrder((Object[])new Long[]{2L, 1L});
        this.pipeline.run();
    }

    private static class CustomWindowFn<T>
    extends WindowFn<T, CustomWindow> {
        private CustomWindowFn() {
        }

        public Collection<CustomWindow> assignWindows(WindowFn.AssignContext c) throws Exception {
            String element = c.element() instanceof KV ? (String)((KV)c.element()).getValue() : (String)c.element();
            if ("big".equals(element)) {
                return Collections.singletonList(new CustomWindow(c.timestamp(), c.timestamp().plus((ReadableDuration)Duration.standardSeconds((long)30L)), true));
            }
            return Collections.singletonList(new CustomWindow(c.timestamp(), c.timestamp().plus((ReadableDuration)Duration.standardSeconds((long)5L)), false));
        }

        public void mergeWindows(WindowFn.MergeContext c) throws Exception {
            HashMap windowsToMerge = new HashMap();
            for (CustomWindow customWindow : c.windows()) {
                if (!customWindow.isBig) continue;
                HashSet<CustomWindow> windows = new HashSet<CustomWindow>();
                windows.add(customWindow);
                windowsToMerge.put(customWindow, windows);
            }
            for (CustomWindow customWindow : c.windows()) {
                for (Map.Entry bigWindow : windowsToMerge.entrySet()) {
                    if (!((CustomWindow)((Object)bigWindow.getKey())).contains(customWindow)) continue;
                    ((Set)bigWindow.getValue()).add(customWindow);
                }
            }
            for (Map.Entry entry : windowsToMerge.entrySet()) {
                c.merge((Collection)entry.getValue(), (BoundedWindow)((CustomWindow)((Object)entry.getKey())));
            }
        }

        public boolean isCompatible(WindowFn<?, ?> other) {
            return other instanceof CustomWindowFn;
        }

        public Coder<CustomWindow> windowCoder() {
            return CustomWindowCoder.of();
        }

        public WindowMappingFn<CustomWindow> getDefaultWindowMappingFn() {
            throw new UnsupportedOperationException("side inputs not supported");
        }
    }

    private static class CustomWindowCoder
    extends CustomCoder<CustomWindow> {
        private static final CustomWindowCoder INSTANCE = new CustomWindowCoder();
        private static final Coder<IntervalWindow> INTERVAL_WINDOW_CODER = IntervalWindow.getCoder();
        private static final VarIntCoder VAR_INT_CODER = VarIntCoder.of();

        private CustomWindowCoder() {
        }

        public static CustomWindowCoder of() {
            return INSTANCE;
        }

        public void encode(CustomWindow window, OutputStream outStream) throws IOException {
            INTERVAL_WINDOW_CODER.encode((Object)window, outStream);
            VAR_INT_CODER.encode(Integer.valueOf(window.isBig ? 1 : 0), outStream);
        }

        public CustomWindow decode(InputStream inStream) throws IOException {
            IntervalWindow superWindow = (IntervalWindow)INTERVAL_WINDOW_CODER.decode(inStream);
            boolean isBig = VAR_INT_CODER.decode(inStream) != 0;
            return new CustomWindow(superWindow.start(), superWindow.end(), isBig);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
            INTERVAL_WINDOW_CODER.verifyDeterministic();
            VAR_INT_CODER.verifyDeterministic();
        }
    }

    private static class CustomWindow
    extends IntervalWindow {
        private boolean isBig;

        CustomWindow(Instant start, Instant end, boolean isBig) {
            super(start, end);
            this.isBig = isBig;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            CustomWindow that = (CustomWindow)((Object)o);
            return super.equals(o) && this.isBig == that.isBig;
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.isBig);
        }
    }

    private static class WindowOddEvenBuckets
    extends NonMergingWindowFn<Long, IntervalWindow> {
        private static final IntervalWindow EVEN_WINDOW = new IntervalWindow(BoundedWindow.TIMESTAMP_MIN_VALUE, GlobalWindow.INSTANCE.maxTimestamp());
        private static final IntervalWindow ODD_WINDOW = new IntervalWindow(BoundedWindow.TIMESTAMP_MIN_VALUE, GlobalWindow.INSTANCE.maxTimestamp().minus(1L));

        private WindowOddEvenBuckets() {
        }

        public Collection<IntervalWindow> assignWindows(WindowFn.AssignContext c) throws Exception {
            if ((Long)c.element() % 2L == 0L) {
                return Collections.singleton(EVEN_WINDOW);
            }
            return Collections.singleton(ODD_WINDOW);
        }

        public boolean isCompatible(WindowFn<?, ?> other) {
            return other instanceof WindowOddEvenBuckets;
        }

        public void verifyCompatibility(WindowFn<?, ?> other) throws IncompatibleWindowException {
            if (!this.isCompatible(other)) {
                throw new IncompatibleWindowException(other, "WindowOddEvenBuckets is only compatible with WindowOddEvenBuckets.");
            }
        }

        public Coder<IntervalWindow> windowCoder() {
            return new IntervalWindow.IntervalWindowCoder();
        }

        public WindowMappingFn<IntervalWindow> getDefaultWindowMappingFn() {
            throw new UnsupportedOperationException(String.format("Can't use %s for side inputs", ((Object)((Object)this)).getClass().getSimpleName()));
        }
    }
}

