/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.beam.sdk.testing.WindowFnTestUtils;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SlidingWindowsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testSimple() throws Exception {
        HashMap<IntervalWindow, Set> expected = new HashMap<IntervalWindow, Set>();
        expected.put(new IntervalWindow(new Instant(-5L), new Instant(5L)), WindowFnTestUtils.set((long[])new long[]{1L, 2L}));
        expected.put(new IntervalWindow(new Instant(0L), new Instant(10L)), WindowFnTestUtils.set((long[])new long[]{1L, 2L, 5L, 9L}));
        expected.put(new IntervalWindow(new Instant(5L), new Instant(15L)), WindowFnTestUtils.set((long[])new long[]{5L, 9L, 10L, 11L}));
        expected.put(new IntervalWindow(new Instant(10L), new Instant(20L)), WindowFnTestUtils.set((long[])new long[]{10L, 11L}));
        SlidingWindows windowFn = SlidingWindows.of((Duration)new Duration(10L)).every(new Duration(5L));
        Assert.assertEquals(expected, (Object)WindowFnTestUtils.runWindowFn((WindowFn)windowFn, Arrays.asList(1L, 2L, 5L, 9L, 10L, 11L)));
        Assert.assertThat((Object)windowFn.assignsToOneWindow(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testSlightlyOverlapping() throws Exception {
        HashMap<IntervalWindow, Set> expected = new HashMap<IntervalWindow, Set>();
        expected.put(new IntervalWindow(new Instant(-5L), new Instant(2L)), WindowFnTestUtils.set((long[])new long[]{1L}));
        expected.put(new IntervalWindow(new Instant(0L), new Instant(7L)), WindowFnTestUtils.set((long[])new long[]{1L, 2L, 5L}));
        expected.put(new IntervalWindow(new Instant(5L), new Instant(12L)), WindowFnTestUtils.set((long[])new long[]{5L, 9L, 10L, 11L}));
        expected.put(new IntervalWindow(new Instant(10L), new Instant(17L)), WindowFnTestUtils.set((long[])new long[]{10L, 11L}));
        SlidingWindows windowFn = SlidingWindows.of((Duration)new Duration(7L)).every(new Duration(5L));
        Assert.assertEquals(expected, (Object)WindowFnTestUtils.runWindowFn((WindowFn)windowFn, Arrays.asList(1L, 2L, 5L, 9L, 10L, 11L)));
        Assert.assertThat((Object)windowFn.assignsToOneWindow(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testEqualSize() throws Exception {
        HashMap<IntervalWindow, Set> expected = new HashMap<IntervalWindow, Set>();
        expected.put(new IntervalWindow(new Instant(0L), new Instant(3L)), WindowFnTestUtils.set((long[])new long[]{1L, 2L}));
        expected.put(new IntervalWindow(new Instant(3L), new Instant(6L)), WindowFnTestUtils.set((long[])new long[]{3L, 4L, 5L}));
        expected.put(new IntervalWindow(new Instant(6L), new Instant(9L)), WindowFnTestUtils.set((long[])new long[]{6L, 7L}));
        SlidingWindows windowFn = SlidingWindows.of((Duration)new Duration(3L)).every(new Duration(3L));
        Assert.assertEquals(expected, (Object)WindowFnTestUtils.runWindowFn((WindowFn)windowFn, Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L)));
        Assert.assertThat((Object)windowFn.assignsToOneWindow(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testElidings() throws Exception {
        HashMap<IntervalWindow, Set> expected = new HashMap<IntervalWindow, Set>();
        expected.put(new IntervalWindow(new Instant(0L), new Instant(3L)), WindowFnTestUtils.set((long[])new long[]{1L, 2L}));
        expected.put(new IntervalWindow(new Instant(10L), new Instant(13L)), WindowFnTestUtils.set((long[])new long[]{10L, 11L}));
        expected.put(new IntervalWindow(new Instant(100L), new Instant(103L)), WindowFnTestUtils.set((long[])new long[]{100L}));
        SlidingWindows windowFn = SlidingWindows.of((Duration)new Duration(3L)).every(new Duration(10L));
        Assert.assertEquals(expected, (Object)WindowFnTestUtils.runWindowFn((WindowFn)windowFn, Arrays.asList(1L, 2L, 3L, 5L, 9L, 10L, 11L, 100L)));
        Assert.assertThat((Object)windowFn.assignsToOneWindow(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testOffset() throws Exception {
        HashMap<IntervalWindow, Set> expected = new HashMap<IntervalWindow, Set>();
        expected.put(new IntervalWindow(new Instant(-8L), new Instant(2L)), WindowFnTestUtils.set((long[])new long[]{1L}));
        expected.put(new IntervalWindow(new Instant(-3L), new Instant(7L)), WindowFnTestUtils.set((long[])new long[]{1L, 2L, 5L}));
        expected.put(new IntervalWindow(new Instant(2L), new Instant(12L)), WindowFnTestUtils.set((long[])new long[]{2L, 5L, 9L, 10L, 11L}));
        expected.put(new IntervalWindow(new Instant(7L), new Instant(17L)), WindowFnTestUtils.set((long[])new long[]{9L, 10L, 11L}));
        Assert.assertEquals(expected, (Object)WindowFnTestUtils.runWindowFn((WindowFn)SlidingWindows.of((Duration)new Duration(10L)).every(new Duration(5L)).withOffset(new Duration(2L)), Arrays.asList(1L, 2L, 5L, 9L, 10L, 11L)));
    }

    @Test
    public void testTimeUnit() throws Exception {
        HashMap<IntervalWindow, Set> expected = new HashMap<IntervalWindow, Set>();
        expected.put(new IntervalWindow(new Instant(-5000L), new Instant(5000L)), WindowFnTestUtils.set((long[])new long[]{1L, 2L, 1000L}));
        expected.put(new IntervalWindow(new Instant(0L), new Instant(10000L)), WindowFnTestUtils.set((long[])new long[]{1L, 2L, 1000L, 5000L, 5001L}));
        expected.put(new IntervalWindow(new Instant(5000L), new Instant(15000L)), WindowFnTestUtils.set((long[])new long[]{5000L, 5001L, 10000L}));
        expected.put(new IntervalWindow(new Instant(10000L), new Instant(20000L)), WindowFnTestUtils.set((long[])new long[]{10000L}));
        Assert.assertEquals(expected, (Object)WindowFnTestUtils.runWindowFn((WindowFn)SlidingWindows.of((Duration)Duration.standardSeconds((long)10L)).every(Duration.standardSeconds((long)5L)), Arrays.asList(1L, 2L, 1000L, 5000L, 5001L, 10000L)));
    }

    @Test
    public void testDefaultPeriods() throws Exception {
        Assert.assertEquals((Object)Duration.standardHours((long)1L), (Object)SlidingWindows.getDefaultPeriod((Duration)Duration.standardDays((long)1L)));
        Assert.assertEquals((Object)Duration.standardHours((long)1L), (Object)SlidingWindows.getDefaultPeriod((Duration)Duration.standardHours((long)2L)));
        Assert.assertEquals((Object)Duration.standardMinutes((long)1L), (Object)SlidingWindows.getDefaultPeriod((Duration)Duration.standardHours((long)1L)));
        Assert.assertEquals((Object)Duration.standardMinutes((long)1L), (Object)SlidingWindows.getDefaultPeriod((Duration)Duration.standardMinutes((long)10L)));
        Assert.assertEquals((Object)Duration.standardSeconds((long)1L), (Object)SlidingWindows.getDefaultPeriod((Duration)Duration.standardMinutes((long)1L)));
        Assert.assertEquals((Object)Duration.standardSeconds((long)1L), (Object)SlidingWindows.getDefaultPeriod((Duration)Duration.standardSeconds((long)10L)));
        Assert.assertEquals((Object)Duration.millis((long)1L), (Object)SlidingWindows.getDefaultPeriod((Duration)Duration.standardSeconds((long)1L)));
        Assert.assertEquals((Object)Duration.millis((long)1L), (Object)SlidingWindows.getDefaultPeriod((Duration)Duration.millis((long)10L)));
        Assert.assertEquals((Object)Duration.millis((long)1L), (Object)SlidingWindows.getDefaultPeriod((Duration)Duration.millis((long)1L)));
    }

    @Test
    public void testEquality() {
        Assert.assertTrue((boolean)SlidingWindows.of((Duration)new Duration(10L)).isCompatible((WindowFn)SlidingWindows.of((Duration)new Duration(10L))));
        Assert.assertTrue((boolean)SlidingWindows.of((Duration)new Duration(10L)).isCompatible((WindowFn)SlidingWindows.of((Duration)new Duration(10L))));
        Assert.assertFalse((boolean)SlidingWindows.of((Duration)new Duration(10L)).isCompatible((WindowFn)SlidingWindows.of((Duration)new Duration(20L))));
        Assert.assertFalse((boolean)SlidingWindows.of((Duration)new Duration(10L)).isCompatible((WindowFn)SlidingWindows.of((Duration)new Duration(20L))));
    }

    @Test
    public void testVerifyCompatibility() throws IncompatibleWindowException {
        SlidingWindows.of((Duration)new Duration(10L)).verifyCompatibility((WindowFn)SlidingWindows.of((Duration)new Duration(10L)));
        this.thrown.expect(IncompatibleWindowException.class);
        SlidingWindows.of((Duration)new Duration(10L)).verifyCompatibility((WindowFn)SlidingWindows.of((Duration)new Duration(20L)));
    }

    @Test
    public void testDefaultWindowMappingFn() {
        SlidingWindows slidingWindows = SlidingWindows.of((Duration)new Duration(1000L)).every(new Duration(300L)).withOffset(new Duration(40L));
        WindowMappingFn mapping = slidingWindows.getDefaultWindowMappingFn();
        Assert.assertThat((Object)mapping.maximumLookback(), (Matcher)Matchers.equalTo((Object)Duration.ZERO));
        Assert.assertEquals((Object)new IntervalWindow(new Instant(340L), new Instant(1340L)), (Object)mapping.getSideInputWindow((BoundedWindow)new IntervalWindow(new Instant(0L), new Instant(1041L))));
        Assert.assertEquals((Object)new IntervalWindow(new Instant(340L), new Instant(1340L)), (Object)mapping.getSideInputWindow((BoundedWindow)new IntervalWindow(new Instant(0L), new Instant(1339L))));
        Assert.assertEquals((Object)new IntervalWindow(new Instant(340L), new Instant(1340L)), (Object)mapping.getSideInputWindow((BoundedWindow)new IntervalWindow(new Instant(0L), new Instant(1340L))));
        Assert.assertEquals((Object)new IntervalWindow(new Instant(640L), new Instant(1640L)), (Object)mapping.getSideInputWindow((BoundedWindow)new IntervalWindow(new Instant(0L), new Instant(1341L))));
    }

    @Test
    public void testValidOutputTimes() throws Exception {
        Iterator<Integer> iterator = Arrays.asList(200, 800, 499, 500, 501, 700, 1000).iterator();
        while (iterator.hasNext()) {
            long timestamp = iterator.next().intValue();
            WindowFnTestUtils.validateGetOutputTimestamp((WindowFn)SlidingWindows.of((Duration)new Duration(1000L)).every(new Duration(500L)), (long)timestamp);
        }
    }

    @Test
    public void testOutputTimesNonInterference() throws Exception {
        Iterator<Integer> iterator = Arrays.asList(200, 800, 700).iterator();
        while (iterator.hasNext()) {
            long timestamp = iterator.next().intValue();
            WindowFnTestUtils.validateNonInterferingOutputTimes((WindowFn)SlidingWindows.of((Duration)new Duration(1000L)).every(new Duration(500L)), (long)timestamp);
        }
    }

    @Test
    public void testDisplayData() {
        Duration windowSize = Duration.standardSeconds((long)1234L);
        Duration offset = Duration.standardSeconds((long)2345L);
        Duration period = Duration.standardSeconds((long)3456L);
        SlidingWindows slidingWindowFn = SlidingWindows.of((Duration)windowSize).every(period).withOffset(offset);
        DisplayData displayData = DisplayData.from((HasDisplayData)slidingWindowFn);
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("size", windowSize));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("period", period));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("offset", offset));
    }
}

