/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.testing.WindowFnTestUtils;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SessionsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testSimple() throws Exception {
        HashMap<IntervalWindow, Set> expected = new HashMap<IntervalWindow, Set>();
        expected.put(new IntervalWindow(new Instant(0L), new Instant(10L)), WindowFnTestUtils.set((long[])new long[]{0L}));
        expected.put(new IntervalWindow(new Instant(10L), new Instant(20L)), WindowFnTestUtils.set((long[])new long[]{10L}));
        expected.put(new IntervalWindow(new Instant(101L), new Instant(111L)), WindowFnTestUtils.set((long[])new long[]{101L}));
        Assert.assertEquals(expected, (Object)WindowFnTestUtils.runWindowFn((WindowFn)Sessions.withGapDuration((Duration)new Duration(10L)), Arrays.asList(0L, 10L, 101L)));
    }

    @Test
    public void testConsecutive() throws Exception {
        HashMap<IntervalWindow, Set> expected = new HashMap<IntervalWindow, Set>();
        expected.put(new IntervalWindow(new Instant(1L), new Instant(19L)), WindowFnTestUtils.set((long[])new long[]{1L, 2L, 5L, 9L}));
        expected.put(new IntervalWindow(new Instant(100L), new Instant(111L)), WindowFnTestUtils.set((long[])new long[]{100L, 101L}));
        Assert.assertEquals(expected, (Object)WindowFnTestUtils.runWindowFn((WindowFn)Sessions.withGapDuration((Duration)new Duration(10L)), Arrays.asList(1L, 2L, 5L, 9L, 100L, 101L)));
    }

    @Test
    public void testMerging() throws Exception {
        HashMap<IntervalWindow, Set> expected = new HashMap<IntervalWindow, Set>();
        expected.put(new IntervalWindow(new Instant(1L), new Instant(40L)), WindowFnTestUtils.set((long[])new long[]{1L, 10L, 15L, 22L, 30L}));
        expected.put(new IntervalWindow(new Instant(95L), new Instant(111L)), WindowFnTestUtils.set((long[])new long[]{95L, 100L, 101L}));
        Assert.assertEquals(expected, (Object)WindowFnTestUtils.runWindowFn((WindowFn)Sessions.withGapDuration((Duration)new Duration(10L)), Arrays.asList(1L, 15L, 30L, 100L, 101L, 95L, 22L, 10L)));
    }

    @Test
    public void testTimeUnit() throws Exception {
        HashMap<IntervalWindow, Set> expected = new HashMap<IntervalWindow, Set>();
        expected.put(new IntervalWindow(new Instant(1L), new Instant(2000L)), WindowFnTestUtils.set((long[])new long[]{1L, 2L, 1000L}));
        expected.put(new IntervalWindow(new Instant(5000L), new Instant(6001L)), WindowFnTestUtils.set((long[])new long[]{5000L, 5001L}));
        expected.put(new IntervalWindow(new Instant(10000L), new Instant(11000L)), WindowFnTestUtils.set((long[])new long[]{10000L}));
        Assert.assertEquals(expected, (Object)WindowFnTestUtils.runWindowFn((WindowFn)Sessions.withGapDuration((Duration)Duration.standardSeconds((long)1L)), Arrays.asList(1L, 2L, 1000L, 5000L, 5001L, 10000L)));
    }

    @Test
    public void testEquality() {
        Assert.assertTrue((boolean)Sessions.withGapDuration((Duration)new Duration(10L)).isCompatible((WindowFn)Sessions.withGapDuration((Duration)new Duration(10L))));
        Assert.assertTrue((boolean)Sessions.withGapDuration((Duration)new Duration(10L)).isCompatible((WindowFn)Sessions.withGapDuration((Duration)new Duration(20L))));
    }

    @Test
    public void testVerifyCompatibility() throws IncompatibleWindowException {
        Sessions.withGapDuration((Duration)new Duration(10L)).verifyCompatibility((WindowFn)Sessions.withGapDuration((Duration)new Duration(10L)));
        this.thrown.expect(IncompatibleWindowException.class);
        Sessions.withGapDuration((Duration)new Duration(10L)).verifyCompatibility((WindowFn)FixedWindows.of((Duration)new Duration(10L)));
    }

    @Test
    public void testValidOutputTimes() throws Exception {
        Iterator<Integer> iterator = Arrays.asList(200, 800, 700).iterator();
        while (iterator.hasNext()) {
            long timestamp = iterator.next().intValue();
            WindowFnTestUtils.validateGetOutputTimestamp((WindowFn)Sessions.withGapDuration((Duration)Duration.millis((long)500L)), (long)timestamp);
        }
    }

    @Test
    public void testInvalidOutputAtEarliest() throws Exception {
        try {
            WindowFnTestUtils.validateGetOutputTimestamps((WindowFn)Sessions.withGapDuration((Duration)Duration.millis((long)10L)), (TimestampCombiner)TimestampCombiner.EARLIEST, ImmutableList.of(ImmutableList.of(Long.valueOf(1L), Long.valueOf(3L)), ImmutableList.of(Long.valueOf(0L), Long.valueOf(5L), Long.valueOf(10L), Long.valueOf(15L), Long.valueOf(20L))));
        }
        catch (AssertionError exc) {
            Assert.assertThat((Object)((Throwable)((Object)exc)).getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"a value greater than"), (Matcher)Matchers.containsString((String)"was less than")));
        }
    }

    @Test
    public void testValidOutputAtEndTimes() throws Exception {
        WindowFnTestUtils.validateGetOutputTimestamps((WindowFn)Sessions.withGapDuration((Duration)Duration.millis((long)10L)), (TimestampCombiner)TimestampCombiner.END_OF_WINDOW, ImmutableList.of(ImmutableList.of(Long.valueOf(1L), Long.valueOf(3L)), ImmutableList.of(Long.valueOf(0L), Long.valueOf(5L), Long.valueOf(10L), Long.valueOf(15L), Long.valueOf(20L))));
    }

    @Test
    public void testDisplayData() {
        Duration gapDuration = Duration.standardMinutes((long)234L);
        Sessions session = Sessions.withGapDuration((Duration)gapDuration);
        Assert.assertThat((Object)DisplayData.from((HasDisplayData)session), DisplayDataMatchers.hasDisplayItem("gapDuration", gapDuration));
    }
}

