/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import org.apache.beam.sdk.transforms.windowing.AfterProcessingTime;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.StubTrigger;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class RepeatedlyTest {
    @Mock
    private Trigger mockTrigger;

    public void setUp(WindowFn<Object, IntervalWindow> windowFn) throws Exception {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testFireDeadline() throws Exception {
        this.setUp((WindowFn<Object, IntervalWindow>)FixedWindows.of((Duration)Duration.millis((long)10L)));
        IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(10L));
        Instant arbitraryInstant = new Instant(34957849L);
        Mockito.when((Object)this.mockTrigger.getWatermarkThatGuaranteesFiring((BoundedWindow)Mockito.any())).thenReturn((Object)arbitraryInstant);
        Assert.assertThat((Object)Repeatedly.forever((Trigger)this.mockTrigger).getWatermarkThatGuaranteesFiring((BoundedWindow)window), (Matcher)Matchers.equalTo((Object)arbitraryInstant));
    }

    @Test
    public void testContinuation() throws Exception {
        AfterProcessingTime trigger = AfterProcessingTime.pastFirstElementInPane();
        Repeatedly repeatedly = Repeatedly.forever((Trigger)trigger);
        Assert.assertEquals((Object)Repeatedly.forever((Trigger)trigger.getContinuationTrigger()), (Object)repeatedly.getContinuationTrigger());
        Assert.assertEquals((Object)Repeatedly.forever((Trigger)trigger.getContinuationTrigger().getContinuationTrigger()), (Object)repeatedly.getContinuationTrigger().getContinuationTrigger());
    }

    @Test
    public void testToString() {
        Repeatedly trigger = Repeatedly.forever((Trigger)new StubTrigger(){

            public String toString() {
                return "innerTrigger";
            }
        });
        Assert.assertEquals((Object)"Repeatedly.forever(innerTrigger)", (Object)trigger.toString());
    }
}

