/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PaneInfoTest {
    @Test
    public void testInterned() throws Exception {
        Assert.assertSame((Object)PaneInfo.createPane((boolean)true, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.EARLY), (Object)PaneInfo.createPane((boolean)true, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.EARLY));
    }

    @Test
    public void testEncodingRoundTrip() throws Exception {
        PaneInfo.PaneInfoCoder coder = PaneInfo.PaneInfoCoder.INSTANCE;
        for (PaneInfo.Timing timing : PaneInfo.Timing.values()) {
            long onTimeIndex = timing == PaneInfo.Timing.EARLY ? -1L : 37L;
            CoderProperties.coderDecodeEncodeEqual((Coder)coder, (Object)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)timing, (long)389L, (long)onTimeIndex));
            CoderProperties.coderDecodeEncodeEqual((Coder)coder, (Object)PaneInfo.createPane((boolean)false, (boolean)true, (PaneInfo.Timing)timing, (long)5077L, (long)onTimeIndex));
            CoderProperties.coderDecodeEncodeEqual((Coder)coder, (Object)PaneInfo.createPane((boolean)true, (boolean)false, (PaneInfo.Timing)timing, (long)0L, (long)0L));
            CoderProperties.coderDecodeEncodeEqual((Coder)coder, (Object)PaneInfo.createPane((boolean)true, (boolean)true, (PaneInfo.Timing)timing, (long)0L, (long)0L));
        }
    }

    @Test
    public void testEncodings() {
        Assert.assertEquals((String)"PaneInfo encoding assumes that there are only 4 Timing values.", (long)4L, (long)PaneInfo.Timing.values().length);
        Assert.assertEquals((String)"PaneInfo encoding should remain the same.", (long)0L, (long)PaneInfo.createPane((boolean)false, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.EARLY, (long)1L, (long)-1L).getEncodedByte());
        Assert.assertEquals((String)"PaneInfo encoding should remain the same.", (long)1L, (long)PaneInfo.createPane((boolean)true, (boolean)false, (PaneInfo.Timing)PaneInfo.Timing.EARLY).getEncodedByte());
        Assert.assertEquals((String)"PaneInfo encoding should remain the same.", (long)3L, (long)PaneInfo.createPane((boolean)true, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.EARLY).getEncodedByte());
        Assert.assertEquals((String)"PaneInfo encoding should remain the same.", (long)7L, (long)PaneInfo.createPane((boolean)true, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.ON_TIME).getEncodedByte());
        Assert.assertEquals((String)"PaneInfo encoding should remain the same.", (long)11L, (long)PaneInfo.createPane((boolean)true, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.LATE).getEncodedByte());
        Assert.assertEquals((String)"PaneInfo encoding should remain the same.", (long)15L, (long)PaneInfo.createPane((boolean)true, (boolean)true, (PaneInfo.Timing)PaneInfo.Timing.UNKNOWN).getEncodedByte());
    }
}

