/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.AfterProcessingTime;
import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.OrFinallyTrigger;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.StubTrigger;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class OrFinallyTriggerTest {
    @Test
    public void testFireDeadline() throws Exception {
        IntervalWindow window = new IntervalWindow(new Instant(0L), new Instant(10L));
        Assert.assertEquals((Object)new Instant(9L), (Object)Repeatedly.forever((Trigger)AfterWatermark.pastEndOfWindow()).getWatermarkThatGuaranteesFiring((BoundedWindow)window));
        Assert.assertEquals((Object)new Instant(9L), (Object)Repeatedly.forever((Trigger)AfterWatermark.pastEndOfWindow()).orFinally((Trigger.OnceTrigger)AfterPane.elementCountAtLeast((int)1)).getWatermarkThatGuaranteesFiring((BoundedWindow)window));
        Assert.assertEquals((Object)new Instant(9L), (Object)Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)1)).orFinally((Trigger.OnceTrigger)AfterWatermark.pastEndOfWindow()).getWatermarkThatGuaranteesFiring((BoundedWindow)window));
        Assert.assertEquals((Object)new Instant(9L), (Object)AfterPane.elementCountAtLeast((int)100).orFinally((Trigger.OnceTrigger)AfterWatermark.pastEndOfWindow()).getWatermarkThatGuaranteesFiring((BoundedWindow)window));
        Assert.assertEquals((Object)BoundedWindow.TIMESTAMP_MAX_VALUE, (Object)Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)1)).orFinally((Trigger.OnceTrigger)AfterPane.elementCountAtLeast((int)10)).getWatermarkThatGuaranteesFiring((BoundedWindow)window));
    }

    @Test
    public void testContinuation() throws Exception {
        AfterProcessingTime triggerA = AfterProcessingTime.pastFirstElementInPane();
        AfterWatermark.FromEndOfWindow triggerB = AfterWatermark.pastEndOfWindow();
        OrFinallyTrigger aOrFinallyB = triggerA.orFinally((Trigger.OnceTrigger)triggerB);
        OrFinallyTrigger bOrFinallyA = triggerB.orFinally((Trigger.OnceTrigger)triggerA);
        Assert.assertEquals((Object)Repeatedly.forever((Trigger)triggerA.getContinuationTrigger().orFinally(triggerB.getContinuationTrigger())), (Object)aOrFinallyB.getContinuationTrigger());
        Assert.assertEquals((Object)Repeatedly.forever((Trigger)triggerB.getContinuationTrigger().orFinally(triggerA.getContinuationTrigger())), (Object)bOrFinallyA.getContinuationTrigger());
    }

    @Test
    public void testToString() {
        OrFinallyTrigger trigger = StubTrigger.named("t1").orFinally(StubTrigger.named("t2"));
        Assert.assertEquals((Object)"t1.orFinally(t2)", (Object)trigger.toString());
    }
}

