/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_core.com.google.common.collect.Lists;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.testing.CoderProperties;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IntervalWindowTest {
    private static final Coder<IntervalWindow> TEST_CODER = IntervalWindow.getCoder();
    private static final List<IntervalWindow> TEST_VALUES = Lists.newArrayList(new IntervalWindow(new Instant(0L), new Instant(0L)), new IntervalWindow(new Instant(0L), new Instant(1000L)), new IntervalWindow(new Instant(-1000L), new Instant(735L)), new IntervalWindow(new Instant(350L), new Instant(3600000L)), new IntervalWindow(new Instant(0L), new Instant(86400000L)), new IntervalWindow(Instant.parse((String)"2015-04-01T00:00:00Z"), Instant.parse((String)"2015-04-01T11:45:13Z")));

    @Test
    public void testBasicEncoding() throws Exception {
        for (IntervalWindow window : TEST_VALUES) {
            CoderProperties.coderDecodeEncodeEqual(TEST_CODER, (Object)window);
        }
    }

    @Test
    public void testLengthsOfEncodingChoices() throws Exception {
        Instant start = Instant.parse((String)"2015-04-01T00:00:00Z");
        Instant minuteEnd = Instant.parse((String)"2015-04-01T00:01:00Z");
        Instant hourEnd = Instant.parse((String)"2015-04-01T01:00:00Z");
        Instant dayEnd = Instant.parse((String)"2015-04-02T00:00:00Z");
        InstantCoder instantCoder = InstantCoder.of();
        byte[] encodedStart = CoderUtils.encodeToByteArray((Coder)instantCoder, (Object)start);
        byte[] encodedMinuteEnd = CoderUtils.encodeToByteArray((Coder)instantCoder, (Object)minuteEnd);
        byte[] encodedHourEnd = CoderUtils.encodeToByteArray((Coder)instantCoder, (Object)hourEnd);
        byte[] encodedDayEnd = CoderUtils.encodeToByteArray((Coder)instantCoder, (Object)dayEnd);
        byte[] encodedMinuteWindow = CoderUtils.encodeToByteArray(TEST_CODER, (Object)new IntervalWindow(start, minuteEnd));
        byte[] encodedHourWindow = CoderUtils.encodeToByteArray(TEST_CODER, (Object)new IntervalWindow(start, hourEnd));
        byte[] encodedDayWindow = CoderUtils.encodeToByteArray(TEST_CODER, (Object)new IntervalWindow(start, dayEnd));
        Assert.assertThat((Object)encodedMinuteWindow.length, (Matcher)Matchers.equalTo((Object)(encodedStart.length + encodedMinuteEnd.length - 5)));
        Assert.assertThat((Object)encodedHourWindow.length, (Matcher)Matchers.equalTo((Object)(encodedStart.length + encodedHourEnd.length - 4)));
        Assert.assertThat((Object)encodedDayWindow.length, (Matcher)Matchers.equalTo((Object)(encodedStart.length + encodedDayEnd.length - 4)));
    }
}

