/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.beam.sdk.testing.WindowFnTestUtils;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FixedWindowsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testSimpleFixedWindow() throws Exception {
        HashMap<IntervalWindow, Set> expected = new HashMap<IntervalWindow, Set>();
        expected.put(new IntervalWindow(new Instant(0L), new Instant(10L)), WindowFnTestUtils.set((long[])new long[]{1L, 2L, 5L, 9L}));
        expected.put(new IntervalWindow(new Instant(10L), new Instant(20L)), WindowFnTestUtils.set((long[])new long[]{10L, 11L}));
        expected.put(new IntervalWindow(new Instant(100L), new Instant(110L)), WindowFnTestUtils.set((long[])new long[]{100L}));
        Assert.assertEquals(expected, (Object)WindowFnTestUtils.runWindowFn((WindowFn)FixedWindows.of((Duration)new Duration(10L)), Arrays.asList(1L, 2L, 5L, 9L, 10L, 11L, 100L)));
    }

    @Test
    public void testFixedOffsetWindow() throws Exception {
        HashMap<IntervalWindow, Set> expected = new HashMap<IntervalWindow, Set>();
        expected.put(new IntervalWindow(new Instant(-5L), new Instant(5L)), WindowFnTestUtils.set((long[])new long[]{1L, 2L}));
        expected.put(new IntervalWindow(new Instant(5L), new Instant(15L)), WindowFnTestUtils.set((long[])new long[]{5L, 9L, 10L, 11L}));
        expected.put(new IntervalWindow(new Instant(95L), new Instant(105L)), WindowFnTestUtils.set((long[])new long[]{100L}));
        Assert.assertEquals(expected, (Object)WindowFnTestUtils.runWindowFn((WindowFn)FixedWindows.of((Duration)new Duration(10L)).withOffset(new Duration(5L)), Arrays.asList(1L, 2L, 5L, 9L, 10L, 11L, 100L)));
    }

    @Test
    public void testTimeUnit() throws Exception {
        HashMap<IntervalWindow, Set> expected = new HashMap<IntervalWindow, Set>();
        expected.put(new IntervalWindow(new Instant(-5000L), new Instant(5000L)), WindowFnTestUtils.set((long[])new long[]{1L, 2L, 1000L}));
        expected.put(new IntervalWindow(new Instant(5000L), new Instant(15000L)), WindowFnTestUtils.set((long[])new long[]{5000L, 5001L, 10000L}));
        Assert.assertEquals(expected, (Object)WindowFnTestUtils.runWindowFn((WindowFn)FixedWindows.of((Duration)Duration.standardSeconds((long)10L)).withOffset(Duration.standardSeconds((long)5L)), Arrays.asList(1L, 2L, 1000L, 5000L, 5001L, 10000L)));
    }

    @Test
    public void testDefaultWindowMappingFn() {
        FixedWindows windowFn = FixedWindows.of((Duration)Duration.standardMinutes((long)20L));
        WindowMappingFn mapping = windowFn.getDefaultWindowMappingFn();
        Assert.assertThat((Object)mapping.getSideInputWindow(new BoundedWindow(){

            public Instant maxTimestamp() {
                return new Instant(100L);
            }
        }), (Matcher)Matchers.equalTo((Object)new IntervalWindow(new Instant(0L), new Instant(0L).plus((ReadableDuration)Duration.standardMinutes((long)20L)))));
        Assert.assertThat((Object)mapping.maximumLookback(), (Matcher)Matchers.equalTo((Object)Duration.ZERO));
    }

    @Test
    public void testEndOfTime() {
        Instant endOfGlobalWindow = GlobalWindow.INSTANCE.maxTimestamp();
        FixedWindows windowFn = FixedWindows.of((Duration)Duration.standardHours((long)1L));
        IntervalWindow truncatedWindow = windowFn.assignWindow(endOfGlobalWindow.minus(1L));
        Assert.assertThat((Object)truncatedWindow.maxTimestamp(), (Matcher)Matchers.equalTo((Object)endOfGlobalWindow));
    }

    @Test
    public void testDefaultWindowMappingFnGlobalWindow() {
        FixedWindows windowFn = FixedWindows.of((Duration)Duration.standardMinutes((long)20L));
        WindowMappingFn mapping = windowFn.getDefaultWindowMappingFn();
        this.thrown.expect(IllegalArgumentException.class);
        mapping.getSideInputWindow((BoundedWindow)GlobalWindow.INSTANCE);
    }

    void checkConstructionFailure(int size, int offset) {
        try {
            FixedWindows.of((Duration)Duration.standardSeconds((long)size)).withOffset(Duration.standardSeconds((long)offset));
            Assert.fail((String)"should have failed");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.toString(), (Matcher)CoreMatchers.containsString((String)"FixedWindows WindowingStrategies must have 0 <= offset < size"));
        }
    }

    @Test
    public void testInvalidInput() throws Exception {
        this.checkConstructionFailure(-1, 0);
        this.checkConstructionFailure(1, 2);
        this.checkConstructionFailure(1, -1);
    }

    @Test
    public void testEquality() {
        Assert.assertTrue((boolean)FixedWindows.of((Duration)new Duration(10L)).isCompatible((WindowFn)FixedWindows.of((Duration)new Duration(10L))));
        Assert.assertTrue((boolean)FixedWindows.of((Duration)new Duration(10L)).isCompatible((WindowFn)FixedWindows.of((Duration)new Duration(10L))));
        Assert.assertTrue((boolean)FixedWindows.of((Duration)new Duration(10L)).isCompatible((WindowFn)FixedWindows.of((Duration)new Duration(10L))));
        Assert.assertFalse((boolean)FixedWindows.of((Duration)new Duration(10L)).isCompatible((WindowFn)FixedWindows.of((Duration)new Duration(20L))));
        Assert.assertFalse((boolean)FixedWindows.of((Duration)new Duration(10L)).isCompatible((WindowFn)FixedWindows.of((Duration)new Duration(20L))));
    }

    @Test
    public void testVerifyCompatibility() throws IncompatibleWindowException {
        FixedWindows.of((Duration)new Duration(10L)).verifyCompatibility((WindowFn)FixedWindows.of((Duration)new Duration(10L)));
        this.thrown.expect(IncompatibleWindowException.class);
        FixedWindows.of((Duration)new Duration(10L)).verifyCompatibility((WindowFn)FixedWindows.of((Duration)new Duration(20L)));
    }

    @Test
    public void testValidOutputTimes() throws Exception {
        Iterator<Integer> iterator = Arrays.asList(200, 800, 700).iterator();
        while (iterator.hasNext()) {
            long timestamp = iterator.next().intValue();
            WindowFnTestUtils.validateGetOutputTimestamp((WindowFn)FixedWindows.of((Duration)new Duration(500L)), (long)timestamp);
        }
    }

    @Test
    public void testDisplayData() {
        Duration offset = Duration.standardSeconds((long)1234L);
        Duration size = Duration.standardSeconds((long)2345L);
        FixedWindows fixedWindows = FixedWindows.of((Duration)size).withOffset(offset);
        DisplayData displayData = DisplayData.from((HasDisplayData)fixedWindows);
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("size", size));
        Assert.assertThat((Object)displayData, DisplayDataMatchers.hasDisplayItem("offset", offset));
    }
}

