/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.testing.WindowFnTestUtils;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.CalendarWindows;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CalendarWindowsTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    private static Instant makeTimestamp(int year, int month, int day, int hours, int minutes) {
        return new DateTime(year, month, day, hours, minutes, DateTimeZone.UTC).toInstant();
    }

    @Test
    public void testDays() throws Exception {
        HashMap<IntervalWindow, Set> expected = new HashMap<IntervalWindow, Set>();
        List<Long> timestamps = Arrays.asList(CalendarWindowsTest.makeTimestamp(2014, 1, 1, 0, 0).getMillis(), CalendarWindowsTest.makeTimestamp(2014, 1, 1, 23, 59).getMillis(), CalendarWindowsTest.makeTimestamp(2014, 1, 2, 0, 0).getMillis(), CalendarWindowsTest.makeTimestamp(2014, 1, 2, 5, 5).getMillis(), CalendarWindowsTest.makeTimestamp(2015, 1, 1, 0, 0).getMillis(), CalendarWindowsTest.makeTimestamp(2015, 1, 1, 5, 5).getMillis());
        expected.put(new IntervalWindow(CalendarWindowsTest.makeTimestamp(2014, 1, 1, 0, 0), CalendarWindowsTest.makeTimestamp(2014, 1, 2, 0, 0)), WindowFnTestUtils.set((long[])new long[]{timestamps.get(0), timestamps.get(1)}));
        expected.put(new IntervalWindow(CalendarWindowsTest.makeTimestamp(2014, 1, 2, 0, 0), CalendarWindowsTest.makeTimestamp(2014, 1, 3, 0, 0)), WindowFnTestUtils.set((long[])new long[]{timestamps.get(2), timestamps.get(3)}));
        expected.put(new IntervalWindow(CalendarWindowsTest.makeTimestamp(2015, 1, 1, 0, 0), CalendarWindowsTest.makeTimestamp(2015, 1, 2, 0, 0)), WindowFnTestUtils.set((long[])new long[]{timestamps.get(4), timestamps.get(5)}));
        Assert.assertEquals(expected, (Object)WindowFnTestUtils.runWindowFn((WindowFn)CalendarWindows.days((int)1), timestamps));
    }

    @Test
    public void testDaysCompatibility() throws IncompatibleWindowException {
        CalendarWindows.DaysWindows daysWindows = CalendarWindows.days((int)10);
        daysWindows.verifyCompatibility((WindowFn)CalendarWindows.days((int)10));
        this.thrown.expect(IncompatibleWindowException.class);
        daysWindows.verifyCompatibility((WindowFn)CalendarWindows.days((int)9));
    }

    @Test
    public void testWeeks() throws Exception {
        HashMap<IntervalWindow, Set> expected = new HashMap<IntervalWindow, Set>();
        List<Long> timestamps = Arrays.asList(CalendarWindowsTest.makeTimestamp(2014, 1, 1, 0, 0).getMillis(), CalendarWindowsTest.makeTimestamp(2014, 1, 5, 5, 5).getMillis(), CalendarWindowsTest.makeTimestamp(2014, 1, 8, 0, 0).getMillis(), CalendarWindowsTest.makeTimestamp(2014, 1, 12, 5, 5).getMillis(), CalendarWindowsTest.makeTimestamp(2015, 1, 1, 0, 0).getMillis(), CalendarWindowsTest.makeTimestamp(2015, 1, 6, 5, 5).getMillis());
        expected.put(new IntervalWindow(CalendarWindowsTest.makeTimestamp(2014, 1, 1, 0, 0), CalendarWindowsTest.makeTimestamp(2014, 1, 8, 0, 0)), WindowFnTestUtils.set((long[])new long[]{timestamps.get(0), timestamps.get(1)}));
        expected.put(new IntervalWindow(CalendarWindowsTest.makeTimestamp(2014, 1, 8, 0, 0), CalendarWindowsTest.makeTimestamp(2014, 1, 15, 0, 0)), WindowFnTestUtils.set((long[])new long[]{timestamps.get(2), timestamps.get(3)}));
        expected.put(new IntervalWindow(CalendarWindowsTest.makeTimestamp(2014, 12, 31, 0, 0), CalendarWindowsTest.makeTimestamp(2015, 1, 7, 0, 0)), WindowFnTestUtils.set((long[])new long[]{timestamps.get(4), timestamps.get(5)}));
        Assert.assertEquals(expected, (Object)WindowFnTestUtils.runWindowFn((WindowFn)CalendarWindows.weeks((int)1, (int)3), timestamps));
    }

    @Test
    public void testMonths() throws Exception {
        HashMap<IntervalWindow, Set> expected = new HashMap<IntervalWindow, Set>();
        List<Long> timestamps = Arrays.asList(CalendarWindowsTest.makeTimestamp(2014, 1, 1, 0, 0).getMillis(), CalendarWindowsTest.makeTimestamp(2014, 1, 31, 5, 5).getMillis(), CalendarWindowsTest.makeTimestamp(2014, 2, 1, 0, 0).getMillis(), CalendarWindowsTest.makeTimestamp(2014, 2, 15, 5, 5).getMillis(), CalendarWindowsTest.makeTimestamp(2015, 1, 1, 0, 0).getMillis(), CalendarWindowsTest.makeTimestamp(2015, 1, 31, 5, 5).getMillis());
        expected.put(new IntervalWindow(CalendarWindowsTest.makeTimestamp(2014, 1, 1, 0, 0), CalendarWindowsTest.makeTimestamp(2014, 2, 1, 0, 0)), WindowFnTestUtils.set((long[])new long[]{timestamps.get(0), timestamps.get(1)}));
        expected.put(new IntervalWindow(CalendarWindowsTest.makeTimestamp(2014, 2, 1, 0, 0), CalendarWindowsTest.makeTimestamp(2014, 3, 1, 0, 0)), WindowFnTestUtils.set((long[])new long[]{timestamps.get(2), timestamps.get(3)}));
        expected.put(new IntervalWindow(CalendarWindowsTest.makeTimestamp(2015, 1, 1, 0, 0), CalendarWindowsTest.makeTimestamp(2015, 2, 1, 0, 0)), WindowFnTestUtils.set((long[])new long[]{timestamps.get(4), timestamps.get(5)}));
        Assert.assertEquals(expected, (Object)WindowFnTestUtils.runWindowFn((WindowFn)CalendarWindows.months((int)1), timestamps));
    }

    @Test
    public void testMonthsCompatibility() throws IncompatibleWindowException {
        CalendarWindows.MonthsWindows monthsWindows = CalendarWindows.months((int)10).beginningOnDay(15);
        monthsWindows.verifyCompatibility((WindowFn)CalendarWindows.months((int)10).beginningOnDay(15));
        this.thrown.expect(IncompatibleWindowException.class);
        monthsWindows.verifyCompatibility((WindowFn)CalendarWindows.months((int)10).beginningOnDay(30));
    }

    @Test
    public void testMultiMonths() throws Exception {
        HashMap<IntervalWindow, Set> expected = new HashMap<IntervalWindow, Set>();
        List<Long> timestamps = Arrays.asList(CalendarWindowsTest.makeTimestamp(2014, 3, 5, 0, 0).getMillis(), CalendarWindowsTest.makeTimestamp(2014, 10, 4, 23, 59).getMillis(), CalendarWindowsTest.makeTimestamp(2014, 10, 5, 0, 0).getMillis(), CalendarWindowsTest.makeTimestamp(2015, 3, 1, 0, 0).getMillis(), CalendarWindowsTest.makeTimestamp(2016, 1, 5, 0, 0).getMillis(), CalendarWindowsTest.makeTimestamp(2016, 1, 31, 5, 5).getMillis());
        expected.put(new IntervalWindow(CalendarWindowsTest.makeTimestamp(2014, 3, 5, 0, 0), CalendarWindowsTest.makeTimestamp(2014, 10, 5, 0, 0)), WindowFnTestUtils.set((long[])new long[]{timestamps.get(0), timestamps.get(1)}));
        expected.put(new IntervalWindow(CalendarWindowsTest.makeTimestamp(2014, 10, 5, 0, 0), CalendarWindowsTest.makeTimestamp(2015, 5, 5, 0, 0)), WindowFnTestUtils.set((long[])new long[]{timestamps.get(2), timestamps.get(3)}));
        expected.put(new IntervalWindow(CalendarWindowsTest.makeTimestamp(2015, 12, 5, 0, 0), CalendarWindowsTest.makeTimestamp(2016, 7, 5, 0, 0)), WindowFnTestUtils.set((long[])new long[]{timestamps.get(4), timestamps.get(5)}));
        Assert.assertEquals(expected, (Object)WindowFnTestUtils.runWindowFn((WindowFn)CalendarWindows.months((int)7).withStartingMonth(2014, 3).beginningOnDay(5), timestamps));
    }

    @Test
    public void testYears() throws Exception {
        HashMap<IntervalWindow, Set> expected = new HashMap<IntervalWindow, Set>();
        List<Long> timestamps = Arrays.asList(CalendarWindowsTest.makeTimestamp(2000, 5, 5, 0, 0).getMillis(), CalendarWindowsTest.makeTimestamp(2010, 5, 4, 23, 59).getMillis(), CalendarWindowsTest.makeTimestamp(2010, 5, 5, 0, 0).getMillis(), CalendarWindowsTest.makeTimestamp(2015, 3, 1, 0, 0).getMillis(), CalendarWindowsTest.makeTimestamp(2052, 1, 5, 0, 0).getMillis(), CalendarWindowsTest.makeTimestamp(2060, 5, 4, 5, 5).getMillis());
        expected.put(new IntervalWindow(CalendarWindowsTest.makeTimestamp(2000, 5, 5, 0, 0), CalendarWindowsTest.makeTimestamp(2010, 5, 5, 0, 0)), WindowFnTestUtils.set((long[])new long[]{timestamps.get(0), timestamps.get(1)}));
        expected.put(new IntervalWindow(CalendarWindowsTest.makeTimestamp(2010, 5, 5, 0, 0), CalendarWindowsTest.makeTimestamp(2020, 5, 5, 0, 0)), WindowFnTestUtils.set((long[])new long[]{timestamps.get(2), timestamps.get(3)}));
        expected.put(new IntervalWindow(CalendarWindowsTest.makeTimestamp(2050, 5, 5, 0, 0), CalendarWindowsTest.makeTimestamp(2060, 5, 5, 0, 0)), WindowFnTestUtils.set((long[])new long[]{timestamps.get(4), timestamps.get(5)}));
        Assert.assertEquals(expected, (Object)WindowFnTestUtils.runWindowFn((WindowFn)CalendarWindows.years((int)10).withStartingYear(2000).beginningOnDay(5, 5), timestamps));
    }

    @Test
    public void testYearsCompatibility() throws IncompatibleWindowException {
        CalendarWindows.YearsWindows yearsWindows = CalendarWindows.years((int)2017).beginningOnDay(1, 1);
        yearsWindows.verifyCompatibility((WindowFn)CalendarWindows.years((int)2017).beginningOnDay(1, 1));
        this.thrown.expect(IncompatibleWindowException.class);
        yearsWindows.verifyCompatibility((WindowFn)CalendarWindows.years((int)2017).beginningOnDay(1, 2));
    }

    @Test
    public void testTimeZone() throws Exception {
        HashMap<IntervalWindow, Set> expected = new HashMap<IntervalWindow, Set>();
        DateTimeZone timeZone = DateTimeZone.forID((String)"America/Los_Angeles");
        List<Long> timestamps = Arrays.asList(new DateTime(2014, 1, 1, 0, 0, timeZone).getMillis(), new DateTime(2014, 1, 1, 23, 59, timeZone).getMillis(), new DateTime(2014, 1, 2, 8, 0, DateTimeZone.UTC).getMillis(), new DateTime(2014, 1, 3, 7, 59, DateTimeZone.UTC).getMillis());
        expected.put(new IntervalWindow(new DateTime(2014, 1, 1, 0, 0, timeZone).toInstant(), new DateTime(2014, 1, 2, 0, 0, timeZone).toInstant()), WindowFnTestUtils.set((long[])new long[]{timestamps.get(0), timestamps.get(1)}));
        expected.put(new IntervalWindow(new DateTime(2014, 1, 2, 0, 0, timeZone).toInstant(), new DateTime(2014, 1, 3, 0, 0, timeZone).toInstant()), WindowFnTestUtils.set((long[])new long[]{timestamps.get(2), timestamps.get(3)}));
        Assert.assertEquals(expected, (Object)WindowFnTestUtils.runWindowFn((WindowFn)CalendarWindows.days((int)1).withTimeZone(timeZone), timestamps));
    }

    @Test
    public void testDefaultWindowMappingFn() {
        CalendarWindows.MonthsWindows windowFn = CalendarWindows.months((int)2);
        WindowMappingFn mapping = windowFn.getDefaultWindowMappingFn();
        MatcherAssert.assertThat((Object)mapping.getSideInputWindow(new BoundedWindow(){

            public Instant maxTimestamp() {
                return new Instant(100L);
            }
        }), (Matcher)Matchers.equalTo((Object)windowFn.assignWindow(new Instant(100L))));
        MatcherAssert.assertThat((Object)mapping.maximumLookback(), (Matcher)Matchers.equalTo((Object)Duration.ZERO));
    }

    @Test
    public void testDefaultWindowMappingFnGlobal() {
        CalendarWindows.MonthsWindows windowFn = CalendarWindows.months((int)2);
        WindowMappingFn mapping = windowFn.getDefaultWindowMappingFn();
        this.thrown.expect(IllegalArgumentException.class);
        mapping.getSideInputWindow((BoundedWindow)GlobalWindow.INSTANCE);
    }

    @Test
    public void testDisplayData() {
        DateTimeZone timeZone = DateTimeZone.forID((String)"America/Los_Angeles");
        Instant jan1 = new DateTime(1990, 1, 1, 0, 0, timeZone).toInstant();
        CalendarWindows.DaysWindows daysWindow = CalendarWindows.days((int)5).withStartingDay(1990, 1, 1).withTimeZone(timeZone);
        DisplayData daysDisplayData = DisplayData.from((HasDisplayData)daysWindow);
        MatcherAssert.assertThat((Object)daysDisplayData, DisplayDataMatchers.hasDisplayItem("numDays", 5L));
        MatcherAssert.assertThat((Object)daysDisplayData, DisplayDataMatchers.hasDisplayItem("startDate", jan1));
        CalendarWindows.MonthsWindows monthsWindow = CalendarWindows.months((int)2).withStartingMonth(1990, 1).withTimeZone(timeZone);
        DisplayData monthsDisplayData = DisplayData.from((HasDisplayData)monthsWindow);
        MatcherAssert.assertThat((Object)monthsDisplayData, DisplayDataMatchers.hasDisplayItem("numMonths", 2L));
        MatcherAssert.assertThat((Object)monthsDisplayData, DisplayDataMatchers.hasDisplayItem("startDate", jan1));
        CalendarWindows.YearsWindows yearsWindow = CalendarWindows.years((int)4).withStartingYear(1990).withTimeZone(timeZone);
        DisplayData yearsDisplayData = DisplayData.from((HasDisplayData)yearsWindow);
        MatcherAssert.assertThat((Object)yearsDisplayData, DisplayDataMatchers.hasDisplayItem("numYears", 4L));
        MatcherAssert.assertThat((Object)yearsDisplayData, DisplayDataMatchers.hasDisplayItem("startDate", jan1));
    }
}

