/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.Never;
import org.apache.beam.sdk.transforms.windowing.StubTrigger;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AfterWatermarkTest {
    @Test
    public void testFromEndOfWindowToString() {
        AfterWatermark.FromEndOfWindow trigger = AfterWatermark.pastEndOfWindow();
        Assert.assertEquals((Object)"AfterWatermark.pastEndOfWindow()", (Object)trigger.toString());
    }

    @Test
    public void testEarlyFiringsToString() {
        AfterWatermark.AfterWatermarkEarlyAndLate trigger = AfterWatermark.pastEndOfWindow().withEarlyFirings((Trigger.OnceTrigger)StubTrigger.named("t1"));
        Assert.assertEquals((Object)"AfterWatermark.pastEndOfWindow().withEarlyFirings(t1)", (Object)trigger.toString());
    }

    @Test
    public void testLateFiringsToString() {
        AfterWatermark.AfterWatermarkEarlyAndLate trigger = AfterWatermark.pastEndOfWindow().withLateFirings((Trigger.OnceTrigger)StubTrigger.named("t1"));
        Assert.assertEquals((Object)"AfterWatermark.pastEndOfWindow().withLateFirings(t1)", (Object)trigger.toString());
    }

    @Test
    public void testEarlyAndLateFiringsToString() {
        AfterWatermark.AfterWatermarkEarlyAndLate trigger = AfterWatermark.pastEndOfWindow().withEarlyFirings((Trigger.OnceTrigger)StubTrigger.named("t1")).withLateFirings((Trigger.OnceTrigger)StubTrigger.named("t2"));
        Assert.assertEquals((Object)"AfterWatermark.pastEndOfWindow().withEarlyFirings(t1).withLateFirings(t2)", (Object)trigger.toString());
    }

    @Test
    public void testToStringExcludesNeverTrigger() {
        AfterWatermark.AfterWatermarkEarlyAndLate trigger = AfterWatermark.pastEndOfWindow().withEarlyFirings((Trigger.OnceTrigger)Never.ever()).withLateFirings((Trigger.OnceTrigger)Never.ever());
        Assert.assertEquals((Object)"AfterWatermark.pastEndOfWindow()", (Object)trigger.toString());
    }
}

